###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openoffice_emf_file_parser_vuln_lin.nasl 4627 2009-14-09 11:10:56 sep $
#
# OpenOffice EMF File Parser Remote Command Execution Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901019);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"8.5");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2139");
  script_bugtraq_id(36291);
  script_name("OpenOffice EMF File Parser Remote Command Execution Vulnerability (Linux)");
  desc = "
  Overview: The host has OpenOffice installed and is prone to Remote Command
  Execution Vulnerability

  Vulnerability Insight:
  An Unspecified error occurs in the parser of EMF files when parsing certain
  crafted EMF files.

  Impact:
  Successful remote exploitation could result in arbitrary code execution.

  Impact Level: System/Application

  Affected Software/OS:
  OpenOffice Version 2.x and 3.x on windows.

  Fix: Upgrade to OpenOffice Version 3.1.1 or later
  For Updates Refer, http://www.openoffice.org/

  References:
  http://www.debian.org/security/2009/dsa-1880

  CVSS Score:
    CVSS Base Score      : 8.5 (AV:N/AC:M/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score  : 6.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of OpenOffice");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_openoffice_detect_lin.nasl");
  script_require_keys("OpenOffice/Linux/Ver");
  exit(0);
}


include("version_func.inc");

openVer = get_kb_item("OpenOffice/Linux/Ver");

if(!openVer)
{
  exit(0);
}

if(version_in_range(version:openVer, test_version:"2.0",
                                    test_version2:"3.1.1")){
  security_hole(0);
}
