###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_netscape_detect_win.nasl 3578 2009-07-28 21:13:29Z jul $
#
# Netscape Version Detection (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900392);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Netscape Version Detection (Win)");
  desc = "

  Overview: This script detects the installed version of Netscape browser
  and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of Netscape");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(registry_key_exists(key:"SOFTWARE\Netscape"))
{
  foreach item (registry_enum_keys(key:"SOFTWARE\Netscape\"))
  {
    scapeVer = registry_get_sz(key:"SOFTWARE\Netscape\" + item,
                               item:"CurrentVersion");
    if(scapeVer != NULL)
    {
      scapeVer = eregmatch(pattern:"([0-9]\.[0-9.]+)", string:scapeVer);
      if(scapeVer[1] != NULL){
        set_kb_item(name:"Netscape/Win/Ver", value:scapeVer[1]);
        security_note(data:"Netscape version " + scapeVer[1] + 
                           " was detected on the host");
      }
    }
  }
}
