###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apache_tiles_xss_vuln.nasl 1632 2009-04-24 21:02:12Z apr $
#
# Apache Tiles Multiple XSS Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900496);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1275");
  script_bugtraq_id(34657);
  script_name("Apache Tiles Multiple XSS Vulnerability");
  desc = "

  Overview: This host has Apache Tiles installed and is prone to Cross-Site
  Script Vulnerability

  Vulnerability Insight:
  This flaw is due to attribute values or templates are defined using some
  JSP tags 'tiles:putAttribute', 'tiles:insertTemplate' are evaluated twice.

  Impact:
  Successful exploitation will let the attacker access the server context
  inside the tiles web application and perform XSS attacks.

  Impact Level: System/Application

  Affected Software/OS:
  Apache Tiles version 2.1 to 2.1.1

  Fix: Upgrade your Apache Tiles version to 2.1.2
  http://tiles.apache.org/download.html

  References:
  https://issues.apache.org/struts/browse/TILES-351
  http://svn.apache.org/viewvc/tiles/framework/trunk/src/site/apt/security/security-bulletin-1.apt?revision=741913

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Apache Tiles");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_apache_tiles_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

tilesPort = get_http_port(default:8080);
if(!tilesPort){
  exit();
}

if(!get_port_state(tilesPort)){
  exit(0);
}

version = get_kb_item("www/" + tilesPort + "/Apache/Tiles");
version = eregmatch(pattern:"^(.+) under (/.*)$", string:version);
if(version[1] == NULL){
  exit(0);
}

if(version_in_range(version:version[1], test_version:"2.1",
                    test_version2:"2.1.1")){
  security_warning(tilesPort);
}
