###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_icq_bof_vuln.nasl 2685 2009-06-05 13:12:24Z june $
#
# ICQ 'ICQToolBar.dll' Buffer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800808);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-1915");
  script_bugtraq_id(35150);
  script_name("ICQ 'ICQToolBar.dll' Buffer Overflow Vulnerability");
  desc = "

  Overview: This host has ICQ installed and is prone to Stack-based Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  Error caused due to improper bounds checking by the ICQToolBar.dll and
  this can be caused via an Internet shortcut .URL file containing a long
  URL parameter, when browsing a folder that contains this file.

  Impact:
  An attacker may leverage this issue by execute arbitrary code and buffer
  overflow in the context of affected system, and can cause the application
  to crash (persistent).

  Impact Level: System/Application

  Affected Software/OS:
  ICQ version 6.5 on Windows

  Fix: No solution or patch is available as on 05th June, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.icq.com

  References:
  http://www.milw0rm.com/exploits/8832
  http://xforce.iss.net/xforce/xfdb/50858

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ICQ");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_icq_detect.nasl");
  script_require_keys("ICQ/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

icqVer = get_kb_item("ICQ/Ver");
if(!icqVer){
  exit(0);
}

# Grep for the version 6.5 (6.5.0.1042)
if(version_is_equal(version:icqVer, test_version:"6.5.0.1042"))
{
  # To Get the Installed Location
  dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                "\Uninstall\ICQToolbar", item:"DisplayIcon");
  if(dllPath == NULL){
    exit(0);
  }

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                      string:dllPath - "\icq6Toolbar.ico" + "\ICQToolBar.dll");
  dllVer = GetVer(share:share, file:file);

  # Check for ICQToolBar.dll file version <= 3.0.0 and Its existence
  if(version_is_less_equal(version:dllVer, test_version:"3.0.0")){
    security_hole(0);
  }
}
