###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for slim FEDORA-2009-13551
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861602);
  script_version("$Revision: 8150 $: 1.0");
  script_tag(name:"cvss_base", value:"2.1");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2009-13551");
  script_cve_id("CVE-2009-1756");
  script_name("Fedora Update for slim FEDORA-2009-13551");
  desc = "

  Vulnerability Insight:
  SLiM (Simple Login Manager) is a graphical login manager for X11.
  It aims to be simple, fast and independent from the various
  desktop environments.
  SLiM is based on latest stable release of Login.app by Per Lidn.
  
  In the distribution, slim may be called through a wrapper, slim-dynwm,
  which determines the available window managers using the freedesktop
  information and modifies the slim configuration file accordingly,
  before launching slim.


  Affected Software/OS:
  slim on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2010-January/msg00000.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of slim");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"slim", rpm:"slim~1.3.1~9.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}