//                                               -*- C++ -*-
/**
 *  @file  t_Polygon_std.cxx
 *  @brief The test file of class Polygon for standard methods
 *
 *  Copyright (C) 2005-2013 EDF-EADS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012)
 */
#include "OT.hxx"
#include "OTtestcode.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try
  {

    // Generate the data for the polygons to be drawn
    UnsignedLong size = 50;
    NumericalPoint cursor(2);

    NumericalSample data1(size, 2); //polygon y = 2x for x in [-2;5]
    NumericalSample data2(size, 2); //polygon y = x*x for x in [-1;1]

    NumericalScalar tmp;
    for(UnsignedLong i = 0; i < size; i++)
    {
      tmp = 7.*i / size + 2;
      cursor[0] = tmp;
      cursor[1] = 2 * tmp;
      data1[i] = cursor;

      tmp = 9.*i / size + 1;
      cursor[0] = tmp;
      cursor[1] = tmp * tmp;
      data2[i] = cursor;
    }

    // Create an empty graph
    Graph myGraph("Some polygons", "x1", "x2", true, "topright", 1.0, GraphImplementation::NONE);

    // Create the first polygon
    // Must prefix by OT to avoid conflict with Windows API
    OT::Polygon myPolygon1(data1);
    myPolygon1.setColor("blue");

    // Then, draw it
    myGraph.add(myPolygon1);
    myGraph.draw("Graph_Polygon_a_OT", 640, 480);

    // Check that the correct files have been generated by computing their checksum
    fullprint << "bitmap=" << myGraph.getBitmap() << std::endl;
    fullprint << "postscript=" << myGraph.getPostscript() << std::endl;

    // Create the second cloud
    // Must prefix by OT to avoid conflict with Windows API
    OT::Polygon myPolygon2(data2);
    myPolygon2.setColor("red");

    // Add it to the graph and draw everything
    myGraph.add(myPolygon2);
    for (UnsignedLong i = 0; i < 4; ++i)
    {
      myGraph.setLogScale(static_cast<GraphImplementation::LogScale>(i));
      myGraph.draw(String(OSS() << "Graph_Polygon_b_OT_" << i), 640, 480);
      fullprint << "bitmap=" << myGraph.getBitmap() << std::endl;
      fullprint << "postscript=" << myGraph.getPostscript() << std::endl;
    }
  }
  catch (TestFailed & ex)
  {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
