/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_ProcessorCoreHardwareThreadAccess.h"

int CPU_OpenDRIM_ProcessorCoreHardwareThread_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(CPU_CIM_ManagedElement_load(broker, errorMessage));
	CF_assert(CPU_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(CPU_CIM_ManagedElement_unload(errorMessage));
	CF_assert(CPU_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_isAssociated(const Instance& PartComponent, const Instance& GroupComponent, bool& isAssociated, string& errorMessage) {
	_E_;
	// Determine if the association can be established or not
	isAssociated=false;
	string core_instance_id;
	string thread_instance_id;
	GroupComponent.getProperty("InstanceID", core_instance_id);
	PartComponent.getProperty("InstanceID", thread_instance_id);
	
	// processor core InstanceID must contain 2 numerical values seperated by ':'
	vector<string> core_instance_id_elements;
	CF_splitText(core_instance_id_elements, core_instance_id, ':');
	if (core_instance_id_elements.size() != 2)
		return OK;
	if (!CF_isNumber(core_instance_id_elements[0]) || !CF_isNumber(core_instance_id_elements[1]))
		return OK;
	unsigned int first_core_instance_id_element = atoll(core_instance_id_elements[0].c_str());
	unsigned int second_core_instance_id_element = atoll(core_instance_id_elements[1].c_str());
	
	// hardware thread InstanceID must contain 3 numerical values seperated by ':'
	vector<string> thread_instance_id_elements;
	CF_splitText(thread_instance_id_elements, thread_instance_id, ':');
	if (thread_instance_id_elements.size() != 3)
		return OK;
	if (!CF_isNumber(thread_instance_id_elements[0]) || !CF_isNumber(thread_instance_id_elements[1]) || !CF_isNumber(thread_instance_id_elements[2]))
		return OK;
	unsigned int first_thread_instance_id_element = atoll(thread_instance_id_elements[0].c_str());
	unsigned int second_thread_instance_id_element = atoll(thread_instance_id_elements[1].c_str());
	
	// the first element and the second element of the thread InstanceID must match the core InstanceID
	if (first_thread_instance_id_element == first_core_instance_id_element && second_thread_instance_id_element == second_core_instance_id_element)
		isAssociated = true;
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ProcessorCoreHardwareThread>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_enumeratePartComponents(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_enumeratePartComponents(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		CPU_OpenDRIM_ProcessorCoreHardwareThread_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			PartComponent_classnames[0], GroupComponent_classnames[0],
			PartComponent_role.c_str(), GroupComponent_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_referencePartComponentToGroupComponent(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ProcessorCoreHardwareThread& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath PartComponent_objectpath;
	instance.getPartComponent(PartComponent_objectpath);
	Instance PartComponent_instance;
	CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_getPartComponent(broker, ctx, PartComponent_objectpath, PartComponent_instance, NULL, errorMessage));
	
	Objectpath GroupComponent_objectpath;
	instance.getGroupComponent(GroupComponent_objectpath);
	Instance GroupComponent_instance;
	CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_getGroupComponent(broker, ctx, GroupComponent_objectpath, GroupComponent_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_isAssociated(PartComponent_instance, GroupComponent_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorCoreHardwareThread& newInstance, const OpenDRIM_ProcessorCoreHardwareThread& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorCoreHardwareThread& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorCoreHardwareThread& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> GroupComponent_instances;
	if (discriminant=="a")
		CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_enumerateGroupComponents(broker, ctx, GroupComponent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<GroupComponent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_isAssociated(PartComponent_instance, GroupComponent_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			GroupComponent_associatedInstances.push_back(GroupComponent_instances[i]);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> PartComponent_instances;
	if (discriminant=="a")
		CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_enumeratePartComponents(broker, ctx, PartComponent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<PartComponent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(CPU_OpenDRIM_ProcessorCoreHardwareThread_isAssociated(PartComponent_instances[i], GroupComponent_instance, isAssociated, errorMessage));
		if (isAssociated)
			PartComponent_associatedInstances.push_back(PartComponent_instances[i]);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_ProcessorCoreHardwareThread>& OpenDRIM_ProcessorCoreHardwareThread_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < GroupComponent_instances.size(); i++) {
		OpenDRIM_ProcessorCoreHardwareThread instance;
		instance.setPartComponent(((Instance) PartComponent_instance).getObjectpath());
		instance.setGroupComponent(((Instance) GroupComponent_instances[i]).getObjectpath());
		
		OpenDRIM_ProcessorCoreHardwareThread_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_ProcessorCoreHardwareThread>& OpenDRIM_ProcessorCoreHardwareThread_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < PartComponent_instances.size(); i++) {
		OpenDRIM_ProcessorCoreHardwareThread instance;
		instance.setPartComponent(((Instance) PartComponent_instances[i]).getObjectpath());
		instance.setGroupComponent(((Instance) GroupComponent_instance).getObjectpath());
		
		OpenDRIM_ProcessorCoreHardwareThread_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_ProcessorCoreHardwareThread_populate(OpenDRIM_ProcessorCoreHardwareThread& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

