<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [PageEmittedEvents](./puppeteer.pageemittedevents.md)

## PageEmittedEvents enum

All the events that a page instance may emit.

<b>Signature:</b>

```typescript
export declare const enum PageEmittedEvents 
```

## Enumeration Members

|  Member | Value | Description |
|  --- | --- | --- |
|  Close | <code>&quot;close&quot;</code> | Emitted when the page closes. |
|  Console | <code>&quot;console&quot;</code> | Emitted when JavaScript within the page calls one of console API methods, e.g. <code>console.log</code> or <code>console.dir</code>. Also emitted if the page throws an error or a warning. |
|  Dialog | <code>&quot;dialog&quot;</code> | Emitted when a JavaScript dialog appears, such as <code>alert</code>, <code>prompt</code>, <code>confirm</code> or <code>beforeunload</code>. Puppeteer can respond to the dialog via [Dialog.accept()](./puppeteer.dialog.accept.md) or [Dialog.dismiss()](./puppeteer.dialog.dismiss.md). |
|  DOMContentLoaded | <code>&quot;domcontentloaded&quot;</code> | Emitted when the JavaScript [DOMContentLoaded](https://developer.mozilla.org/en-US/docs/Web/Events/DOMContentLoaded) event is dispatched. |
|  Error | <code>&quot;error&quot;</code> | Emitted when the page crashes. Will contain an <code>Error</code>. |
|  FrameAttached | <code>&quot;frameattached&quot;</code> | Emitted when a frame is attached. Will contain a [Frame](./puppeteer.frame.md). |
|  FrameDetached | <code>&quot;framedetached&quot;</code> | Emitted when a frame is detached. Will contain a [Frame](./puppeteer.frame.md). |
|  FrameNavigated | <code>&quot;framenavigated&quot;</code> | Emitted when a frame is navigated to a new URL. Will contain a [Frame](./puppeteer.frame.md). |
|  Load | <code>&quot;load&quot;</code> | Emitted when the JavaScript [load](https://developer.mozilla.org/en-US/docs/Web/Events/load) event is dispatched. |
|  Metrics | <code>&quot;metrics&quot;</code> | Emitted when the JavaScript code makes a call to <code>console.timeStamp</code>. For the list of metrics see [page.metrics](./puppeteer.page.metrics.md). |
|  PageError | <code>&quot;pageerror&quot;</code> | Emitted when an uncaught exception happens within the page. Contains an <code>Error</code>. |
|  Popup | <code>&quot;popup&quot;</code> | Emitted when the page opens a new tab or window.Contains a [Page](./puppeteer.page.md) corresponding to the popup window. |
|  Request | <code>&quot;request&quot;</code> | Emitted when a page issues a request and contains a [HTTPRequest](./puppeteer.httprequest.md). |
|  RequestFailed | <code>&quot;requestfailed&quot;</code> | Emitted when a request fails, for example by timing out.Contains a [HTTPRequest](./puppeteer.httprequest.md). |
|  RequestFinished | <code>&quot;requestfinished&quot;</code> | Emitted when a request finishes successfully. Contains a [HTTPRequest](./puppeteer.httprequest.md). |
|  RequestServedFromCache | <code>&quot;requestservedfromcache&quot;</code> | Emitted when a request ended up loading from cache. Contains a [HTTPRequest](./puppeteer.httprequest.md). |
|  Response | <code>&quot;response&quot;</code> | Emitted when a response is received. Contains a [HTTPResponse](./puppeteer.httpresponse.md). |
|  WorkerCreated | <code>&quot;workercreated&quot;</code> | Emitted when a dedicated [WebWorker](https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API) is spawned by the page. |
|  WorkerDestroyed | <code>&quot;workerdestroyed&quot;</code> | Emitted when a dedicated [WebWorker](https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API) is destroyed by the page. |

