---
id: fast-foundation.columndefinition
title: ColumnDefinition interface
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [ColumnDefinition](./fast-foundation.columndefinition.md)

## ColumnDefinition interface

Defines a column in the grid

<b>Signature:</b>

```typescript
export interface ColumnDefinition 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [cellFocusTargetCallback](./fast-foundation.columndefinition.cellfocustargetcallback.md) | (cell: [DataGridCell](./fast-foundation.datagridcell.md)<!-- -->) =&gt; HTMLElement | Callback function that returns the element to focus in a custom cell. When cellInternalFocusQueue is false this function is called when the cell is first focused to immediately move focus to a cell element, for example a cell that is a checkbox could move focus directly to the checkbox. When cellInternalFocusQueue is true this function is called when the user hits Enter or F2 |
|  [cellInternalFocusQueue](./fast-foundation.columndefinition.cellinternalfocusqueue.md) | boolean | Whether the cell has an internal focus queue |
|  [cellTemplate](./fast-foundation.columndefinition.celltemplate.md) | [ViewTemplate](./fast-element.viewtemplate.md) | cell template |
|  [columnDataKey](./fast-foundation.columndefinition.columndatakey.md) | string | Identifies the data item to be displayed in this column (i.e. how the data item is labelled in each row) |
|  [gridColumn](./fast-foundation.columndefinition.gridcolumn.md) | string | Sets the css grid-column property on the cell which controls its placement in the parent row. If left unset the cells will set this value to match the index of their column in the parent collection of ColumnDefinitions. |
|  [headerCellFocusTargetCallback](./fast-foundation.columndefinition.headercellfocustargetcallback.md) | (cell: [DataGridCell](./fast-foundation.datagridcell.md)<!-- -->) =&gt; HTMLElement | Callback function that returns the element to focus in a custom cell. When headerCellInternalFocusQueue is false this function is called when the cell is first focused to immediately move focus to a cell element, for example a cell that is a checkbox could move focus directly to the checkbox. When headerCellInternalFocusQueue is true this function is called when the user hits Enter or F2 |
|  [headerCellInternalFocusQueue](./fast-foundation.columndefinition.headercellinternalfocusqueue.md) | boolean | Whether the header cell has an internal focus queue |
|  [headerCellTemplate](./fast-foundation.columndefinition.headercelltemplate.md) | [ViewTemplate](./fast-element.viewtemplate.md) | Header cell template |
|  [isRowHeader](./fast-foundation.columndefinition.isrowheader.md) | boolean | Whether this column is the row header |
|  [title](./fast-foundation.columndefinition.title.md) | string | Column title, if not provided columnDataKey is used as title |
