## Release history

See [the CHANGELOG](changelog.md) for updates.

## Usage

**Params**

- `object`: The object on which to define the property.
- `key`: The name of the property to be defined or modified.
- `value`: The value or descriptor of the property being defined or modified.

```js
var define = require('{%= name %}');
var obj = {};
define(obj, 'foo', function(val) {
  return val.toUpperCase();
});

// by default, defined properties are non-enumberable
console.log(obj);
//=> {}

console.log(obj.foo('bar'));
//=> 'BAR'
```

**defining setters/getters**

Pass the same properties you would if using [Object.defineProperty][object] or [Reflect.defineProperty][reflect]. 

```js
define(obj, 'foo', {
  set: function() {},
  get: function() {}
});
```

[object]: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/defineProperty
[reflect]: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/defineProperty
