<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/integrations/softirq_statistics.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/metadata.yaml"
sidebar_label: "SoftIRQ statistics"
learn_status: "Published"
learn_rel_path: "Data Collection/Linux Systems/CPU"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# SoftIRQ statistics


<img src="https://netdata.cloud/img/linuxserver.svg" width="150"/>


Plugin: proc.plugin
Module: /proc/softirqs

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

In the Linux kernel, handling of hardware interrupts is split into two halves: the top half and the bottom half.
The top half is the routine that responds immediately to an interrupt, while the bottom half is deferred to be processed later.

Softirqs are a mechanism in the Linux kernel used to handle the bottom halves of interrupts, which can be
deferred and processed later in a context where it's safe to enable interrupts.

The actual work of handling the interrupt is offloaded to a softirq and executed later when the system
decides it's a good time to process them. This helps to keep the system responsive by not blocking the top
half for too long, which could lead to missed interrupts.

Monitoring `/proc/softirqs` is useful for:

- **Performance tuning**: A high rate of softirqs could indicate a performance issue. For instance, a high
  rate of network softirqs (`NET_RX` and `NET_TX`) could indicate a network performance issue.

- **Troubleshooting**: If a system is behaving unexpectedly, checking the softirqs could provide clues about
  what is going on. For example, a sudden increase in block device softirqs (BLOCK) might indicate a problem
  with a disk.

- **Understanding system behavior**: Knowing what types of softirqs are happening can help you understand what
  your system is doing, particularly in terms of how it's interacting with hardware and how it's handling
  interrupts.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per SoftIRQ statistics instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.softirqs | a dimension per softirq | softirqs/s |

### Per cpu core



Labels:

| Label      | Description     |
|:-----------|:----------------|
| cpu | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cpu.softirqs | a dimension per softirq | softirqs/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

There is no configuration file.
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


