/*
 * NASPRO - The NASPRO Architecture for Sound PROcessing
 * Core library
 *
 * Copyright (C) 2007-2013 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

/*
   Title: User environment

   User environment.
 */

#ifndef _NASPRO_CORE_ENV_H
#define _NASPRO_CORE_ENV_H

#ifndef _NASPRO_CORE_LIB_H
# error Only <NASPRO/core/lib.h> can be included directly.
#endif

NACORE_BEGIN_C_DECLS

/*
   Function: nacore_env_get()

   Gets the value of an environment variable.

   This function may be thread-safe or not depending on the platform.

   If it is not thread-safe on the target platform, calls to this function in
   multi-threaded applications should be also synchronized w.r.t. other
   functions that access and/or modify environment variables.

   The returned string must not be modified or free()d and must be passed to
   <nacore_env_free()> when it is no more needed.

   Parameters:

     name	- Variable name.

   Returns:

     String holding the content of the specified environment variable or NULL,
     in which case errno is set to ENOMEM if there was not enough memory,
     ENOENT if the specified environment variable was not set or
     <NACORE_EUNKNOWN> if another kind of error happened.
 */
_NACORE_DEF const char *
nacore_env_get(const char *name);

/*
   Function: nacore_env_free()

   Dismisses a value returned by <nacore_env_get()>.

   This function may be thread-safe or not depending on the platform.

   Parameters:

     value	- The pointer returned by <nacore_env_get()>.
 */
_NACORE_DEF void
nacore_env_free(const char *value);

/*
   Function: nacore_env_path_prefixes_split()

   Splits a string representing a list of path prefixes similarily to
   <nacore_string_split()>.

   Platform-specific rules are applied (e.g., on UNIX-like OSes the ":"
   separator is used and initial or trailing zero-length prefixes are
   substituted with ".").

   Parameters:

     path	- String representing the list of path prefixes to split.

   Returns:

     Auto-allocating list of strings or NULL if there was not enough memory.
 */
_NACORE_DEF nacore_list
nacore_env_path_prefixes_split(const char *path);

NACORE_END_C_DECLS

#endif
