/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.GCSnapshot;
import com.carrotsearch.junitbenchmarks.IResultsConsumer;
import com.carrotsearch.junitbenchmarks.Result;
import com.carrotsearch.junitbenchmarks.SingleResult;
import com.carrotsearch.junitbenchmarks.Statistics;
import java.util.ArrayList;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

final class BenchmarkStatement
extends Statement {
    static final int DEFAULT_WARMUP_ROUNDS = 5;
    static final int DEFAULT_BENCHMARK_ROUNDS = 10;
    private boolean ignoreAnnotationOptions = Boolean.getBoolean("jub.ignore.annotations");
    private boolean ignoreCallGC = Boolean.getBoolean("jub.ignore.callgc");
    private final Object target;
    private final FrameworkMethod method;
    private final Statement base;
    private final BenchmarkOptions options;
    private final IResultsConsumer[] consumers;

    public BenchmarkStatement(Statement base, FrameworkMethod method, Object target, IResultsConsumer ... consumers) {
        this.base = base;
        this.method = method;
        this.target = target;
        this.consumers = consumers;
        this.options = this.resolveOptions(method);
    }

    @BenchmarkOptions
    private void defaultOptions() {
    }

    private BenchmarkOptions resolveOptions(FrameworkMethod method) {
        BenchmarkOptions options = (BenchmarkOptions)method.getAnnotation(BenchmarkOptions.class);
        if (options != null) {
            return options;
        }
        for (Class<?> clz = this.target.getClass(); clz != null; clz = clz.getSuperclass()) {
            options = clz.getAnnotation(BenchmarkOptions.class);
            if (options == null) continue;
            return options;
        }
        try {
            return ((Object)((Object)this)).getClass().getDeclaredMethod("defaultOptions", new Class[0]).getAnnotation(BenchmarkOptions.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void evaluate() throws Throwable {
        int warmupRounds = this.getIntOption(this.options.warmupRounds(), "jub.rounds.warmup", 5);
        int benchmarkRounds = this.getIntOption(this.options.benchmarkRounds(), "jub.rounds.benchmark", 10);
        int totalRounds = warmupRounds + benchmarkRounds;
        ArrayList<SingleResult> results = new ArrayList<SingleResult>(totalRounds);
        GCSnapshot gcSnapshot = null;
        long warmupTime = System.currentTimeMillis();
        long benchmarkTime = 0L;
        for (int i = 0; i < totalRounds; ++i) {
            long startTime = System.currentTimeMillis();
            this.cleanupMemory();
            long afterGC = System.currentTimeMillis();
            if (i == warmupRounds) {
                gcSnapshot = new GCSnapshot();
                benchmarkTime = System.currentTimeMillis();
                warmupTime = benchmarkTime - warmupTime;
            }
            this.base.evaluate();
            long endTime = System.currentTimeMillis();
            results.add(new SingleResult(startTime, afterGC, endTime));
        }
        benchmarkTime = System.currentTimeMillis() - benchmarkTime;
        Statistics stats = Statistics.from(results.subList(warmupRounds, totalRounds));
        Result result = new Result(this.target, this.method, benchmarkRounds, warmupRounds, warmupTime, benchmarkTime, stats.evaluation, stats.gc, gcSnapshot);
        for (IResultsConsumer consumer : this.consumers) {
            consumer.accept(result);
        }
    }

    private void cleanupMemory() {
        if (this.ignoreCallGC) {
            return;
        }
        if (!this.options.callgc()) {
            return;
        }
        System.gc();
        System.gc();
        Thread.yield();
    }

    private int getIntOption(int localValue, String property, int defaultValue) {
        String v = System.getProperty(property);
        if (v != null && v.trim().length() > 0) {
            defaultValue = Integer.parseInt(v);
        }
        if (this.ignoreAnnotationOptions || localValue < 0) {
            return defaultValue;
        }
        return localValue;
    }
}

