/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef INC_STL_H_
#define INC_STL_H_

//-- this branch is for standard STL implementations

#include <set>
#include <map>

#ifdef HASHMAP
#include <hash_map>
#endif

#include <algorithm>
#include <functional>
#include <list>
#include <vector>
#include <stack>
#include <memory>
#include <string>

#ifndef NOUSING
//-- for HPUX aCC

using std::auto_ptr;
using std::less;
using std::list;
using std::map;

#ifdef HASHMAP
using std::hash_map;
#endif

using std::multimap;
using std::pair;
using std::set;
using std::stack;
using std::vector;

using std::back_inserter;
using std::copy;
using std::fill;
using std::find;
using std::for_each;
using std::greater;
using std::inserter;
using std::max_element;
using std::min_element;
using std::set_intersection;
using std::sort;
using std::swap;

#endif
// ! NOUSING


#endif
//INC_STL_H_
