/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef IconDrawer_H
#include "IconDrawer.h"
#endif

#ifndef Ask_H
#include "Ask.h"
#endif

#include "Drag.h"

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

#ifndef Dropping_H
#include "Dropping.h"
#endif

#ifndef Confirm_H
#include "Confirm.h"
#endif

#ifndef FolderDrawers_H
#include "FolderDrawers.h"
#endif


//-----------------------------------------------------------------

IconDrawer::IconDrawer(FolderDrawers& owner,Folder* f):
	owner_(owner),
	FolderViewer(f)
{
	create(owner_.widget(),(char*)f->name().c_str());
	FolderViewer::install(drag_);
	Manage();
}

IconDrawer::~IconDrawer()
{
}

Widget IconDrawer::menu()
{
	return current_.size()?menu1_:menu2_;
}

void IconDrawer::deleteDrawerCB(Widget, XtPointer)
{
  if( Confirm::ask( true, "Delete this drawer?" ) )
	folder_->toWastebasket();
}

void IconDrawer::renameDrawerCB(Widget, XtPointer)
{
	string name = folder_->name();
	if(Ask::show(name,"New name:"))
		folder_->rename(name);
}

void IconDrawer::updateDrawerCB(Widget, XtPointer)
{
  Folder* systemFolder = Folder::folder( "system_stationary"
				       , folder_->name()
				       , false
				       );
  if( systemFolder )
      folder_->copyContent( systemFolder );
  else
      Confirm::ask( true, "Cannot update renamed or user created drawers!" );
}

void IconDrawer::newDrawerCB(Widget, XtPointer)
{
	owner_.newFolder();
}

void IconDrawer::newIconCB(Widget, XtPointer)
{
	newIcon();
}

void IconDrawer::deleteCB(Widget, XtPointer)
{
	for(vector<IconObjectH>::iterator j = current_.begin(); 
		j != current_.end(); ++j)
			(*j)->toWastebasket();
}

void IconDrawer::editCB(Widget, XtPointer)
{
	for(vector<IconObjectH>::iterator j = current_.begin(); 
		j != current_.end(); ++j)
			(*j)->edit();
}

void IconDrawer::openFolderCB(Widget, XtPointer)
{
	folder_->open();
}

