/*
 * LibrePCB - Professional EDA for everyone!
 * Copyright (C) 2013 Urban Bruhin
 * http://librepcb.org/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBREPCB_FIRSTRUNWIZARD_H
#define LIBREPCB_FIRSTRUNWIZARD_H

/*****************************************************************************************
 *  Includes
 ****************************************************************************************/
#include <QtCore>
#include <QtWidgets>
#include <librepcbcommon/fileio/filepath.h>

/*****************************************************************************************
 *  Namespace / Forward Declarations
 ****************************************************************************************/
namespace librepcb {

namespace Ui {
class FirstRunWizard;
}

/*****************************************************************************************
 *  Class FirstRunWizard
 ****************************************************************************************/

/**
 * @brief The FirstRunWizard class
 *
 * @author ubruhin
 * @date 2015-09-22
 */
class FirstRunWizard final : public QWizard
{
        Q_OBJECT

    public:

        // Constructors / Destructor
        explicit FirstRunWizard(QWidget* parent = 0) noexcept;
        ~FirstRunWizard() noexcept;

        // Getters
        bool getCreateNewWorkspace() const noexcept;
        FilePath getWorkspaceFilePath() const noexcept;


    private:

        // Private Methods
        Q_DISABLE_COPY(FirstRunWizard)

        // Private Membervariables
        QScopedPointer<Ui::FirstRunWizard> mUi;
};

/*****************************************************************************************
 *  End of File
 ****************************************************************************************/

} // namespace librepcb

#endif // LIBREPCB_FIRSTRUNWIZARD_H
