#include "osl/record/record.h"
#include "osl/oslConfig.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>
using namespace osl;

class recordTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE( recordTest );
  CPPUNIT_TEST( testShow );
  CPPUNIT_TEST( testParseDate );
  CPPUNIT_TEST_SUITE_END();
 public:
  void testShow();
  void testParseDate();
};

CPPUNIT_TEST_SUITE_REGISTRATION(recordTest);

void recordTest::testShow(){
  Record r;
  if (OslConfig::verbose())
  {
    std::cout << r << std::endl;
  }
}

void recordTest::testParseDate()
{
  using namespace boost::gregorian;
  {
    Record r;
    r.setDate("2010/11/13");
    CPPUNIT_ASSERT(date(2010, Nov, 13) == r.getDate());
  }
  {
    Record r;
    r.setDate("2010/1/1");
    CPPUNIT_ASSERT(date(2010, Jan, 1) == r.getDate());
  }
  {
    Record r;
    r.setDate("2010/01/02");
    CPPUNIT_ASSERT(date(2010, Jan, 2) == r.getDate());
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
