/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.j2ee.weblogic9.ui;

import javax.swing.JPanel;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.openide.util.NbBundle;

public class FailedAuthenticationAlertPanel extends JPanel {
    
    public FailedAuthenticationAlertPanel() {
        initComponents();
        notAgain.setSelected(!WLPluginProperties.isFailedAuthenticationReported());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        notAgain = new javax.swing.JCheckBox();
        message = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(notAgain, org.openide.util.NbBundle.getMessage(FailedAuthenticationAlertPanel.class, "MSG_FailedAuthenticationAlertPanel_Again")); // NOI18N
        notAgain.setMargin(new java.awt.Insets(0, 0, 0, 0));
        notAgain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                notAgainActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 11, 0, 0);
        add(notAgain, gridBagConstraints);
        notAgain.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FailedAuthenticationAlertPanel.class, "ACSN_FailedAuthenticationAlertPanel_notAgain")); // NOI18N
        notAgain.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FailedAuthenticationAlertPanel.class, "ACSD_FailedAuthenticationAlertPanel_notAgain")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(message, org.openide.util.NbBundle.getMessage(FailedAuthenticationAlertPanel.class, "MSG_FailedAuthenticationAlertPanel_Message")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 0, 0);
        add(message, gridBagConstraints);
        message.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FailedAuthenticationAlertPanel.class, "ACSN_FailedAuthenticationAlertPanel")); // NOI18N
        message.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FailedAuthenticationAlertPanel.class, "ACSD_FailedAuthenticationAlertPanel")); // NOI18N

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FailedAuthenticationAlertPanel.class, "ACSN_FailedAuthenticationAlertPanel")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FailedAuthenticationAlertPanel.class, "ACSD_FailedAuthenticationAlertPanel")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    private void notAgainActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_notAgainActionPerformed
        WLPluginProperties.setFailedAuthenticationReported(!notAgain.isSelected());
    }//GEN-LAST:event_notAgainActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel message;
    private javax.swing.JCheckBox notAgain;
    // End of variables declaration//GEN-END:variables
    
}
