<a href="https://picturepan2.github.io/spectre">
  <img src="https://picturepan2.github.io/spectre/img/spectre-logo.svg" width="72" height="72">
</a>

## Spectre.css

Spectre.css is a lightweight, responsive and modern CSS framework.

- Lightweight (~10KB gzipped) starting point for your projects
- Flexbox-based, responsive and mobile-friendly layout
- Elegantly designed and developed elements and components

Spectre is a side project based on years of CSS development work on a large web service project. Spectre only includes modern base styles, responsive layout system, CSS components and utilities, and it can be modified for your project with Sass/Scss compiler.

Spectre.css is completely free to use. If you enjoy it, please consider [donating via Paypal](https://www.paypal.me/picturepan2) for the further development. ♥ 


## Getting started

There are 5 ways to get started with Spectre CSS framework in your projects. You can either manually install or use NPM, Yarn and Bower.

### Install manually
Download the compiled and minified [Spectre CSS files](https://github.com/picturepan2/spectre/tree/master/docs/dist). And include `spectre.css` located in `/docs/dist` in your website or Web app &lt;head&gt; part.

`<link rel="stylesheet" href="spectre.min.css">`

### Install from CDN
Alternatively, you can use the [unpkg](https://unpkg.com/) or [cdnjs](https://cdnjs.com/libraries/spectre.css) CDN to load compiled Spectre.css.

`<link rel="stylesheet" href="https://unpkg.com/spectre.css/dist/spectre.min.css">`

### Install with NPM
`$ npm install spectre.css --save`

### Install with Yarn
`$ yarn add spectre.css`

### Install with Bower
`$ bower install spectre.css --save`

## Compiling custom version

You can compile your custom version of Spectre.css. Read [the documentation](https://picturepan2.github.io/spectre/getting-started.html#custom).

## Documentation and examples

### Elements

- [Typography](https://picturepan2.github.io/spectre/elements.html#typography)
- [Tables](https://picturepan2.github.io/spectre/elements.html#tables)
- [Buttons](https://picturepan2.github.io/spectre/elements.html#buttons)
- [Forms](https://picturepan2.github.io/spectre/elements.html#forms)
- [Icons](https://picturepan2.github.io/spectre/elements.html#icons) - CSS only
- [Labels](https://picturepan2.github.io/spectre/elements.html#labels)
- [Code](https://picturepan2.github.io/spectre/elements.html#code)
- [Media](https://picturepan2.github.io/spectre/elements.html#media)

### Layout
- [Flexbox grid](https://picturepan2.github.io/spectre/layout.html#grid) 
- [Responsive](https://picturepan2.github.io/spectre/layout.html#responsive)
- [Navbar](https://picturepan2.github.io/spectre/layout.html#navbar)

### Components
- [Accordions](https://picturepan2.github.io/spectre/components.html#accordions)
- [Avatars](https://picturepan2.github.io/spectre/components.html#avatars)
- [Badges](https://picturepan2.github.io/spectre/components.html#badges)
- [Breadcrumbs](https://picturepan2.github.io/spectre/components.html#breadcrumbs)
- [Bars](https://picturepan2.github.io/spectre/components.html#bars)
- [Cards](https://picturepan2.github.io/spectre/components.html#cards)
- [Chips](https://picturepan2.github.io/spectre/components.html#chips)
- [Empty states](https://picturepan2.github.io/spectre/components.html#empty)
- [Menu](https://picturepan2.github.io/spectre/components.html#menu)
- [Nav](https://picturepan2.github.io/spectre/components.html#nav)
- [Modals](https://picturepan2.github.io/spectre/components.html#modals)
- [Pagination](https://picturepan2.github.io/spectre/components.html#pagination)
- [Panels](https://picturepan2.github.io/spectre/components.html#panels)
- [Popovers](https://picturepan2.github.io/spectre/components.html#popovers)
- [Steps](https://picturepan2.github.io/spectre/components.html#steps)
- [Tabs](https://picturepan2.github.io/spectre/components.html#tabs)
- [Tiles](https://picturepan2.github.io/spectre/components.html#tiles)
- [Toasts](https://picturepan2.github.io/spectre/components.html#toasts)
- [Tooltips](https://picturepan2.github.io/spectre/components.html#tooltips)

### Utilities

- [Utilities](https://picturepan2.github.io/spectre/utilities.html) - colors, display, divider, loading, position, shapes and text utilities

### Experimentals
- [Autocomplete](https://picturepan2.github.io/spectre/experimentals.html#autocomplete)
- [Calendars](https://picturepan2.github.io/spectre/experimentals.html#calendars)
- [Carousels](https://picturepan2.github.io/spectre/experimentals.html#carousels) - CSS only
- [Comparison Sliders](https://picturepan2.github.io/spectre/experimentals.html#comparison) - CSS only
- [Filters](https://picturepan2.github.io/spectre/experimentals.html#carousels) - CSS only
- [Meters](https://picturepan2.github.io/spectre/experimentals.html#meters)
- [Off-canvas](https://picturepan2.github.io/spectre/experimentals.html#off-canvas) - CSS only
- [Parallax](https://picturepan2.github.io/spectre/experimentals.html#parallax) - CSS only
- [Progress](https://picturepan2.github.io/spectre/experimentals.html#progress)
- [Sliders](https://picturepan2.github.io/spectre/experimentals.html#sliders)
- [Timelines](https://picturepan2.github.io/spectre/experimentals.html#timelines)

## Browser support
Spectre uses [Autoprefixer](https://github.com/postcss/autoprefixer) to make most styles compatible with earlier browsers and [Normalize.css](https://necolas.github.io/normalize.css/) for CSS resets. Spectre is designed for modern browsers. For best compatibility, these browsers are recommended:

- Chrome (LAST 4)
- Microsoft Edge (LAST 4)
- Firefox (EXTENDED SUPPORT RELEASE)
- Safari (LAST 4)
- Opera (LAST 4)
- Internet Explorer 10+

Spectre supports Internet Explorer 10+, but some HTML5 and CSS3 features are not perfectly supported by Internet Explorer.

Designed and built with ♥ by [Yan Zhu](https://twitter.com/picturepan2). Feel free to submit a pull request. Help is always appreciated.
