/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBufferImpl;
import java.nio.HeapShortBuffer;

public abstract class ShortBuffer
extends Buffer
implements Comparable {
    ByteBufferImpl parent = null;
    short[] array;
    boolean isDirect;
    boolean disposed = false;

    ShortBuffer() {
    }

    public static ShortBuffer wrap(short[] sArray, int n, int n2) {
        if (n < 0 || n > sArray.length || n2 < 0 || n2 > sArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        HeapShortBuffer heapShortBuffer = new HeapShortBuffer(sArray.length, sArray, 0);
        heapShortBuffer.position(n);
        heapShortBuffer.limit(n + n2);
        return heapShortBuffer;
    }

    public static ShortBuffer wrap(short[] sArray) {
        return ShortBuffer.wrap(sArray, 0, sArray.length);
    }

    public abstract ShortBuffer slice();

    public abstract short get();

    public abstract ShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract ShortBuffer put(int var1, short var2);

    public ShortBuffer get(short[] sArray, int n, int n2) {
        ShortBuffer.checkBounds(n, n2, sArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.copyToArray(sArray, n, n2);
        this.position += n2;
        return this;
    }

    abstract void copyToArray(short[] var1, int var2, int var3);

    public ShortBuffer get(short[] sArray) {
        return this.get(sArray, 0, sArray.length);
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n = shortBuffer.limit - shortBuffer.position;
        if (n > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        shortBuffer.copyToShortBuffer(n, this);
        shortBuffer.position += n;
        this.position += n;
        return this;
    }

    abstract void copyToShortBuffer(int var1, ShortBuffer var2);

    abstract void copyFromHeapShortBuffer(ShortBuffer var1, int var2);

    abstract void copyFromByteBufferAsShortBuffer(ShortBuffer var1, int var2);

    abstract void copyFromDirectShortBuffer(ShortBuffer var1, int var2);

    static void vanillaCopy(ShortBuffer shortBuffer, ShortBuffer shortBuffer2, int n) {
        for (int i = 0; i < n; ++i) {
            shortBuffer2.put(shortBuffer2.position + i, shortBuffer.get(shortBuffer.position + i));
        }
    }

    public ShortBuffer put(short[] sArray, int n, int n2) {
        ShortBuffer.checkBounds(n, n2, sArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        this.copyFromArray(sArray, n, n2);
        this.position += n2;
        return this;
    }

    abstract void copyFromArray(short[] var1, int var2, int var3);

    public final ShortBuffer put(short[] sArray) {
        return this.put(sArray, 0, sArray.length);
    }

    public final boolean hasArray() {
        return this.array != null;
    }

    public final short[] array() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    public final int arrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.arrayOffset;
    }

    public abstract boolean isDirect();

    public String toString() {
        return "java.nio.ShortBuffer[pos=" + this.position() + "lim=" + this.limit() + "cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortBuffer)) {
            return false;
        }
        ShortBuffer shortBuffer = (ShortBuffer)object;
        if (this.remaining() != shortBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = shortBuffer.limit() - 1;
        while (n2 >= n) {
            short s;
            short s2 = this.get(n2);
            if (s2 != (s = shortBuffer.get(n3)) && (s2 == s2 || s == s)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public int compareTo(Object object) {
        ShortBuffer shortBuffer = (ShortBuffer)object;
        int n = this.position() + Math.min(this.remaining(), shortBuffer.remaining());
        int n2 = this.position();
        int n3 = shortBuffer.position();
        while (n2 < n) {
            short s;
            short s2 = this.get(n2);
            if (s2 != (s = shortBuffer.get(n3)) && (s2 == s2 || s == s)) {
                if (s2 < s) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - shortBuffer.remaining();
    }
}

