/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ObjectStreamException;
import java.net.InetAddress;

public final class Inet4Address
extends InetAddress {
    static final int INADDRSZ = 4;
    private static final long serialVersionUID = 3286316764910316507L;
    private static final int loopback = 2130706433;

    Inet4Address() {
        this.hostName = null;
        this.address = 0;
        this.family = 1;
    }

    Inet4Address(String string, byte[] byArray) {
        this.hostName = string;
        this.family = 1;
        if (byArray != null && byArray.length == 4) {
            this.address = byArray[3] & 0xFF;
            this.address |= byArray[2] << 8 & 0xFF00;
            this.address |= byArray[1] << 16 & 0xFF0000;
            this.address |= byArray[0] << 24 & 0xFF000000;
        }
    }

    Inet4Address(String string, int n) {
        this.hostName = string;
        this.family = 1;
        this.address = n;
    }

    private Object writeReplace() throws ObjectStreamException {
        InetAddress inetAddress = new InetAddress();
        inetAddress.hostName = this.hostName;
        inetAddress.address = this.address;
        inetAddress.family = 2;
        return inetAddress;
    }

    public boolean isMulticastAddress() {
        return (this.address & 0xF0000000) == -536870912;
    }

    public boolean isAnyLocalAddress() {
        return this.address == 0;
    }

    public boolean isLoopbackAddress() {
        byte[] byArray = this.getAddress();
        return byArray[0] == 127;
    }

    public boolean isLinkLocalAddress() {
        return (this.address >>> 24 & 0xFF) == 169 && (this.address >>> 16 & 0xFF) == 254;
    }

    public boolean isSiteLocalAddress() {
        return (this.address >>> 24 & 0xFF) == 10 || (this.address >>> 24 & 0xFF) == 172 && (this.address >>> 16 & 0xF0) == 16 || (this.address >>> 24 & 0xFF) == 192 && (this.address >>> 16 & 0xFF) == 168;
    }

    public boolean isMCGlobal() {
        byte[] byArray = this.getAddress();
        return (byArray[0] & 0xFF) >= 224 && (byArray[0] & 0xFF) <= 238 && ((byArray[0] & 0xFF) != 224 || byArray[1] != 0 || byArray[2] != 0);
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return (this.address >>> 24 & 0xFF) == 224 && (this.address >>> 16 & 0xFF) == 0 && (this.address >>> 8 & 0xFF) == 0;
    }

    public boolean isMCSiteLocal() {
        return (this.address >>> 24 & 0xFF) == 239 && (this.address >>> 16 & 0xFF) == 255;
    }

    public boolean isMCOrgLocal() {
        return (this.address >>> 24 & 0xFF) == 239 && (this.address >>> 16 & 0xFF) >= 192 && (this.address >>> 16 & 0xFF) <= 195;
    }

    public byte[] getAddress() {
        byte[] byArray = new byte[]{(byte)(this.address >>> 24 & 0xFF), (byte)(this.address >>> 16 & 0xFF), (byte)(this.address >>> 8 & 0xFF), (byte)(this.address & 0xFF)};
        return byArray;
    }

    public String getHostAddress() {
        return Inet4Address.numericToTextFormat(this.getAddress());
    }

    public int hashCode() {
        return this.address;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Inet4Address && ((InetAddress)object).address == this.address;
    }

    static String numericToTextFormat(byte[] byArray) {
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    static byte[] textToNumericFormat(String string) {
        if (string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[4];
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            char c;
            if (Character.isDigit(c = cArray[n2++])) {
                int n4 = (byArray[n3] & 0xFF) * 10 + (Character.digit(c, 10) & 0xFF);
                if (n4 > 255) {
                    return null;
                }
                byArray[n3] = (byte)(n4 & 0xFF);
                if (bl) continue;
                if (++n > 4) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == '.' && bl) {
                if (n == 4) {
                    return null;
                }
                byArray[++n3] = 0;
                bl = false;
                continue;
            }
            return null;
        }
        if (n < 4) {
            return null;
        }
        return byArray;
    }

    private static native void init();

    static {
        Inet4Address.init();
    }
}

