/*
 *  @(#)LogTPLog.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.tp.v1.log;


import net.sourceforge.groboutils.autodoc.v1.AutoDocTP;

import java.io.PrintWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;


/**
 * Test Procedure entry point.  Generates Test Procedure documentation.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:29 $
 * @since      July 21, 2002
 */
public class LogTP implements AutoDocTP
{
    private PrintWriter out;
    
    private int overalCount = 0;
    private int stepCount = 0;
    private int setupCount = 0;
    private int teardownCount = 0;
    
    public LogTP( String baseDir, Class owner )
    {
        PrintWriter pw = null;
        if (baseDir != null && owner != null)
        {
            try
            {
                pw = new PrintWriter( new FileWriter(
                    new File( baseDir,
                    "TP-"+owner.getName()+".log" ) ) );
            }
            catch (IOException ioe)
            {
                pw = null;
            }
        }
        if (pw == null)
        {
            pw = new PrintWriter( System.out );
        }
        setOutput( pw );
    }
    
    
    /**
     * Defines a step which occurs during the test setup phase.
     *
     * @param description the text describing the step.
     */
    public synchronized void setupStep( String description )
    {
        printStep( "setup", description, ++this.setupCount );
    }
    
    
    /**
     * Defines a step which occurs during the test tear-down phase.
     *
     * @param description the text describing the step.
     */
    public synchronized void teardownStep( String description )
    {
        printStep( "teardown", description, ++this.teardownCount );
    }
    
    
    /**
     * Defines a step which occurs during the test proper.
     *
     * @param description the text describing the step.
     */
    public synchronized void step( String description )
    {
        printStep( "test step", description, ++this.stepCount );
    }
    
    
    
    protected synchronized void printStep( String stepDesc, String text,
        int thisStepCount )
    {
        ++this.overalCount;
        this.out.println( this.overalCount +
            ". "+stepDesc+": " +thisStepCount+". "+text );
    }
    
    
    protected void setOutput( PrintWriter pw )
    {
        this.out = pw;
    }
}

