
/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ALLOCATOR_HPP)
#include <Allocator.hpp>
#endif


namespace   corelinux
{
   //
   // Default constructor
   //

   Allocator::Allocator( void )
      :
      Strategy(),
      theAllocates( 0 ),
      theDeallocates( 0 )
   {
      ;  // do nothing
   }

   //
   // Copy constructor
   //

   Allocator::Allocator( AllocatorCref aRef )
      :
      Strategy( aRef ),
      theAllocates( 0 ),
      theDeallocates( 0 )
   {
      ;  // do nothing
   }

   //
   // Destructor
   //

   Allocator::~Allocator( void )
   {
      ;  // do nothing
   }

   //
   // Assignment operator
   //

   AllocatorRef Allocator::operator=( AllocatorCref aRef )
   {
      if( this->operator==( aRef ) != true )
      {
         theAllocates = 0;
         theDeallocates = 0;
      }
      else
      {
         ;  // do nothing
      }
      return (*this);
   }

   //
   // Equality operator
   //

   bool  Allocator::operator==( AllocatorCref aRef ) const
   {
      return ( this == &aRef );
   }

   //
   // Get allocate count
   //

   CountCref Allocator::getAllocateCount( void ) const
   {
      return theAllocates;
   }

   //
   // Get deallocate count
   //

   CountCref   Allocator::getDeallocateCount( void ) const
   {
      return theDeallocates;
   }

   //
   // Counter adjustment methods
   //

   void  Allocator::incrementAllocates( void )
   {
      ++theAllocates;
   }

   void  Allocator::incrementDeallocates( void )
   {
      ++theDeallocates;
   }

   void  Allocator::decrementAllocates( void )
   {
      --theAllocates;
   }

   void  Allocator::decrementDeallocates( void )
   {
      --theDeallocates;
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/05/13 12:32:21 $
   $Locker:  $
*/

