// -*- Mode : c++ -*-
//
// SUMMARY  :      
// USAGE    :        
// ORG      : Christophe Prud'homme 
// AUTHOR   : Christophe Prud'homme 
// E-MAIL   : prudhomm@users.sourceforge.net
//
// DESCRIPTION :
/*! \file corelinux.cpp */

/*! \mainpage CoreLinux++ Classes Reference Manual

  \section intro Introduction

  \subsection consortium The CoreLinux Consortium
  The CoreLinux consortium will:
  
  @li Enlist members ( for requirements, analysis, design, and development ) 
  @li Formalize conventions for Object Oriented Analysis (OOA) and Design (OOD). 
  @li Formalize standards and conventions for C++ code style. 
  @li Gather requirements. Perform OOA and OOD using UML as the modeling language. 
  @li Implement designs and example drivers. 
  @li Develop utilities and applications for Linux that are CoreLinux++ certified
  @li Showcase CoreLinux++ certified applications by others

  \subsection description Short description

  This manual is the classes reference manual of the corelinux++ library
  and its associated examples. It allows you to browse easily the entire namespace
  corelinux and go through all the examples.
  
  \section copyright Copyright
  \subsection source Source license
  
  CoreLinux++ 
  Copyright (C) 1999, 2000 CoreLinux++ Consortium
  
  The CoreLinux++ Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.
  
  The CoreLinux++ Library Library is distributed in the hope that it will 
  be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with the GNU C Library; see the file COPYING.LIB.  If not,
  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.  
  
  see COPYING.LIB
  
  \subsection doc Documentation license
  
  All CoreLinux++ is free documentation and may be distributed only
  subject to the terms and conditions set forth in the Open 
  Publication License.

  see COPYING.DOC

*/
/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
   
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
// DESCRIP-END.
//


extern "C" {

  /*!
    \fn char ACCheckCoreLinux()
    \brief Function for autoconf checks

    This purpose of this function is to provide the autoconf users a symbol to check for in
    corelinux library. Unfortunately autoconf uses the C compiler to check for symbols into
    libraries and corelinux is a C++ one so the way the functions and objects are mangled makes it
    impossible to check for them. The solution is to provide a C symbol to check for using 
    extern "C" {}.

    To enable corelinux into autoconf, you can put the following lines into the configure.in file.
    \verbatim
    AC_CHECK_LIB(cl++, ACCheckCoreLinux,[
    CXXFLAGS="${CXXFLAGS} -I/usr/include/corelinux"
    LDFLAGS="${LDFLAGS} "
    LIBS="${LIBS} -lcl++"
    ],[
    echo "You need to install corelinux. See http://corelinux.sourceforge.net"
    exit;
    ],)
    \endverbatim
  */
  char
  ACCheckCoreLinux()
  {
    return 1;
  }

  /*
  #include  <stdio.h>
  
  void _init( void )
  {
      printf("I'm init\n");
  }

  void _fini( void )
  {
      printf("I'm fini\n");
  }
  */

}
// Common rcs information do not modify
// $Author: frankc $
// $Revision: 1.3 $
// $Date: 2000/09/10 04:37:32 $
// $Locker:  $
