/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "accountqueue.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "./accountqueue_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */

/* macro functions */
GWEN_LIST_FUNCTIONS(AB_ACCOUNTQUEUE, AB_AccountQueue)
GWEN_INHERIT_FUNCTIONS(AB_ACCOUNTQUEUE)


AB_ACCOUNTQUEUE *AB_AccountQueue_new(void)
{
  AB_ACCOUNTQUEUE *p_struct;

  GWEN_NEW_OBJECT(AB_ACCOUNTQUEUE, p_struct)
  p_struct->_refCount=1;
  GWEN_INHERIT_INIT(AB_ACCOUNTQUEUE, p_struct)
  GWEN_LIST_INIT(AB_ACCOUNTQUEUE, p_struct)
  /* members */
  p_struct->accountId=0;
  p_struct->account=NULL;
  p_struct->accountSpec=NULL;
  p_struct->transactionList=AB_Transaction_List2_new();
  p_struct->jobQueueList=AB_JobQueue_List_new();
  /* virtual functions */

  return p_struct;
}

void AB_AccountQueue_free(AB_ACCOUNTQUEUE *p_struct)
{
  if (p_struct) {
    assert(p_struct->_refCount);
    if (p_struct->_refCount==1) {
      GWEN_INHERIT_FINI(AB_ACCOUNTQUEUE, p_struct)
      GWEN_LIST_FINI(AB_ACCOUNTQUEUE, p_struct)
      /* members */
      AB_AccountSpec_free(p_struct->accountSpec);
      p_struct->accountSpec=NULL;
      AB_Transaction_List2_free(p_struct->transactionList);
      p_struct->transactionList=NULL;
      AB_JobQueue_List_free(p_struct->jobQueueList);
      p_struct->jobQueueList=NULL;
      p_struct->_refCount=0;
      GWEN_FREE_OBJECT(p_struct);
    }
    else
      p_struct->_refCount--;
  }
}

void AB_AccountQueue_Attach(AB_ACCOUNTQUEUE *p_struct)
{
  assert(p_struct);
  assert(p_struct->_refCount);
  p_struct->_refCount++;
}

AB_ACCOUNTQUEUE *AB_AccountQueue_dup(const AB_ACCOUNTQUEUE *p_src)
{
  AB_ACCOUNTQUEUE *p_struct;

  assert(p_src);
  p_struct=AB_AccountQueue_new();
  /* member "accountId" */
  p_struct->accountId=p_src->accountId;

  /* member "account" */
  p_struct->account=p_src->account;

  /* member "accountSpec" */
  if (p_struct->accountSpec) {
    AB_AccountSpec_free(p_struct->accountSpec);
    p_struct->accountSpec=NULL;
    p_struct->accountSpec=NULL;
  }
  if (p_src->accountSpec) {
    p_struct->accountSpec=AB_AccountSpec_dup(p_src->accountSpec);
  }

  /* member "transactionList" */
  if (p_struct->transactionList) {
    AB_Transaction_List2_free(p_struct->transactionList);
    p_struct->transactionList=NULL;
    p_struct->transactionList=NULL;
  }
  if (p_src->transactionList) {
    p_struct->transactionList=AB_Transaction_List2_dup(p_src->transactionList);
  }

  /* member "jobQueueList" */
  if (p_struct->jobQueueList) {
    AB_JobQueue_List_free(p_struct->jobQueueList);
    p_struct->jobQueueList=NULL;
    p_struct->jobQueueList=NULL;
  }
  if (p_src->jobQueueList) {
    p_struct->jobQueueList=AB_JobQueue_List_dup(p_src->jobQueueList);
  }

  return p_struct;
}

uint32_t AB_AccountQueue_GetAccountId(const AB_ACCOUNTQUEUE *p_struct)
{
  assert(p_struct);
  return p_struct->accountId;
}

AB_ACCOUNT *AB_AccountQueue_GetAccount(const AB_ACCOUNTQUEUE *p_struct)
{
  assert(p_struct);
  return p_struct->account;
}

AB_ACCOUNT_SPEC *AB_AccountQueue_GetAccountSpec(const AB_ACCOUNTQUEUE *p_struct)
{
  assert(p_struct);
  return p_struct->accountSpec;
}

AB_TRANSACTION_LIST2 *AB_AccountQueue_GetTransactionList(const AB_ACCOUNTQUEUE *p_struct)
{
  assert(p_struct);
  return p_struct->transactionList;
}

AB_JOBQUEUE_LIST *AB_AccountQueue_GetJobQueueList(const AB_ACCOUNTQUEUE *p_struct)
{
  assert(p_struct);
  return p_struct->jobQueueList;
}

void AB_AccountQueue_SetAccountId(AB_ACCOUNTQUEUE *p_struct, uint32_t p_src)
{
  assert(p_struct);
  p_struct->accountId=p_src;
}

void AB_AccountQueue_SetAccount(AB_ACCOUNTQUEUE *p_struct, AB_ACCOUNT *p_src)
{
  assert(p_struct);
  p_struct->account=p_src;
}

void AB_AccountQueue_SetAccountSpec(AB_ACCOUNTQUEUE *p_struct, AB_ACCOUNT_SPEC *p_src)
{
  assert(p_struct);
  if (p_struct->accountSpec) {
    AB_AccountSpec_free(p_struct->accountSpec);
    p_struct->accountSpec=NULL;
  }
  p_struct->accountSpec=p_src;
}

void AB_AccountQueue_SetTransactionList(AB_ACCOUNTQUEUE *p_struct, AB_TRANSACTION_LIST2 *p_src)
{
  assert(p_struct);
  if (p_struct->transactionList) {
    AB_Transaction_List2_free(p_struct->transactionList);
    p_struct->transactionList=NULL;
  }
  p_struct->transactionList=p_src;
}

void AB_AccountQueue_SetJobQueueList(AB_ACCOUNTQUEUE *p_struct, AB_JOBQUEUE_LIST *p_src)
{
  assert(p_struct);
  if (p_struct->jobQueueList) {
    AB_JobQueue_List_free(p_struct->jobQueueList);
    p_struct->jobQueueList=NULL;
  }
  p_struct->jobQueueList=p_src;
}

/* list1 functions */
AB_ACCOUNTQUEUE_LIST *AB_AccountQueue_List_dup(const AB_ACCOUNTQUEUE_LIST *p_src)
{
  AB_ACCOUNTQUEUE_LIST *p_dest;
  AB_ACCOUNTQUEUE *p_elem;

  assert(p_src);
  p_dest=AB_AccountQueue_List_new();
  p_elem=AB_AccountQueue_List_First(p_src);
  while (p_elem) {
    AB_ACCOUNTQUEUE *p_cpy;

    p_cpy=AB_AccountQueue_dup(p_elem);
    AB_AccountQueue_List_Add(p_cpy, p_dest);
    p_elem=AB_AccountQueue_List_Next(p_elem);
  }

  return p_dest;
}

AB_ACCOUNTQUEUE *AB_AccountQueue_List_GetByAccountId(const AB_ACCOUNTQUEUE_LIST *p_list, uint32_t p_cmp)
{
  AB_ACCOUNTQUEUE *p_struct;

  assert(p_list);
  p_struct = AB_AccountQueue_List_First(p_list);
  while (p_struct) {
    int p_rv;

    if (p_struct->accountId==p_cmp)
      p_rv=0;
    else if (p_cmp<p_struct->accountId)
      p_rv=-1;
    else
      p_rv=1;
    if (p_rv == 0)
      return p_struct;
    p_struct = AB_AccountQueue_List_Next(p_struct);
  }
  return NULL;
}

void AB_AccountQueue_AddTransaction(AB_ACCOUNTQUEUE *aq, AB_TRANSACTION *t)
{
  if (aq->transactionList==NULL)
    aq->transactionList=AB_Transaction_List2_new();
  AB_Transaction_List2_PushBack(aq->transactionList, t);
}
AB_JOBQUEUE *AB_AccountQueue_FindJobQueue(const AB_ACCOUNTQUEUE *uq, int cmd)
{
  if (uq->jobQueueList)
    return AB_JobQueue_List_GetByJobType(uq->jobQueueList, cmd);
  return NULL;
}
void AB_AccountQueue_AddJobQueue(AB_ACCOUNTQUEUE *up, AB_JOBQUEUE *aq)
{
  if (up->jobQueueList==NULL)
    up->jobQueueList=AB_JobQueue_List_new();
  AB_JobQueue_List_Add(aq, up->jobQueueList);
}
AB_JOBQUEUE *AB_AccountQueue_GetFirstJobQueue(const AB_ACCOUNTQUEUE *up)
{
  if (up->jobQueueList==NULL)
    return NULL;
  return AB_JobQueue_List_First(up->jobQueueList);
}

/* code headers */

