package tests::ReportChartConfigTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::Config::TypeSpec;
use Lire::ChartType;
use Lire::Report::ChartConfig;
use Lire::PluginManager;
use Lire::Test::Mock;

sub new {
    my $self = shift->SUPER::new( @_ );

    return $self;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->set_up_plugin_mgr();
    $self->{'scatterplot'} = new_proxy Lire::Test::Mock( 'Lire::ChartType' );
    $self->{'scatterplot'}->set_result( 'name' => 'scatterplot' );
    Lire::PluginManager->register_plugin( $self->{'scatterplot'} );

    $self->{'cfg'}{'_lr_config_spec'} = new Lire::Config::ConfigSpec();

    return $self;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return $self;
}

sub test_new {
    my $self = $_[0];

    my $chart = new Lire::Report::ChartConfig();
    $self->assert_isa( 'Lire::Report::ChartConfig', $chart );
    $self->assert_isa( 'Lire::Config::ChartSpec', $chart->spec() );

    $self->assert_dies( qr/\'spec\' parameter should be a \'Lire::Config::ChartSpec\' instance/,
                        sub { new Lire::Report::ChartConfig( 'spec' => new Lire::Config::StringSpec( 'name' => 'test' ) ) } );
}

sub test_type {
    my $self = $_[0];

    my $chart = new Lire::Report::ChartConfig();
    $chart->get( 'type' )->set_plugin( 'scatterplot' );
    $self->assert_str_equals( $self->{'scatterplot'}, $chart->type() );
}

1;
