{ This file is generated by dev/parseunicode/parseunicodeclasses program }

function GetUnicodeBidiClassEx(u: LongWord): TUnicodeBidiClass;
begin
  case u of
  $00000..$07FFF:
    case u of
    $00000..$003FF:
      case u of
        $00..$08, $0E..$1B, $7F..$84, $86..$9F, $AD: result := ubcBoundaryNeutral;
        $09, $0B, $1F: result := ubcSegmentSeparator;
        $0A, $0D, $1C..$1E, $85: result := ubcParagraphSeparator;
        $0C, $20: result := ubcWhiteSpace;
        $41..$5A, $61..$7A, $AA, $B5, $BA, $C0..$D6, $D8..$F6, $F8..$2B8, $2BB..$2C1, $2D0, $2D1, 
        $2E0..$2E4, $2EE, $370..$373, $376, $377, $37A..$37D, $37F, $386, $388..$38A, $38C, $38E..$3A1, 
        $3A3..$3F5, $3F7: result := ubcLeftToRight;
        $3F8..$3FF: result := ubcLeftToRight;
        $30..$39, $B2, $B3, $B9: result := ubcEuropeanNumber;
        $2B, $2D: result := ubcEuropeanNumberSeparator;
        $23..$25, $A2..$A5, $B0, $B1: result := ubcEuropeanNumberTerminator;
        $2C, $2E, $2F, $3A, $A0: result := ubcCommonSeparator;
        $300..$36F: result := ubcNonSpacingMark;
        $21, $22, $26, $27, $2A, $3B, $3D, $3F, $40, $5C, $5E..$60, $7C, $7E, $A1, $A6..$A9, $AC, 
        $AE, $AF, $B4, $B6..$B8, $BC..$BF, $D7, $F7, $2B9, $2BA, $2C2..$2CF, $2D2: result := ubcOtherNeutrals;
        $2D3..$2DF, $2E5..$2ED, $2EF..$2FF, $374, $375, $37E, $384, $385, $387, $3F6: result := ubcOtherNeutrals;
        $28, $29, $3C, $3E, $5B, $5D, $7B, $7D, $AB, $BB: result := ubcMirroredNeutral;
      else result := ubcUnknown;
      end;
    $00400..$007FF:
      case u of
        $400..$482, $48A..$52F, $531..$556, $559..$589: result := ubcLeftToRight;
        $5BE, $5C0, $5C3, $5C6, $5D0..$5EA, $5EF..$5F4, $7C0..$7EA, $7F4, $7F5, $7FA, $7FE, $7FF: result := ubcRightToLeft;
        $608, $60B, $60D, $61B, $61C, $61E..$64A, $66D..$66F, $671..$6D5, $6E5, $6E6, $6EE, $6EF, 
        $6FA..$70D, $70F, $710, $712..$72F, $74D..$7A5, $7B1: result := ubcArabicLetter;
        $6F0..$6F9: result := ubcEuropeanNumber;
        $58F, $609, $60A, $66A: result := ubcEuropeanNumberTerminator;
        $600..$605, $660..$669, $66B, $66C, $6DD: result := ubcArabicNumber;
        $60C: result := ubcCommonSeparator;
        $483..$489, $591..$5BD, $5BF, $5C1, $5C2, $5C4, $5C5, $5C7, $610..$61A, $64B..$65F, $670, 
        $6D6..$6DC, $6DF..$6E4, $6E7, $6E8, $6EA..$6ED, $711, $730..$74A, $7A6..$7B0, $7EB..$7F3, 
        $7FD: result := ubcNonSpacingMark;
        $58A, $58D, $58E, $606, $607, $60E, $60F, $6DE, $6E9, $7F6..$7F9: result := ubcOtherNeutrals;
      else result := ubcUnknown;
      end;
    $00800..$00BFF:
      case u of
        $904..$939, $93D, $950, $958..$961, $964..$980, $985..$98C, $98F, $990, $993..$9A8, $9AA..$9B0, 
        $9B2, $9B6..$9B9, $9BD, $9CE, $9DC, $9DD, $9DF..$9E1, $9E6..$9F1, $9F4..$9FA, $9FC, $9FD, 
        $A05..$A0A, $A0F, $A10, $A13..$A28, $A2A: result := ubcLeftToRight;
        $A2B..$A30, $A32, $A33, $A35, $A36, $A38, $A39, $A59..$A5C, $A5E, $A66..$A6F, $A72..$A74, 
        $A76, $A85..$A8D, $A8F..$A91, $A93..$AA8, $AAA..$AB0, $AB2, $AB3, $AB5..$AB9, $ABD, $AD0, 
        $AE0, $AE1, $AE6..$AF0, $AF9, $B05..$B0C, $B0F: result := ubcLeftToRight;
        $903, $93B, $93E..$940, $949..$94C, $94E, $94F, $982, $983, $9BE..$9C0, $9C7, $9C8, $9CB, 
        $9CC, $9D7, $A03, $A3E..$A40, $A83, $ABE..$AC0, $AC9, $ACB, $ACC, $B02, $B03, $B3E, $B40, 
        $B47, $B48, $B4B, $B4C, $B57: result := ubcCombiningLeftToRight;
        $B10, $B13..$B28, $B2A..$B30, $B32, $B33, $B35..$B39, $B3D, $B5C, $B5D, $B5F..$B61, $B66..$B77, 
        $B83, $B85..$B8A, $B8E..$B90, $B92..$B95, $B99, $B9A, $B9C, $B9E, $B9F, $BA3, $BA4, $BA8..$BAA, 
        $BAE..$BB9, $BD0, $BE6..$BF2: result := ubcLeftToRight;
        $800..$815, $81A, $824, $828, $830..$83E, $840..$858, $85E: result := ubcRightToLeft;
        $860..$86A, $8A0..$8B4, $8B6..$8C7: result := ubcArabicLetter;
        $BBE, $BBF, $BC1, $BC2, $BC6..$BC8, $BCA..$BCC, $BD7: result := ubcCombiningLeftToRight;
        $9F2, $9F3, $9FB, $AF1, $BF9: result := ubcEuropeanNumberTerminator;
        $8E2: result := ubcArabicNumber;
        $816..$819, $81B..$823, $825..$827, $829..$82D, $859..$85B, $8D3..$8E1, $8E3..$902, $93A, 
        $93C, $941..$948, $94D, $951..$957, $962, $963, $981, $9BC, $9C1..$9C4, $9CD, $9E2, $9E3, 
        $9FE, $A01, $A02, $A3C, $A41: result := ubcNonSpacingMark;
        $A42, $A47, $A48, $A4B..$A4D, $A51, $A70, $A71, $A75, $A81, $A82, $ABC, $AC1..$AC5, $AC7, 
        $AC8, $ACD, $AE2, $AE3, $AFA..$AFF, $B01, $B3C, $B3F, $B41..$B44, $B4D, $B55, $B56, $B62, 
        $B63, $B82, $BC0: result := ubcNonSpacingMark;
        $BCD: result := ubcNonSpacingMark;
        $BF3..$BF8, $BFA: result := ubcOtherNeutrals;
      else result := ubcUnknown;
      end;
    $00C00..$00FFF:
      case u of
        $C05..$C0C, $C0E..$C10, $C12..$C28, $C2A..$C39, $C3D, $C58..$C5A, $C60, $C61, $C66..$C6F, 
        $C77, $C7F, $C80, $C84..$C8C, $C8E..$C90, $C92..$CA8, $CAA..$CB3, $CB5..$CB9, $CBD, $CBF, 
        $CC6, $CDE, $CE0, $CE1, $CE6..$CEF, $CF1: result := ubcLeftToRight;
        $CF2, $D04..$D0C, $D0E..$D10, $D12..$D3A, $D3D, $D4E, $D4F, $D54..$D56, $D58..$D61, $D66..$D7F, 
        $D85..$D96, $D9A..$DB1, $DB3..$DBB, $DBD, $DC0..$DC6, $DE6..$DEF, $DF4, $E01..$E30, $E32, 
        $E33, $E40..$E46, $E4F..$E5B, $E81, $E82, $E84: result := ubcLeftToRight;
        $E86..$E8A, $E8C..$EA3, $EA5, $EA7..$EB0, $EB2, $EB3, $EBD, $EC0..$EC4, $EC6, $ED0..$ED9, 
        $EDC..$EDF, $F00..$F17, $F1A..$F34, $F36, $F38, $F40..$F47, $F49..$F6C, $F85, $F88..$F8C, 
        $FBE..$FC5, $FC7..$FCC, $FCE..$FDA: result := ubcLeftToRight;
        $C01..$C03, $C41..$C44, $C82, $C83, $CBE, $CC0..$CC4, $CC7, $CC8, $CCA, $CCB, $CD5, $CD6, 
        $D02, $D03, $D3E..$D40, $D46..$D48, $D4A..$D4C, $D57, $D82, $D83, $DCF..$DD1, $DD8..$DDF, 
        $DF2, $DF3, $F3E, $F3F, $F7F: result := ubcCombiningLeftToRight;
        $E3F: result := ubcEuropeanNumberTerminator;
        $C00, $C04, $C3E..$C40, $C46..$C48, $C4A..$C4D, $C55, $C56, $C62, $C63, $C81, $CBC, $CCC, 
        $CCD, $CE2, $CE3, $D00, $D01, $D3B, $D3C, $D41..$D44, $D4D, $D62, $D63, $D81, $DCA, $DD2..$DD4, 
        $DD6, $E31, $E34: result := ubcNonSpacingMark;
        $E35..$E3A, $E47..$E4E, $EB1, $EB4..$EBC, $EC8..$ECD, $F18, $F19, $F35, $F37, $F39, $F71..$F7E, 
        $F80..$F84, $F86, $F87, $F8D..$F97, $F99..$FBC, $FC6: result := ubcNonSpacingMark;
        $C78..$C7E: result := ubcOtherNeutrals;
        $F3A..$F3D: result := ubcMirroredNeutral;
      else result := ubcUnknown;
      end;
    $01000..$017FF:
      case u of
        $1680: result := ubcWhiteSpace;
        $1000..$102A, $103F..$1055, $105A..$105D, $1061, $1065, $1066, $106E..$1070, $1075..$1081, 
        $108E, $1090..$1099, $109E..$10C5, $10C7, $10CD, $10D0..$1248, $124A..$124D, $1250..$1256, 
        $1258, $125A..$125D, $1260..$1288, $128A..$128D, $1290..$12B0, $12B2..$12B5, $12B8: result := ubcLeftToRight;
        $12B9..$12BE, $12C0, $12C2..$12C5, $12C8..$12D6, $12D8..$1310, $1312..$1315, $1318..$135A, 
        $1360..$137C, $1380..$138F, $13A0..$13F5, $13F8..$13FD, $1401..$167F, $1681..$169A, $16A0..$16F8, 
        $1700..$170C, $170E..$1711, $1720..$1731, $1735, $1736, $1740..$1751, $1760..$176C, $176E..$1770, 
        $1780: result := ubcLeftToRight;
        $1781..$17B3, $17D4..$17DA, $17DC, $17E0..$17E9: result := ubcLeftToRight;
        $102B, $102C, $1031, $1038, $103B, $103C, $1056, $1057, $1062..$1064, $1067..$106D, $1083, 
        $1084, $1087..$108C, $108F, $109A..$109C, $17B6, $17BE..$17C5, $17C7, $17C8: result := ubcCombiningLeftToRight;
        $17DB: result := ubcEuropeanNumberTerminator;
        $102D..$1030, $1032..$1037, $1039, $103A, $103D, $103E, $1058, $1059, $105E..$1060, $1071..$1074, 
        $1082, $1085, $1086, $108D, $109D, $135D..$135F, $1712..$1714, $1732..$1734, $1752, $1753, 
        $1772, $1773, $17B4, $17B5, $17B7..$17BD, $17C6, $17C9..$17D3, $17DD: result := ubcNonSpacingMark;
        $1390..$1399, $1400, $17F0..$17F9: result := ubcOtherNeutrals;
        $169B, $169C: result := ubcMirroredNeutral;
      else result := ubcUnknown;
      end;
    $01800..$01FFF:
      case u of
        $180E: result := ubcBoundaryNeutral;
        $1810..$1819, $1820..$1878, $1880..$1884, $1887..$18A8, $18AA, $18B0..$18F5, $1900..$191E, 
        $1946..$196D, $1970..$1974, $1980..$19AB, $19B0..$19C9, $19D0..$19DA, $1A00..$1A16, $1A1E..$1A54, 
        $1A80..$1A89, $1A90..$1A99, $1AA0..$1AAD, $1B05..$1B33, $1B45..$1B4B, $1B50..$1B6A, $1B74..$1B7C, 
        $1B83: result := ubcLeftToRight;
        $1923..$1926, $1929..$192B, $1930, $1931, $1933..$1938, $1A19, $1A1A, $1A55, $1A57, $1A61, 
        $1A63, $1A64, $1A6D..$1A72, $1B04, $1B35, $1B3B, $1B3D..$1B41, $1B43, $1B44, $1B82, $1BA1, 
        $1BA6, $1BA7, $1BAA, $1BE7, $1BEA..$1BEC, $1BEE: result := ubcCombiningLeftToRight;
        $1B84..$1BA0, $1BAE..$1BE5, $1BFC..$1C23, $1C3B..$1C49, $1C4D..$1C88, $1C90..$1CBA, $1CBD..$1CC7, 
        $1CD3, $1CE9..$1CEC, $1CEE..$1CF3, $1CF5, $1CF6, $1CFA, $1D00..$1DBF, $1E00..$1F15, $1F18..$1F1D, 
        $1F20..$1F45, $1F48..$1F4D, $1F50..$1F57, $1F59, $1F5B, $1F5D, $1F5F: result := ubcLeftToRight;
        $1F60..$1F7D, $1F80..$1FB4, $1FB6..$1FBC, $1FBE, $1FC2..$1FC4, $1FC6..$1FCC, $1FD0..$1FD3, 
        $1FD6..$1FDB, $1FE0..$1FEC, $1FF2..$1FF4, $1FF6..$1FFC: result := ubcLeftToRight;
        $1BF2, $1BF3, $1C24..$1C2B, $1C34, $1C35, $1CE1, $1CF7: result := ubcCombiningLeftToRight;
        $180B..$180D, $1885, $1886, $18A9, $1920..$1922, $1927, $1928, $1932, $1939..$193B, $1A17, 
        $1A18, $1A1B, $1A56, $1A58..$1A5E, $1A60, $1A62, $1A65..$1A6C, $1A73..$1A7C, $1A7F, $1AB0..$1AC0, 
        $1B00..$1B03, $1B34, $1B36..$1B3A, $1B3C, $1B42: result := ubcNonSpacingMark;
        $1B6B..$1B73, $1B80, $1B81, $1BA2..$1BA5, $1BA8, $1BA9, $1BAB..$1BAD, $1BE6, $1BE8, $1BE9, 
        $1BED, $1BEF..$1BF1, $1C2C..$1C33, $1C36, $1C37, $1CD0..$1CD2, $1CD4..$1CE0, $1CE2..$1CE8, 
        $1CED, $1CF4, $1CF8, $1CF9, $1DC0..$1DF9, $1DFB..$1DFF: result := ubcNonSpacingMark;
        $1800..$180A, $1940, $1944, $1945, $19DE..$19FF, $1FBD, $1FBF..$1FC1, $1FCD..$1FCF, $1FDD..$1FDF, 
        $1FED..$1FEF, $1FFD, $1FFE: result := ubcOtherNeutrals;
      else result := ubcUnknown;
      end;
    $02000..$02FFF:
      case u of
        $200B..$200D, $2060..$2064, $206A..$206F: result := ubcBoundaryNeutral;
        $2029: result := ubcParagraphSeparator;
        $2000..$200A, $2028, $205F: result := ubcWhiteSpace;
        $200E, $2071, $207F, $2090..$209C, $2102, $2107, $210A..$2113, $2115, $2119..$211D, $2124, 
        $2126, $2128, $212A..$212D, $212F..$2139, $213C..$213F, $2145..$2149, $214E, $214F, $2160..$2188, 
        $2336..$237A, $2395, $249C..$24E9, $26AC: result := ubcLeftToRight;
        $2800..$28FF, $2C00..$2C2E, $2C30..$2C5E, $2C60..$2CE4, $2CEB..$2CEE, $2CF2, $2CF3, $2D00..$2D25, 
        $2D27, $2D2D, $2D30..$2D67, $2D6F, $2D70, $2D80..$2D96, $2DA0..$2DA6, $2DA8..$2DAE, $2DB0..$2DB6, 
        $2DB8..$2DBE, $2DC0..$2DC6, $2DC8..$2DCE, $2DD0..$2DD6, $2DD8..$2DDE: result := ubcLeftToRight;
        $200F: result := ubcRightToLeft;
        $2070, $2074..$2079, $2080..$2089, $2488..$249B: result := ubcEuropeanNumber;
        $207A, $207B, $208A, $208B, $2212: result := ubcEuropeanNumberSeparator;
        $2030..$2034, $20A0..$20BF, $212E, $2213: result := ubcEuropeanNumberTerminator;
        $202F, $2044: result := ubcCommonSeparator;
        $20D0..$20F0, $2CEF..$2CF1, $2D7F, $2DE0..$2DFF: result := ubcNonSpacingMark;
        $2010..$2027, $2035..$2038, $203B..$2043, $2047..$205E, $207C, $208C, $2100, $2101, $2103..$2106, 
        $2108, $2109, $2114, $2116..$2118, $211E..$2123, $2125, $2127, $2129, $213A, $213B, $2141..$2144, 
        $214A..$214D, $2150..$215F, $2189..$218B, $2190..$2200, $2205: result := ubcOtherNeutrals;
        $2039, $203A, $2045, $2046, $207D, $207E, $208D, $208E, $2140, $2201..$2204, $2208..$220D, 
        $2211, $2215, $2216, $221A..$221D, $221F..$2222, $2224, $2226, $222B..$2233, $2239, $223B..$224C, 
        $2252..$2255, $225F, $2260, $2262, $2264..$226B, $226E..$228C, $228F: result := ubcMirroredNeutral;
        $2206, $2207, $220E..$2210, $2214, $2217..$2219, $221E, $2223, $2225, $2227..$222A, $2234..$2238, 
        $223A, $224D..$2251, $2256..$225E, $2261, $2263, $226C, $226D, $228D, $228E, $2293..$2297, 
        $2299..$22A1, $22A4, $22A5, $22B9..$22BD, $22C0..$22C8, $22CE: result := ubcOtherNeutrals;
        $22CF, $22D2..$22D5, $22EE, $22EF, $2300..$2307, $230C..$231F, $2322..$2328, $232B..$2335, 
        $237B..$2394, $2396..$2426, $2440..$244A, $2460..$2487, $24EA..$26AB, $26AD..$2767, $2776..$27BF, 
        $27C1, $27C2, $27C7, $27CA, $27CE..$27D2, $27D7..$27DB, $27DF..$27E1, $27F0..$27FF, $2900: result := ubcOtherNeutrals;
        $2290..$2292, $2298, $22A2, $22A3, $22A6..$22B8, $22BE, $22BF, $22C9..$22CD, $22D0, $22D1, 
        $22D6..$22ED, $22F0..$22FF, $2308..$230B, $2320, $2321, $2329, $232A, $2768..$2775, $27C0, 
        $27C3..$27C6, $27C8, $27C9, $27CB..$27CD, $27D3..$27D6, $27DC..$27DE, $27E2..$27EF, $2983..$2998, 
        $299B: result := ubcMirroredNeutral;
        $2901..$2982, $2999, $299A, $29A1, $29B0..$29B7, $29B9..$29BF, $29C6..$29C8, $29CA..$29CD, 
        $29D3, $29D6, $29D7, $29DD..$29E0, $29E2, $29E6, $29E7, $29EA..$29F3, $29FA, $29FB, $29FE..$2A09, 
        $2A1D, $2A22, $2A23, $2A25, $2A27, $2A28, $2A2A, $2A2F..$2A33, $2A36: result := ubcOtherNeutrals;
        $299C..$29A0, $29A2..$29AF, $29B8, $29C0..$29C5, $29C9, $29CE..$29D2, $29D4, $29D5, $29D8..$29DC, 
        $29E1, $29E3..$29E5, $29E8, $29E9, $29F4..$29F9, $29FC, $29FD, $2A0A..$2A1C, $2A1E..$2A21, 
        $2A24, $2A26, $2A29, $2A2B..$2A2E, $2A34, $2A35, $2A3C..$2A3E, $2A57: result := ubcMirroredNeutral;
        $2A37..$2A3B, $2A3F..$2A56, $2A59..$2A63, $2A66..$2A69, $2A6E, $2A71, $2A72, $2A75..$2A78, 
        $2AA4, $2AA5, $2AAE, $2AD7..$2ADB, $2ADD, $2ADF..$2AE1, $2AE7..$2AEB, $2AEF..$2AF2, $2AF4..$2AF6, 
        $2AFC, $2AFE..$2B73, $2B76..$2B95, $2B97..$2BFD, $2BFF, $2CE5..$2CEA, $2CF9: result := ubcOtherNeutrals;
        $2CFA..$2CFF, $2E00, $2E01, $2E06..$2E08, $2E0B, $2E0E..$2E1B, $2E1E, $2E1F, $2E2A..$2E52, 
        $2E80..$2E99, $2E9B..$2EF3, $2F00..$2FD5, $2FF0..$2FFB: result := ubcOtherNeutrals;
        $2A58, $2A64, $2A65, $2A6A..$2A6D, $2A6F, $2A70, $2A73, $2A74, $2A79..$2AA3, $2AA6..$2AAD, 
        $2AAF..$2AD6, $2ADC, $2ADE, $2AE2..$2AE6, $2AEC..$2AEE, $2AF3, $2AF7..$2AFB, $2AFD, $2BFE, 
        $2E02..$2E05, $2E09, $2E0A, $2E0C, $2E0D, $2E1C, $2E1D, $2E20..$2E29: result := ubcMirroredNeutral;
      else result := ubcUnknown;
      end;
    else
      case u of
        $3000: result := ubcWhiteSpace;
        $3005..$3007, $3021..$3029, $3031..$3035, $3038..$303C, $3041..$3096, $309D..$309F, $30A1..$30FA, 
        $30FC..$30FF, $3105..$312F, $3131..$318E, $3190..$31BF, $31F0..$321C, $3220..$324F, $3260..$327B, 
        $327F..$32B0, $32C0..$32CB, $32D0..$3376, $337B..$33DD, $33E0..$33FE, $3400, $4DBF, $4E00: result := ubcLeftToRight;
        $302E, $302F: result := ubcCombiningLeftToRight;
        $302A..$302D, $3099, $309A: result := ubcNonSpacingMark;
        $3001..$3004, $3012, $3013, $301C..$3020, $3030, $3036, $3037, $303D..$303F, $309B, $309C, 
        $30A0, $30FB, $31C0..$31E3, $321D, $321E, $3250..$325F, $327C..$327E, $32B1..$32BF, $32CC..$32CF, 
        $3377..$337A, $33DE, $33DF, $33FF, $4DC0..$4DFF: result := ubcOtherNeutrals;
        $3008..$3011, $3014..$301B: result := ubcMirroredNeutral;
      else result := ubcUnknown;
      end;
    end;
  $08000..$0BFFF:
      case u of
        $9FFC, $A000..$A48C, $A4D0..$A60C, $A610..$A62B, $A640..$A66E, $A680..$A69D, $A6A0..$A6EF, 
        $A6F2..$A6F7, $A722..$A787, $A789..$A7BF, $A7C2..$A7CA, $A7F5..$A801, $A803..$A805, $A807..$A80A, 
        $A80C..$A822, $A830..$A837, $A840..$A873, $A882..$A8B3, $A8CE..$A8D9, $A8F2..$A8FE, $A900..$A925, 
        $A92E: result := ubcLeftToRight;
        $A92F..$A946, $A95F..$A97C, $A984..$A9B2, $A9C1..$A9CD, $A9CF..$A9D9, $A9DE..$A9E4, $A9E6..$A9FE, 
        $AA00..$AA28, $AA40..$AA42, $AA44..$AA4B, $AA50..$AA59, $AA5C..$AA7A, $AA7E..$AAAF, $AAB1, 
        $AAB5, $AAB6, $AAB9..$AABD, $AAC0, $AAC2, $AADB..$AAEA, $AAF0..$AAF4, $AB01..$AB06, $AB09: result := ubcLeftToRight;
        $AB0A..$AB0E, $AB11..$AB16, $AB20..$AB26, $AB28..$AB2E, $AB30..$AB69, $AB70..$ABE2, $ABEB, 
        $ABF0..$ABF9, $AC00: result := ubcLeftToRight;
        $A823, $A824, $A827, $A880, $A881, $A8B4..$A8C3, $A952, $A953, $A983, $A9B4, $A9B5, $A9BA, 
        $A9BB, $A9BE..$A9C0, $AA2F, $AA30, $AA33, $AA34, $AA4D, $AA7B, $AA7D, $AAEB, $AAEE, $AAEF, 
        $AAF5, $ABE3, $ABE4, $ABE6, $ABE7, $ABE9, $ABEA, $ABEC: result := ubcCombiningLeftToRight;
        $A838, $A839: result := ubcEuropeanNumberTerminator;
        $A66F..$A672, $A674..$A67D, $A69E, $A69F, $A6F0, $A6F1, $A802, $A806, $A80B, $A825, $A826, 
        $A82C, $A8C4, $A8C5, $A8E0..$A8F1, $A8FF, $A926..$A92D, $A947..$A951, $A980..$A982, $A9B3, 
        $A9B6..$A9B9, $A9BC, $A9BD, $A9E5, $AA29..$AA2E, $AA31, $AA32, $AA35: result := ubcNonSpacingMark;
        $AA36, $AA43, $AA4C, $AA7C, $AAB0, $AAB2..$AAB4, $AAB7, $AAB8, $AABE, $AABF, $AAC1, $AAEC, 
        $AAED, $AAF6, $ABE5, $ABE8, $ABED: result := ubcNonSpacingMark;
        $A490..$A4C6, $A60D..$A60F, $A673, $A67E, $A67F, $A700..$A721, $A788, $A828..$A82B, $A874..$A877, 
        $AB6A, $AB6B: result := ubcOtherNeutrals;
      else result := ubcUnknown;
      end;
  $0C000..$0FFFF:
      case u of
        $FEFF: result := ubcBoundaryNeutral;
        $D7A3, $D7B0..$D7C6, $D7CB..$D7FB, $D800, $DB7F, $DB80, $DBFF, $DC00, $DFFF, $E000, $F8FF..$FA6D, 
        $FA70..$FAD9, $FB00..$FB06, $FB13..$FB17, $FF21..$FF3A, $FF41..$FF5A, $FF66..$FFBE, $FFC2..$FFC7, 
        $FFCA..$FFCF, $FFD2..$FFD7, $FFDA..$FFDC: result := ubcLeftToRight;
        $FB1D, $FB1F..$FB28, $FB2A..$FB36, $FB38..$FB3C, $FB3E, $FB40, $FB41, $FB43, $FB44, $FB46..$FB4F: result := ubcRightToLeft;
        $FB50..$FBC1, $FBD3..$FD3D, $FD50..$FD8F, $FD92..$FDC7, $FDF0..$FDFC, $FE70..$FE74, $FE76..$FEFC: result := ubcArabicLetter;
        $FF10..$FF19: result := ubcEuropeanNumber;
        $FB29, $FE62, $FE63, $FF0B, $FF0D: result := ubcEuropeanNumberSeparator;
        $FE5F, $FE69, $FE6A, $FF03..$FF05, $FFE0, $FFE1, $FFE5, $FFE6: result := ubcEuropeanNumberTerminator;
        $FE50, $FE52, $FE55, $FF0C, $FF0E, $FF0F, $FF1A: result := ubcCommonSeparator;
        $FB1E, $FE00..$FE0F, $FE20..$FE2F: result := ubcNonSpacingMark;
        $FD3E, $FD3F, $FDFD, $FE10..$FE19, $FE30..$FE4F, $FE51, $FE54, $FE56..$FE58, $FE60, $FE61, 
        $FE66, $FE68, $FE6B, $FF01, $FF02, $FF06, $FF07, $FF0A, $FF1B, $FF1D, $FF1F, $FF20, $FF3C, 
        $FF3E..$FF40, $FF5C, $FF5E, $FF61: result := ubcOtherNeutrals;
        $FF64, $FF65, $FFE2..$FFE4, $FFE8..$FFEE, $FFF9..$FFFD: result := ubcOtherNeutrals;
        $FE59..$FE5E, $FE64, $FE65, $FF08, $FF09, $FF1C, $FF1E, $FF3B, $FF3D, $FF5B, $FF5D, $FF5F, 
        $FF60, $FF62, $FF63: result := ubcMirroredNeutral;
      else result := ubcUnknown;
      end;
  else
    case u of
    $10000..$107FF:
      case u of
        $10000..$1000B, $1000D..$10026, $10028..$1003A, $1003C, $1003D, $1003F..$1004D, $10050..$1005D, 
        $10080..$100FA, $10100, $10102, $10107..$10133, $10137..$1013F, $1018D, $1018E, $101D0..$101FC, 
        $10280..$1029C, $102A0..$102D0, $10300..$10323, $1032D..$1034A, $10350..$10375, $10380..$1039D, 
        $1039F..$103C3, $103C8..$103D5, $10400: result := ubcLeftToRight;
        $10401..$1049D, $104A0..$104A9, $104B0..$104D3, $104D8..$104FB, $10500..$10527, $10530..$10563, 
        $1056F, $10600..$10736, $10740..$10755, $10760..$10767: result := ubcLeftToRight;
        $102E1..$102FB: result := ubcEuropeanNumber;
        $101FD, $102E0, $10376..$1037A: result := ubcNonSpacingMark;
        $10101, $10140..$1018C, $10190..$1019C, $101A0: result := ubcOtherNeutrals;
      else result := ubcUnknown;
      end;
    $10800..$10FFF:
      case u of
        $10800..$10805, $10808, $1080A..$10835, $10837, $10838, $1083C, $1083F..$10855, $10857..$1089E, 
        $108A7..$108AF, $108E0..$108F2, $108F4, $108F5, $108FB..$1091B, $10920..$10939, $1093F, 
        $10980..$109B7, $109BC..$109CF, $109D2..$10A00, $10A10..$10A13, $10A15..$10A17, $10A19..$10A35, 
        $10A40..$10A48, $10A50..$10A58, $10A60: result := ubcRightToLeft;
        $10A61..$10A9F, $10AC0..$10AE4, $10AEB..$10AF6, $10B00..$10B35, $10B40..$10B55, $10B58..$10B72, 
        $10B78..$10B91, $10B99..$10B9C, $10BA9..$10BAF, $10C00..$10C48, $10C80..$10CB2, $10CC0..$10CF2, 
        $10CFA..$10CFF, $10E80..$10EA9, $10EAD, $10EB0, $10EB1, $10F00..$10F27, $10FB0..$10FCB, 
        $10FE0..$10FF6: result := ubcRightToLeft;
        $10D00..$10D23, $10F30..$10F45, $10F51..$10F59: result := ubcArabicLetter;
        $10D30..$10D39, $10E60..$10E7E: result := ubcArabicNumber;
        $10A01..$10A03, $10A05, $10A06, $10A0C..$10A0F, $10A38..$10A3A, $10A3F, $10AE5, $10AE6, 
        $10D24..$10D27, $10EAB, $10EAC, $10F46..$10F50: result := ubcNonSpacingMark;
        $1091F, $10B39..$10B3F: result := ubcOtherNeutrals;
      else result := ubcUnknown;
      end;
    $11000..$117FF:
      case u of
        $11003..$11037, $11047..$1104D, $11066..$1106F, $11083..$110AF, $110BB..$110C1, $110CD, 
        $110D0..$110E8, $110F0..$110F9, $11103..$11126, $11136..$11144, $11147, $11150..$11172, 
        $11174..$11176, $11183..$111B2, $111C1..$111C8, $111CD, $111D0..$111DF, $111E1..$111F4, 
        $11200..$11211, $11213..$1122B, $11238..$1123D, $11280: result := ubcLeftToRight;
        $11000, $11002, $11082, $110B0..$110B2, $110B7, $110B8, $1112C, $11145, $11146, $11182, 
        $111B3..$111B5, $111BF, $111C0, $111CE, $1122C..$1122E, $11232, $11233, $11235, $112E0..$112E2, 
        $11302, $11303, $1133E, $1133F, $11341..$11344, $11347, $11348, $1134B..$1134D, $11357, 
        $11362: result := ubcCombiningLeftToRight;
        $11281..$11286, $11288, $1128A..$1128D, $1128F..$1129D, $1129F..$112A9, $112B0..$112DE, 
        $112F0..$112F9, $11305..$1130C, $1130F, $11310, $11313..$11328, $1132A..$11330, $11332, 
        $11333, $11335..$11339, $1133D, $11350, $1135D..$11361, $11400..$11434, $11447..$1145B, 
        $1145D, $1145F..$11461, $11480..$114AF, $114C4: result := ubcLeftToRight;
        $114C5..$114C7, $114D0..$114D9, $11580..$115AE, $115C1..$115DB, $11600..$1162F, $11641..$11644, 
        $11650..$11659, $11680..$116AA, $116B8, $116C0..$116C9, $11700..$1171A, $11730..$1173F: result := ubcLeftToRight;
        $11363, $11435..$11437, $11440, $11441, $11445, $114B0..$114B2, $114B9, $114BB..$114BE, 
        $114C1, $115AF..$115B1, $115B8..$115BB, $115BE, $11630..$11632, $1163B, $1163C, $1163E, 
        $116AC, $116AE, $116AF, $116B6, $11720, $11721, $11726: result := ubcCombiningLeftToRight;
        $11001, $11038..$11046, $1107F..$11081, $110B3..$110B6, $110B9, $110BA, $11100..$11102, 
        $11127..$1112B, $1112D..$11134, $11173, $11180, $11181, $111B6..$111BE, $111C9..$111CC, 
        $111CF, $1122F..$11231, $11234, $11236, $11237, $1123E, $112DF, $112E3..$112EA, $11300, 
        $11301, $1133B, $1133C, $11340: result := ubcNonSpacingMark;
        $11366..$1136C, $11370..$11374, $11438..$1143F, $11442..$11444, $11446, $1145E, $114B3..$114B8, 
        $114BA, $114BF, $114C0, $114C2, $114C3, $115B2..$115B5, $115BC, $115BD, $115BF, $115C0, 
        $115DC, $115DD, $11633..$1163A, $1163D, $1163F, $11640, $116AB, $116AD, $116B0..$116B5, 
        $116B7, $1171D: result := ubcNonSpacingMark;
        $1171E, $1171F, $11722..$11725, $11727..$1172B: result := ubcNonSpacingMark;
        $11052..$11065, $11660..$1166C: result := ubcOtherNeutrals;
      else result := ubcUnknown;
      end;
    $11800..$17FFF:
      case u of
        $11800..$1182B, $1183B, $118A0..$118F2, $118FF..$11906, $11909, $1190C..$11913, $11915, 
        $11916, $11918..$1192F, $1193F, $11941, $11944..$11946, $11950..$11959, $119A0..$119A7, 
        $119AA..$119D0, $119E1..$119E3, $11A00, $11A07, $11A08, $11A0B..$11A32, $11A3A, $11A3F..$11A46, 
        $11A50, $11A5C: result := ubcLeftToRight;
        $1182C..$1182E, $11838, $11930..$11935, $11937, $11938, $1193D, $11940, $11942, $119D1..$119D3, 
        $119DC..$119DF, $119E4, $11A39, $11A57, $11A58, $11A97, $11C2F, $11C3E, $11CA9, $11CB1, 
        $11CB4, $11D8A..$11D8E, $11D93, $11D94, $11D96, $11EF5: result := ubcCombiningLeftToRight;
        $11A5D..$11A89, $11A9A..$11AA2, $11AC0..$11AF8, $11C00..$11C08, $11C0A..$11C2E, $11C3F..$11C45, 
        $11C50..$11C6C, $11C70..$11C8F, $11D00..$11D06, $11D08, $11D09, $11D0B..$11D30, $11D46, 
        $11D50..$11D59, $11D60..$11D65, $11D67, $11D68, $11D6A..$11D89, $11D98, $11DA0..$11DA9, 
        $11EE0..$11EF2, $11EF7, $11EF8, $11FB0, $11FC0: result := ubcLeftToRight;
        $11FC1..$11FD4, $11FFF..$12399, $12400..$1246E, $12470..$12474, $12480..$12543, $13000..$1342E, 
        $13430..$13438, $14400..$14646, $16800..$16A38, $16A40..$16A5E, $16A60..$16A69, $16A6E, 
        $16A6F, $16AD0..$16AED, $16AF5, $16B00..$16B2F, $16B37..$16B45, $16B50..$16B59, $16B5B..$16B61, 
        $16B63..$16B77, $16B7D..$16B8F, $16E40..$16E9A, $16F00: result := ubcLeftToRight;
        $16F01..$16F4A, $16F50, $16F93..$16F9F, $16FE0, $16FE1, $16FE3, $17000: result := ubcLeftToRight;
        $11EF6, $16F51..$16F87, $16FF0, $16FF1: result := ubcCombiningLeftToRight;
        $11FDD..$11FE0: result := ubcEuropeanNumberTerminator;
        $1182F..$11837, $11839, $1183A, $1193B, $1193C, $1193E, $11943, $119D4..$119D7, $119DA, 
        $119DB, $119E0, $11A01..$11A06, $11A09, $11A0A, $11A33..$11A38, $11A3B..$11A3E, $11A47, 
        $11A51..$11A56, $11A59..$11A5B, $11A8A..$11A96, $11A98, $11A99, $11C30..$11C36, $11C38..$11C3D, 
        $11C92..$11CA7, $11CAA..$11CB0, $11CB2: result := ubcNonSpacingMark;
        $11CB3, $11CB5, $11CB6, $11D31..$11D36, $11D3A, $11D3C, $11D3D, $11D3F..$11D45, $11D47, 
        $11D90, $11D91, $11D95, $11D97, $11EF3, $11EF4, $16AF0..$16AF4, $16B30..$16B36, $16F4F, 
        $16F8F..$16F92, $16FE4: result := ubcNonSpacingMark;
        $11FD5..$11FDC, $11FE1..$11FF1, $16FE2: result := ubcOtherNeutrals;
      else result := ubcUnknown;
      end;
    $18000..$1DFFF:
      case u of
        $1BCA0..$1BCA3, $1D173..$1D17A: result := ubcBoundaryNeutral;
        $187F7, $18800..$18CD5, $18D00, $18D08, $1B000..$1B11E, $1B150..$1B152, $1B164..$1B167, 
        $1B170..$1B2FB, $1BC00..$1BC6A, $1BC70..$1BC7C, $1BC80..$1BC88, $1BC90..$1BC99, $1BC9C, 
        $1BC9F, $1D000..$1D0F5, $1D100..$1D126, $1D129..$1D164, $1D16A..$1D16C, $1D183, $1D184, 
        $1D18C..$1D1A9, $1D1AE..$1D1E8, $1D2E0: result := ubcLeftToRight;
        $1D2E1..$1D2F3, $1D360..$1D378, $1D400..$1D454, $1D456..$1D49C, $1D49E, $1D49F, $1D4A2, 
        $1D4A5, $1D4A6, $1D4A9..$1D4AC, $1D4AE..$1D4B9, $1D4BB, $1D4BD..$1D4C3, $1D4C5..$1D505, 
        $1D507..$1D50A, $1D50D..$1D514, $1D516..$1D51C, $1D51E..$1D539, $1D53B..$1D53E, $1D540..$1D544, 
        $1D546, $1D54A..$1D550, $1D552..$1D6A5, $1D6A8: result := ubcLeftToRight;
        $1D6A9..$1D6DA, $1D6DC..$1D714, $1D716..$1D74E, $1D750..$1D788, $1D78A..$1D7C2, $1D7C4..$1D7CB, 
        $1D800..$1D9FF, $1DA37..$1DA3A, $1DA6D..$1DA74, $1DA76..$1DA83, $1DA85..$1DA8B: result := ubcLeftToRight;
        $1D165, $1D166, $1D16D..$1D172: result := ubcCombiningLeftToRight;
        $1D7CE..$1D7FF: result := ubcEuropeanNumber;
        $1BC9D, $1BC9E, $1D167..$1D169, $1D17B..$1D182, $1D185..$1D18B, $1D1AA..$1D1AD, $1D242..$1D244, 
        $1DA00..$1DA36, $1DA3B..$1DA6C, $1DA75, $1DA84, $1DA9B..$1DA9F, $1DAA1..$1DAAF: result := ubcNonSpacingMark;
        $1D200..$1D241, $1D245, $1D300..$1D356: result := ubcOtherNeutrals;
        $1D6DB, $1D715, $1D74F, $1D789, $1D7C3: result := ubcMirroredNeutral;
      else result := ubcUnknown;
      end;
    $1E000..$FFFFF:
      case u of
        $E0001, $E0020..$E007F: result := ubcBoundaryNeutral;
        $1EC71..$1ECB4, $1ED01..$1ED3D, $1EE00..$1EE03, $1EE05..$1EE1F, $1EE21, $1EE22, $1EE24, 
        $1EE27, $1EE29..$1EE32, $1EE34..$1EE37, $1EE39, $1EE3B, $1EE42, $1EE47, $1EE49, $1EE4B, 
        $1EE4D..$1EE4F, $1EE51, $1EE52, $1EE54, $1EE57, $1EE59, $1EE5B, $1EE5D: result := ubcArabicLetter;
        $1E100..$1E12C, $1E137..$1E13D, $1E140..$1E149, $1E14E, $1E14F, $1E2C0..$1E2EB, $1E2F0..$1E2F9, 
        $1F110..$1F12E, $1F130..$1F169, $1F170..$1F1AC, $1F1E6..$1F202, $1F210..$1F23B, $1F240..$1F248, 
        $1F250, $1F251, $20000, $2A6DD, $2A700, $2B734, $2B740, $2B81D, $2B820, $2CEA1, $2CEB0: result := ubcLeftToRight;
        $2EBE0, $2F800..$2FA1D, $30000, $3134A, $F0000, $FFFFD: result := ubcLeftToRight;
        $1E800..$1E8C4, $1E8C7..$1E8CF, $1E900..$1E943, $1E94B, $1E950..$1E959, $1E95E, $1E95F: result := ubcRightToLeft;
        $1EE5F, $1EE61, $1EE62, $1EE64, $1EE67..$1EE6A, $1EE6C..$1EE72, $1EE74..$1EE77, $1EE79..$1EE7C, 
        $1EE7E, $1EE80..$1EE89, $1EE8B..$1EE9B, $1EEA1..$1EEA3, $1EEA5..$1EEA9, $1EEAB..$1EEBB: result := ubcArabicLetter;
        $1F100..$1F10A, $1FBF0..$1FBF9: result := ubcEuropeanNumber;
        $1E2FF: result := ubcEuropeanNumberTerminator;
        $1E000..$1E006, $1E008..$1E018, $1E01B..$1E021, $1E023, $1E024, $1E026..$1E02A, $1E130..$1E136, 
        $1E2EC..$1E2EF, $1E8D0..$1E8D6, $1E944..$1E94A, $E0100..$E01EF: result := ubcNonSpacingMark;
        $1EEF0, $1EEF1, $1F000..$1F02B, $1F030..$1F093, $1F0A0..$1F0AE, $1F0B1..$1F0BF, $1F0C1..$1F0CF, 
        $1F0D1..$1F0F5, $1F10B..$1F10F, $1F12F, $1F16A..$1F16F, $1F1AD, $1F260..$1F265, $1F300..$1F6D7, 
        $1F6E0..$1F6EC, $1F6F0..$1F6FC, $1F700..$1F773, $1F780..$1F7D8, $1F7E0..$1F7EB, $1F800..$1F80B, 
        $1F810..$1F847, $1F850..$1F859, $1F860: result := ubcOtherNeutrals;
        $1F861..$1F887, $1F890..$1F8AD, $1F8B0, $1F8B1, $1F900..$1F978, $1F97A..$1F9CB, $1F9CD..$1FA53, 
        $1FA60..$1FA6D, $1FA70..$1FA74, $1FA78..$1FA7A, $1FA80..$1FA86, $1FA90..$1FAA8, $1FAB0..$1FAB6, 
        $1FAC0..$1FAC2, $1FAD0..$1FAD6, $1FB00..$1FB92, $1FB94..$1FBCA: result := ubcOtherNeutrals;
      else result := ubcUnknown;
      end;
    else result := ubcUnknown;
    end
  end
end;

function GetUnicodeBracketInfo(u: LongWord): TUnicodeBracketInfo;
  procedure Bracket(AOpening,AClosing: LongWord);
  begin
    result.IsBracket := true;
    result.OpeningBracket := AOpening;
    result.ClosingBracket := AClosing;
  end;
begin
  case u of
  $0028, $0029: Bracket($0028, $0029);
  $005B, $005D: Bracket($005B, $005D);
  $007B, $007D: Bracket($007B, $007D);
  $0F3A, $0F3B: Bracket($0F3A, $0F3B);
  $0F3C, $0F3D: Bracket($0F3C, $0F3D);
  $169B, $169C: Bracket($169B, $169C);
  $2045, $2046: Bracket($2045, $2046);
  $207D, $207E: Bracket($207D, $207E);
  $208D, $208E: Bracket($208D, $208E);
  $2308, $2309: Bracket($2308, $2309);
  $230A, $230B: Bracket($230A, $230B);
  $2329, $232A: Bracket($2329, $232A);
  $2768, $2769: Bracket($2768, $2769);
  $276A, $276B: Bracket($276A, $276B);
  $276C, $276D: Bracket($276C, $276D);
  $276E, $276F: Bracket($276E, $276F);
  $2770, $2771: Bracket($2770, $2771);
  $2772, $2773: Bracket($2772, $2773);
  $2774, $2775: Bracket($2774, $2775);
  $27C5, $27C6: Bracket($27C5, $27C6);
  $27E6, $27E7: Bracket($27E6, $27E7);
  $27E8, $27E9: Bracket($27E8, $27E9);
  $27EA, $27EB: Bracket($27EA, $27EB);
  $27EC, $27ED: Bracket($27EC, $27ED);
  $27EE, $27EF: Bracket($27EE, $27EF);
  $2983, $2984: Bracket($2983, $2984);
  $2985, $2986: Bracket($2985, $2986);
  $2987, $2988: Bracket($2987, $2988);
  $2989, $298A: Bracket($2989, $298A);
  $298B, $298C: Bracket($298B, $298C);
  $298D, $2990: Bracket($298D, $2990);
  $298F, $298E: Bracket($298F, $298E);
  $2991, $2992: Bracket($2991, $2992);
  $2993, $2994: Bracket($2993, $2994);
  $2995, $2996: Bracket($2995, $2996);
  $2997, $2998: Bracket($2997, $2998);
  $29D8, $29D9: Bracket($29D8, $29D9);
  $29DA, $29DB: Bracket($29DA, $29DB);
  $29FC, $29FD: Bracket($29FC, $29FD);
  $2E22, $2E23: Bracket($2E22, $2E23);
  $2E24, $2E25: Bracket($2E24, $2E25);
  $2E26, $2E27: Bracket($2E26, $2E27);
  $2E28, $2E29: Bracket($2E28, $2E29);
  $3008, $3009: Bracket($3008, $3009);
  $300A, $300B: Bracket($300A, $300B);
  $300C, $300D: Bracket($300C, $300D);
  $300E, $300F: Bracket($300E, $300F);
  $3010, $3011: Bracket($3010, $3011);
  $3014, $3015: Bracket($3014, $3015);
  $3016, $3017: Bracket($3016, $3017);
  $3018, $3019: Bracket($3018, $3019);
  $301A, $301B: Bracket($301A, $301B);
  $FE59, $FE5A: Bracket($FE59, $FE5A);
  $FE5B, $FE5C: Bracket($FE5B, $FE5C);
  $FE5D, $FE5E: Bracket($FE5D, $FE5E);
  $FF08, $FF09: Bracket($FF08, $FF09);
  $FF3B, $FF3D: Bracket($FF3B, $FF3D);
  $FF5B, $FF5D: Bracket($FF5B, $FF5D);
  $FF5F, $FF60: Bracket($FF5F, $FF60);
  $FF62, $FF63: Bracket($FF62, $FF63);
  else
    begin
      result.IsBracket := false;
      result.OpeningBracket := 0;
      result.ClosingBracket := 0;
    end;
  end;
end;

function GetUnicodeJoiningType(u: LongWord): TUnicodeJoiningType;
begin
  result := ujtNonJoining;
  if u <= $001BE8 then begin
    if u <= $0009CD then begin
      if u <= $00072C then begin
        if u <= $00069A then
          case u of
            $AD, $300..$36F, $483..$489, $591..$5BD, $5BF, $5C1, $5C2, $5C4, $5C5, $5C7, $610..$61A, 
            $61C, $64B..$65F, $670: result := ujtTransparent;
            $622..$625, $627, $629, $62F..$632, $648, $671..$673, $675..$677, $688..$699: result := ujtRightJoining;
            $620, $626, $628, $62A..$62E, $633..$63F, $641..$647, $649, $64A, $66E, $66F, $678..$687, 
            $69A: result := ujtDualJoining;
            $640: result := ujtJoinCausing;
          end
        else
          case u of
            $6D6..$6DC, $6DF..$6E4, $6E7, $6E8, $6EA..$6ED, $70F, $711: result := ujtTransparent;
            $6C0, $6C3..$6CB, $6CD, $6CF, $6D2, $6D3, $6D5, $6EE, $6EF, $710, $715..$719, $71E, 
            $728, $72A, $72C: result := ujtRightJoining;
            $69B..$6BF, $6C1, $6C2, $6CC, $6CE, $6D0, $6D1, $6FA..$6FC, $6FF, $712..$714, $71A..$71D, 
            $71F..$727, $729, $72B: result := ujtDualJoining;
          end
      end else begin
        if u <= $00084A then
          case u of
            $730..$74A, $7A6..$7B0, $7EB..$7F3, $7FD, $816..$819, $81B..$823, $825..$827, $829..$82D: result := ujtTransparent;
            $72F, $74D, $759..$75B, $76B, $76C, $771, $773, $774, $778, $779, $840, $846, $847, 
            $849: result := ujtRightJoining;
            $72D, $72E, $74E..$758, $75C..$76A, $76D..$770, $772, $775..$777, $77A..$77F, $7CA..$7EA, 
            $841..$845, $848, $84A: result := ujtDualJoining;
            $7FA: result := ujtJoinCausing;
          end
        else
          case u of
            $859..$85B, $8D3..$8E1, $8E3..$902, $93A, $93C, $941..$948, $94D, $951..$957, $962, 
            $963, $981, $9BC, $9C1..$9C4, $9CD: result := ujtTransparent;
            $854, $856..$858, $867, $869, $86A, $8AA..$8AC, $8AE, $8B1, $8B2, $8B9: result := ujtRightJoining;
            $84B..$853, $855, $860, $862..$865, $868, $8A0..$8A9, $8AF, $8B0, $8B3, $8B4, $8B6..$8B8, 
            $8BA..$8C7: result := ujtDualJoining;
          end
      end
    end else begin
      if u <= $000F71 then begin
        if u <= $000C3E then
          case u of
            $9E2, $9E3, $9FE, $A01, $A02, $A3C, $A41, $A42, $A47, $A48, $A4B..$A4D, $A51, $A70, 
            $A71, $A75, $A81, $A82, $ABC, $AC1..$AC5, $AC7, $AC8, $ACD, $AE2, $AE3, $AFA..$AFF, 
            $B01, $B3C, $B3F, $B41..$B44, $B4D, $B55, $B56, $B62, $B63, $B82, $BC0, $BCD, $C00, 
            $C04, $C3E: result := ujtTransparent;
          end
        else
          case u of
            $C3F, $C40, $C46..$C48, $C4A..$C4D, $C55, $C56, $C62, $C63, $C81, $CBC, $CBF, $CC6, 
            $CCC, $CCD, $CE2, $CE3, $D00, $D01, $D3B, $D3C, $D41..$D44, $D4D, $D62, $D63, $D81, 
            $DCA, $DD2..$DD4, $DD6, $E31, $E34..$E3A, $E47..$E4E, $EB1, $EB4..$EBC, $EC8..$ECD, 
            $F18, $F19, $F35, $F37, $F39, $F71: result := ujtTransparent;
          end
      end else begin
        if u <= $001820 then
          case u of
            $F72..$F7E, $F80..$F84, $F86, $F87, $F8D..$F97, $F99..$FBC, $FC6, $102D..$1030, $1032..$1037, 
            $1039, $103A, $103D, $103E, $1058, $1059, $105E..$1060, $1071..$1074, $1082, $1085, 
            $1086, $108D, $109D, $135D..$135F, $1712..$1714, $1732..$1734, $1752, $1753, $1772, 
            $1773, $17B4, $17B5, $17B7..$17BD, $17C6, $17C9..$17D3, $17DD, $180B..$180D: result := ujtTransparent;
            $1807, $1820: result := ujtDualJoining;
            $180A: result := ujtJoinCausing;
          end
        else
          case u of
            $1885, $1886, $18A9, $1920..$1922, $1927, $1928, $1932, $1939..$193B, $1A17, $1A18, 
            $1A1B, $1A56, $1A58..$1A5E, $1A60, $1A62, $1A65..$1A6C, $1A73..$1A7C, $1A7F, $1AB0..$1AC0, 
            $1B00..$1B03, $1B34, $1B36..$1B3A, $1B3C, $1B42, $1B6B..$1B73, $1B80, $1B81, $1BA2..$1BA5, 
            $1BA8, $1BA9, $1BAB..$1BAD, $1BE6, $1BE8: result := ujtTransparent;
            $1821..$1878, $1887..$18A8, $18AA: result := ujtDualJoining;
          end
      end
    end
  end else begin
    if u <= $010FB8 then begin
      if u <= $00ABE8 then begin
        if u <= $00A806 then
          case u of
            $1BE9, $1BED, $1BEF..$1BF1, $1C2C..$1C33, $1C36, $1C37, $1CD0..$1CD2, $1CD4..$1CE0, 
            $1CE2..$1CE8, $1CED, $1CF4, $1CF8, $1CF9, $1DC0..$1DF9, $1DFB..$1DFF, $200B, $200E, 
            $200F, $202A..$202E, $2060..$2064, $206A..$206F, $20D0..$20F0, $2CEF..$2CF1, $2D7F, 
            $2DE0..$2DFF, $302A..$302D, $3099, $309A, $A66F..$A672, $A674..$A67D, $A69E, $A69F, 
            $A6F0, $A6F1, $A802, $A806: result := ujtTransparent;
            $200D: result := ujtJoinCausing;
          end
        else
          case u of
            $A80B, $A825, $A826, $A82C, $A8C4, $A8C5, $A8E0..$A8F1, $A8FF, $A926..$A92D, $A947..$A951, 
            $A980..$A982, $A9B3, $A9B6..$A9B9, $A9BC, $A9BD, $A9E5, $AA29..$AA2E, $AA31, $AA32, 
            $AA35, $AA36, $AA43, $AA4C, $AA7C, $AAB0, $AAB2..$AAB4, $AAB7, $AAB8, $AABE, $AABF, 
            $AAC1, $AAEC, $AAED, $AAF6, $ABE5, $ABE8: result := ujtTransparent;
            $A872: result := ujtLeftJoining;
            $A840..$A871: result := ujtDualJoining;
          end
      end else begin
        if u <= $010AEF then
          case u of
            $ABED, $FB1E, $FE00..$FE0F, $FE20..$FE2F, $FEFF, $FFF9..$FFFB, $101FD, $102E0, $10376..$1037A, 
            $10A01..$10A03, $10A05, $10A06, $10A0C..$10A0F, $10A38..$10A3A, $10A3F, $10AE5, $10AE6: result := ujtTransparent;
            $10AC5, $10AC7, $10AC9, $10ACA, $10ACE..$10AD2, $10ADD, $10AE1, $10AE4, $10AEF: result := ujtRightJoining;
            $10ACD, $10AD7: result := ujtLeftJoining;
            $10AC0..$10AC4, $10AD3..$10AD6, $10AD8..$10ADC, $10ADE..$10AE0, $10AEB..$10AEE: result := ujtDualJoining;
          end
        else
          case u of
            $10D24..$10D27, $10EAB, $10EAC, $10F46..$10F50: result := ujtTransparent;
            $10B81, $10B83..$10B85, $10B89, $10B8C, $10B8E, $10B8F, $10B91, $10BA9..$10BAC, $10D22, 
            $10F33, $10F54, $10FB4..$10FB6: result := ujtRightJoining;
            $10D00: result := ujtLeftJoining;
            $10B80, $10B82, $10B86..$10B88, $10B8A, $10B8B, $10B8D, $10B90, $10BAD, $10BAE, $10D01..$10D21, 
            $10D23, $10F30..$10F32, $10F34..$10F44, $10F51..$10F53, $10FB0, $10FB2, $10FB3, $10FB8: result := ujtDualJoining;
          end
      end
    end else begin
      if u <= $01193E then begin
        if u <= $011300 then
          case u of
            $11001, $11038..$11046, $1107F..$11081, $110B3..$110B6, $110B9, $110BA, $11100..$11102, 
            $11127..$1112B, $1112D..$11134, $11173, $11180, $11181, $111B6..$111BE, $111C9..$111CC, 
            $111CF, $1122F..$11231, $11234, $11236, $11237, $1123E, $112DF, $112E3..$112EA, $11300: result := ujtTransparent;
            $10FB9, $10FBA, $10FBD, $10FC2, $10FC3, $10FC9: result := ujtRightJoining;
            $10FCB: result := ujtLeftJoining;
            $10FBB, $10FBC, $10FBE, $10FBF, $10FC1, $10FC4, $10FCA: result := ujtDualJoining;
          end
        else
          case u of
            $11301, $1133B, $1133C, $11340, $11366..$1136C, $11370..$11374, $11438..$1143F, $11442..$11444, 
            $11446, $1145E, $114B3..$114B8, $114BA, $114BF, $114C0, $114C2, $114C3, $115B2..$115B5, 
            $115BC, $115BD, $115BF, $115C0, $115DC, $115DD, $11633..$1163A, $1163D, $1163F, $11640, 
            $116AB, $116AD, $116B0..$116B5, $116B7, $1171D..$1171F, $11722..$11725, $11727..$1172B, 
            $1182F..$11837, $11839, $1183A, $1193B, $1193C, $1193E: result := ujtTransparent;
          end
      end else begin
        if u <= $016AF0 then
          case u of
            $11943, $119D4..$119D7, $119DA, $119DB, $119E0, $11A01..$11A0A, $11A33..$11A38, $11A3B..$11A3E, 
            $11A47, $11A51..$11A56, $11A59..$11A5B, $11A8A..$11A96, $11A98, $11A99, $11C30..$11C36, 
            $11C38..$11C3D, $11C3F, $11C92..$11CA7, $11CAA..$11CB0, $11CB2, $11CB3, $11CB5, $11CB6, 
            $11D31..$11D36, $11D3A, $11D3C, $11D3D, $11D3F..$11D45, $11D47, $11D90, $11D91, $11D95, 
            $11D97, $11EF3, $11EF4, $13430..$13438, $16AF0: result := ujtTransparent;
          end
        else
          case u of
            $16AF1..$16AF4, $16B30..$16B36, $16F4F, $16F8F..$16F92, $16FE4, $1BC9D, $1BC9E, $1BCA0..$1BCA3, 
            $1D167..$1D169, $1D173..$1D182, $1D185..$1D18B, $1D1AA..$1D1AD, $1D242..$1D244, $1DA00..$1DA36, 
            $1DA3B..$1DA6C, $1DA75, $1DA84, $1DA9B..$1DA9F, $1DAA1..$1DAAF, $1E000..$1E006, $1E008..$1E018, 
            $1E01B..$1E021, $1E023, $1E024, $1E026..$1E02A, $1E130..$1E136, $1E2EC..$1E2EF, $1E8D0..$1E8D6, 
            $1E944..$1E94B, $E0001, $E0020..$E007F, $E0100..$E01EF: result := ujtTransparent;
            $1E900..$1E943: result := ujtDualJoining;
          end
      end
    end
  end
end;

type
  TUnicodeCombiningInfo = record
    u: LongWord;
    c: Byte;
  end;
const
  UnicodeCombiningInfos: array[0..2289] of TUnicodeCombiningInfo =
  ( (u:$300; c:230), (u:$301; c:230), (u:$302; c:230), (u:$303; c:230),
    (u:$304; c:230), (u:$305; c:230), (u:$306; c:230), (u:$307; c:230),
    (u:$308; c:230), (u:$309; c:230), (u:$30A; c:230), (u:$30B; c:230),
    (u:$30C; c:230), (u:$30D; c:230), (u:$30E; c:230), (u:$30F; c:230),
    (u:$310; c:230), (u:$311; c:230), (u:$312; c:230), (u:$313; c:230),
    (u:$314; c:230), (u:$315; c:232), (u:$316; c:220), (u:$317; c:220),
    (u:$318; c:220), (u:$319; c:220), (u:$31A; c:232), (u:$31B; c:216),
    (u:$31C; c:220), (u:$31D; c:220), (u:$31E; c:220), (u:$31F; c:220),
    (u:$320; c:220), (u:$321; c:202), (u:$322; c:202), (u:$323; c:220),
    (u:$324; c:220), (u:$325; c:220), (u:$326; c:220), (u:$327; c:202),
    (u:$328; c:202), (u:$329; c:220), (u:$32A; c:220), (u:$32B; c:220),
    (u:$32C; c:220), (u:$32D; c:220), (u:$32E; c:220), (u:$32F; c:220),
    (u:$330; c:220), (u:$331; c:220), (u:$332; c:220), (u:$333; c:220),
    (u:$334; c:1), (u:$335; c:1), (u:$336; c:1), (u:$337; c:1), (u:$338; c:1),
    (u:$339; c:220), (u:$33A; c:220), (u:$33B; c:220), (u:$33C; c:220),
    (u:$33D; c:230), (u:$33E; c:230), (u:$33F; c:230), (u:$340; c:230),
    (u:$341; c:230), (u:$342; c:230), (u:$343; c:230), (u:$344; c:230),
    (u:$345; c:240), (u:$346; c:230), (u:$347; c:220), (u:$348; c:220),
    (u:$349; c:220), (u:$34A; c:230), (u:$34B; c:230), (u:$34C; c:230),
    (u:$34D; c:220), (u:$34E; c:220), (u:$34F; c:0), (u:$350; c:230),
    (u:$351; c:230), (u:$352; c:230), (u:$353; c:220), (u:$354; c:220),
    (u:$355; c:220), (u:$356; c:220), (u:$357; c:230), (u:$358; c:232),
    (u:$359; c:220), (u:$35A; c:220), (u:$35B; c:230), (u:$35C; c:233),
    (u:$35D; c:234), (u:$35E; c:234), (u:$35F; c:233), (u:$360; c:234),
    (u:$361; c:234), (u:$362; c:233), (u:$363; c:230), (u:$364; c:230),
    (u:$365; c:230), (u:$366; c:230), (u:$367; c:230), (u:$368; c:230),
    (u:$369; c:230), (u:$36A; c:230), (u:$36B; c:230), (u:$36C; c:230),
    (u:$36D; c:230), (u:$36E; c:230), (u:$36F; c:230), (u:$483; c:230),
    (u:$484; c:230), (u:$485; c:230), (u:$486; c:230), (u:$487; c:230),
    (u:$488; c:0), (u:$489; c:0), (u:$591; c:220), (u:$592; c:230),
    (u:$593; c:230), (u:$594; c:230), (u:$595; c:230), (u:$596; c:220),
    (u:$597; c:230), (u:$598; c:230), (u:$599; c:230), (u:$59A; c:222),
    (u:$59B; c:220), (u:$59C; c:230), (u:$59D; c:230), (u:$59E; c:230),
    (u:$59F; c:230), (u:$5A0; c:230), (u:$5A1; c:230), (u:$5A2; c:220),
    (u:$5A3; c:220), (u:$5A4; c:220), (u:$5A5; c:220), (u:$5A6; c:220),
    (u:$5A7; c:220), (u:$5A8; c:230), (u:$5A9; c:230), (u:$5AA; c:220),
    (u:$5AB; c:230), (u:$5AC; c:230), (u:$5AD; c:222), (u:$5AE; c:228),
    (u:$5AF; c:230), (u:$5B0; c:10), (u:$5B1; c:11), (u:$5B2; c:12),
    (u:$5B3; c:13), (u:$5B4; c:14), (u:$5B5; c:15), (u:$5B6; c:16),
    (u:$5B7; c:17), (u:$5B8; c:18), (u:$5B9; c:19), (u:$5BA; c:19),
    (u:$5BB; c:20), (u:$5BC; c:21), (u:$5BD; c:22), (u:$5BF; c:23),
    (u:$5C1; c:24), (u:$5C2; c:25), (u:$5C4; c:230), (u:$5C5; c:220),
    (u:$5C7; c:18), (u:$610; c:230), (u:$611; c:230), (u:$612; c:230),
    (u:$613; c:230), (u:$614; c:230), (u:$615; c:230), (u:$616; c:230),
    (u:$617; c:230), (u:$618; c:30), (u:$619; c:31), (u:$61A; c:32),
    (u:$64B; c:27), (u:$64C; c:28), (u:$64D; c:29), (u:$64E; c:30),
    (u:$64F; c:31), (u:$650; c:32), (u:$651; c:33), (u:$652; c:34),
    (u:$653; c:230), (u:$654; c:230), (u:$655; c:220), (u:$656; c:220),
    (u:$657; c:230), (u:$658; c:230), (u:$659; c:230), (u:$65A; c:230),
    (u:$65B; c:230), (u:$65C; c:220), (u:$65D; c:230), (u:$65E; c:230),
    (u:$65F; c:220), (u:$670; c:35), (u:$6D6; c:230), (u:$6D7; c:230),
    (u:$6D8; c:230), (u:$6D9; c:230), (u:$6DA; c:230), (u:$6DB; c:230),
    (u:$6DC; c:230), (u:$6DF; c:230), (u:$6E0; c:230), (u:$6E1; c:230),
    (u:$6E2; c:230), (u:$6E3; c:220), (u:$6E4; c:230), (u:$6E7; c:230),
    (u:$6E8; c:230), (u:$6EA; c:220), (u:$6EB; c:230), (u:$6EC; c:230),
    (u:$6ED; c:220), (u:$711; c:36), (u:$730; c:230), (u:$731; c:220),
    (u:$732; c:230), (u:$733; c:230), (u:$734; c:220), (u:$735; c:230),
    (u:$736; c:230), (u:$737; c:220), (u:$738; c:220), (u:$739; c:220),
    (u:$73A; c:230), (u:$73B; c:220), (u:$73C; c:220), (u:$73D; c:230),
    (u:$73E; c:220), (u:$73F; c:230), (u:$740; c:230), (u:$741; c:230),
    (u:$742; c:220), (u:$743; c:230), (u:$744; c:220), (u:$745; c:230),
    (u:$746; c:220), (u:$747; c:230), (u:$748; c:220), (u:$749; c:230),
    (u:$74A; c:230), (u:$7A6; c:0), (u:$7A7; c:0), (u:$7A8; c:0), (u:$7A9; c:0),
    (u:$7AA; c:0), (u:$7AB; c:0), (u:$7AC; c:0), (u:$7AD; c:0), (u:$7AE; c:0),
    (u:$7AF; c:0), (u:$7B0; c:0), (u:$7EB; c:230), (u:$7EC; c:230),
    (u:$7ED; c:230), (u:$7EE; c:230), (u:$7EF; c:230), (u:$7F0; c:230),
    (u:$7F1; c:230), (u:$7F2; c:220), (u:$7F3; c:230), (u:$7FD; c:220),
    (u:$816; c:230), (u:$817; c:230), (u:$818; c:230), (u:$819; c:230),
    (u:$81B; c:230), (u:$81C; c:230), (u:$81D; c:230), (u:$81E; c:230),
    (u:$81F; c:230), (u:$820; c:230), (u:$821; c:230), (u:$822; c:230),
    (u:$823; c:230), (u:$825; c:230), (u:$826; c:230), (u:$827; c:230),
    (u:$829; c:230), (u:$82A; c:230), (u:$82B; c:230), (u:$82C; c:230),
    (u:$82D; c:230), (u:$859; c:220), (u:$85A; c:220), (u:$85B; c:220),
    (u:$8D3; c:220), (u:$8D4; c:230), (u:$8D5; c:230), (u:$8D6; c:230),
    (u:$8D7; c:230), (u:$8D8; c:230), (u:$8D9; c:230), (u:$8DA; c:230),
    (u:$8DB; c:230), (u:$8DC; c:230), (u:$8DD; c:230), (u:$8DE; c:230),
    (u:$8DF; c:230), (u:$8E0; c:230), (u:$8E1; c:230), (u:$8E3; c:220),
    (u:$8E4; c:230), (u:$8E5; c:230), (u:$8E6; c:220), (u:$8E7; c:230),
    (u:$8E8; c:230), (u:$8E9; c:220), (u:$8EA; c:230), (u:$8EB; c:230),
    (u:$8EC; c:230), (u:$8ED; c:220), (u:$8EE; c:220), (u:$8EF; c:220),
    (u:$8F0; c:27), (u:$8F1; c:28), (u:$8F2; c:29), (u:$8F3; c:230),
    (u:$8F4; c:230), (u:$8F5; c:230), (u:$8F6; c:220), (u:$8F7; c:230),
    (u:$8F8; c:230), (u:$8F9; c:220), (u:$8FA; c:220), (u:$8FB; c:230),
    (u:$8FC; c:230), (u:$8FD; c:230), (u:$8FE; c:230), (u:$8FF; c:230),
    (u:$900; c:0), (u:$901; c:0), (u:$902; c:0), (u:$903; c:210), (u:$93A; c:0),
    (u:$93B; c:210), (u:$93C; c:7), (u:$93E; c:210), (u:$93F; c:208),
    (u:$940; c:210), (u:$941; c:0), (u:$942; c:0), (u:$943; c:0), (u:$944; c:0),
    (u:$945; c:0), (u:$946; c:0), (u:$947; c:0), (u:$948; c:0), (u:$949; c:210),
    (u:$94A; c:210), (u:$94B; c:210), (u:$94C; c:210), (u:$94D; c:9),
    (u:$94E; c:208), (u:$94F; c:210), (u:$951; c:230), (u:$952; c:220),
    (u:$953; c:230), (u:$954; c:230), (u:$955; c:0), (u:$956; c:0),
    (u:$957; c:0), (u:$962; c:0), (u:$963; c:0), (u:$981; c:0), (u:$982; c:210),
    (u:$983; c:210), (u:$9BC; c:7), (u:$9BE; c:210), (u:$9BF; c:208),
    (u:$9C0; c:210), (u:$9C1; c:0), (u:$9C2; c:0), (u:$9C3; c:0), (u:$9C4; c:0),
    (u:$9C7; c:208), (u:$9C8; c:208), (u:$9CB; c:0), (u:$9CC; c:0),
    (u:$9CD; c:9), (u:$9D7; c:210), (u:$9E2; c:0), (u:$9E3; c:0),
    (u:$9FE; c:230), (u:$A01; c:0), (u:$A02; c:0), (u:$A03; c:210),
    (u:$A3C; c:7), (u:$A3E; c:210), (u:$A3F; c:208), (u:$A40; c:210),
    (u:$A41; c:0), (u:$A42; c:0), (u:$A47; c:0), (u:$A48; c:0), (u:$A4B; c:0),
    (u:$A4C; c:0), (u:$A4D; c:9), (u:$A51; c:0), (u:$A70; c:0), (u:$A71; c:0),
    (u:$A75; c:0), (u:$A81; c:0), (u:$A82; c:0), (u:$A83; c:210), (u:$ABC; c:7),
    (u:$ABE; c:210), (u:$ABF; c:208), (u:$AC0; c:210), (u:$AC1; c:0),
    (u:$AC2; c:0), (u:$AC3; c:0), (u:$AC4; c:0), (u:$AC5; c:0), (u:$AC7; c:0),
    (u:$AC8; c:0), (u:$AC9; c:210), (u:$ACB; c:210), (u:$ACC; c:210),
    (u:$ACD; c:9), (u:$AE2; c:0), (u:$AE3; c:0), (u:$AFA; c:0), (u:$AFB; c:0),
    (u:$AFC; c:0), (u:$AFD; c:0), (u:$AFE; c:0), (u:$AFF; c:0), (u:$B01; c:0),
    (u:$B02; c:210), (u:$B03; c:210), (u:$B3C; c:7), (u:$B3E; c:210),
    (u:$B3F; c:0), (u:$B40; c:210), (u:$B41; c:0), (u:$B42; c:0), (u:$B43; c:0),
    (u:$B44; c:0), (u:$B47; c:208), (u:$B48; c:208), (u:$B4B; c:208),
    (u:$B4C; c:208), (u:$B4D; c:9), (u:$B55; c:0), (u:$B56; c:0),
    (u:$B57; c:210), (u:$B62; c:0), (u:$B63; c:0), (u:$B82; c:0),
    (u:$BBE; c:210), (u:$BBF; c:210), (u:$BC0; c:0), (u:$BC1; c:210),
    (u:$BC2; c:210), (u:$BC6; c:208), (u:$BC7; c:208), (u:$BC8; c:208),
    (u:$BCA; c:0), (u:$BCB; c:0), (u:$BCC; c:0), (u:$BCD; c:9), (u:$BD7; c:210),
    (u:$C00; c:0), (u:$C01; c:210), (u:$C02; c:210), (u:$C03; c:210),
    (u:$C04; c:0), (u:$C3E; c:0), (u:$C3F; c:0), (u:$C40; c:0), (u:$C41; c:210),
    (u:$C42; c:210), (u:$C43; c:210), (u:$C44; c:210), (u:$C46; c:0),
    (u:$C47; c:0), (u:$C48; c:0), (u:$C4A; c:0), (u:$C4B; c:0), (u:$C4C; c:0),
    (u:$C4D; c:9), (u:$C55; c:84), (u:$C56; c:91), (u:$C62; c:0), (u:$C63; c:0),
    (u:$C81; c:0), (u:$C82; c:210), (u:$C83; c:210), (u:$CBC; c:7),
    (u:$CBE; c:210), (u:$CC0; c:210), (u:$CC1; c:210), (u:$CC2; c:210),
    (u:$CC3; c:210), (u:$CC4; c:210), (u:$CC7; c:210), (u:$CC8; c:210),
    (u:$CCA; c:210), (u:$CCB; c:210), (u:$CCC; c:0), (u:$CCD; c:9),
    (u:$CD5; c:210), (u:$CD6; c:210), (u:$CE2; c:0), (u:$CE3; c:0),
    (u:$D00; c:0), (u:$D01; c:0), (u:$D02; c:210), (u:$D03; c:210),
    (u:$D3B; c:9), (u:$D3C; c:9), (u:$D3E; c:210), (u:$D3F; c:210),
    (u:$D40; c:210), (u:$D41; c:0), (u:$D42; c:0), (u:$D43; c:0), (u:$D44; c:0),
    (u:$D46; c:208), (u:$D47; c:208), (u:$D48; c:208), (u:$D4A; c:0),
    (u:$D4B; c:0), (u:$D4C; c:0), (u:$D4D; c:9), (u:$D57; c:210), (u:$D62; c:0),
    (u:$D63; c:0), (u:$D81; c:0), (u:$D82; c:210), (u:$D83; c:210),
    (u:$DCA; c:9), (u:$DCF; c:210), (u:$DD0; c:210), (u:$DD1; c:210),
    (u:$DD2; c:0), (u:$DD3; c:0), (u:$DD4; c:0), (u:$DD6; c:0), (u:$DD8; c:210),
    (u:$DD9; c:208), (u:$DDA; c:208), (u:$DDB; c:208), (u:$DDC; c:208),
    (u:$DDD; c:208), (u:$DDE; c:208), (u:$DDF; c:210), (u:$DF2; c:210),
    (u:$DF3; c:210), (u:$E31; c:0), (u:$E34; c:0), (u:$E35; c:0), (u:$E36; c:0),
    (u:$E37; c:0), (u:$E38; c:103), (u:$E39; c:103), (u:$E3A; c:9),
    (u:$E47; c:0), (u:$E48; c:107), (u:$E49; c:107), (u:$E4A; c:107),
    (u:$E4B; c:107), (u:$E4C; c:0), (u:$E4D; c:0), (u:$E4E; c:0), (u:$EB1; c:0),
    (u:$EB4; c:0), (u:$EB5; c:0), (u:$EB6; c:0), (u:$EB7; c:0), (u:$EB8; c:118),
    (u:$EB9; c:118), (u:$EBA; c:9), (u:$EBB; c:0), (u:$EBC; c:0),
    (u:$EC8; c:122), (u:$EC9; c:122), (u:$ECA; c:122), (u:$ECB; c:122),
    (u:$ECC; c:0), (u:$ECD; c:0), (u:$F18; c:220), (u:$F19; c:220),
    (u:$F35; c:220), (u:$F37; c:220), (u:$F39; c:216), (u:$F3E; c:210),
    (u:$F3F; c:210), (u:$F71; c:129), (u:$F72; c:130), (u:$F73; c:0),
    (u:$F74; c:132), (u:$F75; c:0), (u:$F76; c:0), (u:$F77; c:0), (u:$F78; c:0),
    (u:$F79; c:0), (u:$F7A; c:130), (u:$F7B; c:130), (u:$F7C; c:130),
    (u:$F7D; c:130), (u:$F7E; c:0), (u:$F7F; c:210), (u:$F80; c:130),
    (u:$F81; c:0), (u:$F82; c:230), (u:$F83; c:230), (u:$F84; c:9),
    (u:$F86; c:230), (u:$F87; c:230), (u:$F8D; c:0), (u:$F8E; c:0),
    (u:$F8F; c:0), (u:$F90; c:0), (u:$F91; c:0), (u:$F92; c:0), (u:$F93; c:0),
    (u:$F94; c:0), (u:$F95; c:0), (u:$F96; c:0), (u:$F97; c:0), (u:$F99; c:0),
    (u:$F9A; c:0), (u:$F9B; c:0), (u:$F9C; c:0), (u:$F9D; c:0), (u:$F9E; c:0),
    (u:$F9F; c:0), (u:$FA0; c:0), (u:$FA1; c:0), (u:$FA2; c:0), (u:$FA3; c:0),
    (u:$FA4; c:0), (u:$FA5; c:0), (u:$FA6; c:0), (u:$FA7; c:0), (u:$FA8; c:0),
    (u:$FA9; c:0), (u:$FAA; c:0), (u:$FAB; c:0), (u:$FAC; c:0), (u:$FAD; c:0),
    (u:$FAE; c:0), (u:$FAF; c:0), (u:$FB0; c:0), (u:$FB1; c:0), (u:$FB2; c:0),
    (u:$FB3; c:0), (u:$FB4; c:0), (u:$FB5; c:0), (u:$FB6; c:0), (u:$FB7; c:0),
    (u:$FB8; c:0), (u:$FB9; c:0), (u:$FBA; c:0), (u:$FBB; c:0), (u:$FBC; c:0),
    (u:$FC6; c:220), (u:$102B; c:210), (u:$102C; c:210), (u:$102D; c:0),
    (u:$102E; c:0), (u:$102F; c:0), (u:$1030; c:0), (u:$1031; c:208),
    (u:$1032; c:0), (u:$1033; c:0), (u:$1034; c:0), (u:$1035; c:0),
    (u:$1036; c:0), (u:$1037; c:7), (u:$1038; c:210), (u:$1039; c:9),
    (u:$103A; c:9), (u:$103B; c:210), (u:$103C; c:208), (u:$103D; c:0),
    (u:$103E; c:0), (u:$1056; c:210), (u:$1057; c:210), (u:$1058; c:0),
    (u:$1059; c:0), (u:$105E; c:0), (u:$105F; c:0), (u:$1060; c:0),
    (u:$1062; c:210), (u:$1063; c:210), (u:$1064; c:210), (u:$1067; c:210),
    (u:$1068; c:210), (u:$1069; c:210), (u:$106A; c:210), (u:$106B; c:210),
    (u:$106C; c:210), (u:$106D; c:210), (u:$1071; c:0), (u:$1072; c:0),
    (u:$1073; c:0), (u:$1074; c:0), (u:$1082; c:0), (u:$1083; c:210),
    (u:$1084; c:208), (u:$1085; c:0), (u:$1086; c:0), (u:$1087; c:210),
    (u:$1088; c:210), (u:$1089; c:210), (u:$108A; c:210), (u:$108B; c:210),
    (u:$108C; c:210), (u:$108D; c:220), (u:$108F; c:210), (u:$109A; c:210),
    (u:$109B; c:210), (u:$109C; c:210), (u:$109D; c:0), (u:$135D; c:230),
    (u:$135E; c:230), (u:$135F; c:230), (u:$1712; c:0), (u:$1713; c:0),
    (u:$1714; c:9), (u:$1732; c:0), (u:$1733; c:0), (u:$1734; c:9),
    (u:$1752; c:0), (u:$1753; c:0), (u:$1772; c:0), (u:$1773; c:0),
    (u:$17B4; c:0), (u:$17B5; c:0), (u:$17B6; c:210), (u:$17B7; c:0),
    (u:$17B8; c:0), (u:$17B9; c:0), (u:$17BA; c:0), (u:$17BB; c:0),
    (u:$17BC; c:0), (u:$17BD; c:0), (u:$17BE; c:208), (u:$17BF; c:0),
    (u:$17C0; c:0), (u:$17C1; c:208), (u:$17C2; c:208), (u:$17C3; c:208),
    (u:$17C4; c:0), (u:$17C5; c:0), (u:$17C6; c:0), (u:$17C7; c:210),
    (u:$17C8; c:210), (u:$17C9; c:0), (u:$17CA; c:0), (u:$17CB; c:0),
    (u:$17CC; c:0), (u:$17CD; c:0), (u:$17CE; c:0), (u:$17CF; c:0),
    (u:$17D0; c:0), (u:$17D1; c:0), (u:$17D2; c:9), (u:$17D3; c:0),
    (u:$17DD; c:230), (u:$180B; c:0), (u:$180C; c:0), (u:$180D; c:0),
    (u:$1885; c:0), (u:$1886; c:0), (u:$18A9; c:228), (u:$1920; c:0),
    (u:$1921; c:0), (u:$1922; c:0), (u:$1923; c:210), (u:$1924; c:210),
    (u:$1925; c:210), (u:$1926; c:210), (u:$1927; c:0), (u:$1928; c:0),
    (u:$1929; c:210), (u:$192A; c:210), (u:$192B; c:210), (u:$1930; c:210),
    (u:$1931; c:210), (u:$1932; c:0), (u:$1933; c:210), (u:$1934; c:210),
    (u:$1935; c:210), (u:$1936; c:210), (u:$1937; c:210), (u:$1938; c:210),
    (u:$1939; c:222), (u:$193A; c:230), (u:$193B; c:220), (u:$1A17; c:230),
    (u:$1A18; c:220), (u:$1A19; c:208), (u:$1A1A; c:210), (u:$1A1B; c:0),
    (u:$1A55; c:210), (u:$1A56; c:0), (u:$1A57; c:210), (u:$1A58; c:0),
    (u:$1A59; c:0), (u:$1A5A; c:0), (u:$1A5B; c:0), (u:$1A5C; c:0),
    (u:$1A5D; c:0), (u:$1A5E; c:0), (u:$1A60; c:9), (u:$1A61; c:210),
    (u:$1A62; c:0), (u:$1A63; c:210), (u:$1A64; c:210), (u:$1A65; c:0),
    (u:$1A66; c:0), (u:$1A67; c:0), (u:$1A68; c:0), (u:$1A69; c:0),
    (u:$1A6A; c:0), (u:$1A6B; c:0), (u:$1A6C; c:0), (u:$1A6D; c:210),
    (u:$1A6E; c:210), (u:$1A6F; c:210), (u:$1A70; c:210), (u:$1A71; c:210),
    (u:$1A72; c:210), (u:$1A73; c:0), (u:$1A74; c:0), (u:$1A75; c:230),
    (u:$1A76; c:230), (u:$1A77; c:230), (u:$1A78; c:230), (u:$1A79; c:230),
    (u:$1A7A; c:230), (u:$1A7B; c:230), (u:$1A7C; c:230), (u:$1A7F; c:220),
    (u:$1AB0; c:230), (u:$1AB1; c:230), (u:$1AB2; c:230), (u:$1AB3; c:230),
    (u:$1AB4; c:230), (u:$1AB5; c:220), (u:$1AB6; c:220), (u:$1AB7; c:220),
    (u:$1AB8; c:220), (u:$1AB9; c:220), (u:$1ABA; c:220), (u:$1ABB; c:230),
    (u:$1ABC; c:230), (u:$1ABD; c:220), (u:$1ABE; c:0), (u:$1ABF; c:220),
    (u:$1AC0; c:220), (u:$1B00; c:0), (u:$1B01; c:0), (u:$1B02; c:0),
    (u:$1B03; c:0), (u:$1B04; c:210), (u:$1B34; c:7), (u:$1B35; c:210),
    (u:$1B36; c:0), (u:$1B37; c:0), (u:$1B38; c:0), (u:$1B39; c:0),
    (u:$1B3A; c:0), (u:$1B3B; c:210), (u:$1B3C; c:0), (u:$1B3D; c:0),
    (u:$1B3E; c:208), (u:$1B3F; c:208), (u:$1B40; c:0), (u:$1B41; c:0),
    (u:$1B42; c:0), (u:$1B43; c:210), (u:$1B44; c:9), (u:$1B6B; c:230),
    (u:$1B6C; c:220), (u:$1B6D; c:230), (u:$1B6E; c:230), (u:$1B6F; c:230),
    (u:$1B70; c:230), (u:$1B71; c:230), (u:$1B72; c:230), (u:$1B73; c:230),
    (u:$1B80; c:0), (u:$1B81; c:0), (u:$1B82; c:210), (u:$1BA1; c:210),
    (u:$1BA2; c:0), (u:$1BA3; c:0), (u:$1BA4; c:0), (u:$1BA5; c:0),
    (u:$1BA6; c:210), (u:$1BA7; c:210), (u:$1BA8; c:0), (u:$1BA9; c:0),
    (u:$1BAA; c:9), (u:$1BAB; c:9), (u:$1BAC; c:0), (u:$1BAD; c:0),
    (u:$1BE6; c:7), (u:$1BE7; c:210), (u:$1BE8; c:0), (u:$1BE9; c:0),
    (u:$1BEA; c:210), (u:$1BEB; c:210), (u:$1BEC; c:210), (u:$1BED; c:0),
    (u:$1BEE; c:210), (u:$1BEF; c:0), (u:$1BF0; c:0), (u:$1BF1; c:0),
    (u:$1BF2; c:9), (u:$1BF3; c:9), (u:$1C24; c:210), (u:$1C25; c:210),
    (u:$1C26; c:210), (u:$1C27; c:210), (u:$1C28; c:210), (u:$1C29; c:210),
    (u:$1C2A; c:210), (u:$1C2B; c:210), (u:$1C2C; c:0), (u:$1C2D; c:0),
    (u:$1C2E; c:0), (u:$1C2F; c:0), (u:$1C30; c:0), (u:$1C31; c:0),
    (u:$1C32; c:0), (u:$1C33; c:0), (u:$1C34; c:210), (u:$1C35; c:210),
    (u:$1C36; c:0), (u:$1C37; c:7), (u:$1CD0; c:230), (u:$1CD1; c:230),
    (u:$1CD2; c:230), (u:$1CD4; c:1), (u:$1CD5; c:220), (u:$1CD6; c:220),
    (u:$1CD7; c:220), (u:$1CD8; c:220), (u:$1CD9; c:220), (u:$1CDA; c:230),
    (u:$1CDB; c:230), (u:$1CDC; c:220), (u:$1CDD; c:220), (u:$1CDE; c:220),
    (u:$1CDF; c:220), (u:$1CE0; c:230), (u:$1CE1; c:210), (u:$1CE2; c:1),
    (u:$1CE3; c:1), (u:$1CE4; c:1), (u:$1CE5; c:1), (u:$1CE6; c:1),
    (u:$1CE7; c:1), (u:$1CE8; c:1), (u:$1CED; c:220), (u:$1CF4; c:230),
    (u:$1CF7; c:210), (u:$1CF8; c:230), (u:$1CF9; c:230), (u:$1DC0; c:230),
    (u:$1DC1; c:230), (u:$1DC2; c:220), (u:$1DC3; c:230), (u:$1DC4; c:230),
    (u:$1DC5; c:230), (u:$1DC6; c:230), (u:$1DC7; c:230), (u:$1DC8; c:230),
    (u:$1DC9; c:230), (u:$1DCA; c:220), (u:$1DCB; c:230), (u:$1DCC; c:230),
    (u:$1DCD; c:234), (u:$1DCE; c:214), (u:$1DCF; c:220), (u:$1DD0; c:202),
    (u:$1DD1; c:230), (u:$1DD2; c:230), (u:$1DD3; c:230), (u:$1DD4; c:230),
    (u:$1DD5; c:230), (u:$1DD6; c:230), (u:$1DD7; c:230), (u:$1DD8; c:230),
    (u:$1DD9; c:230), (u:$1DDA; c:230), (u:$1DDB; c:230), (u:$1DDC; c:230),
    (u:$1DDD; c:230), (u:$1DDE; c:230), (u:$1DDF; c:230), (u:$1DE0; c:230),
    (u:$1DE1; c:230), (u:$1DE2; c:230), (u:$1DE3; c:230), (u:$1DE4; c:230),
    (u:$1DE5; c:230), (u:$1DE6; c:230), (u:$1DE7; c:230), (u:$1DE8; c:230),
    (u:$1DE9; c:230), (u:$1DEA; c:230), (u:$1DEB; c:230), (u:$1DEC; c:230),
    (u:$1DED; c:230), (u:$1DEE; c:230), (u:$1DEF; c:230), (u:$1DF0; c:230),
    (u:$1DF1; c:230), (u:$1DF2; c:230), (u:$1DF3; c:230), (u:$1DF4; c:230),
    (u:$1DF5; c:230), (u:$1DF6; c:232), (u:$1DF7; c:228), (u:$1DF8; c:228),
    (u:$1DF9; c:220), (u:$1DFB; c:230), (u:$1DFC; c:233), (u:$1DFD; c:220),
    (u:$1DFE; c:230), (u:$1DFF; c:220), (u:$20D0; c:230), (u:$20D1; c:230),
    (u:$20D2; c:1), (u:$20D3; c:1), (u:$20D4; c:230), (u:$20D5; c:230),
    (u:$20D6; c:230), (u:$20D7; c:230), (u:$20D8; c:1), (u:$20D9; c:1),
    (u:$20DA; c:1), (u:$20DB; c:230), (u:$20DC; c:230), (u:$20DD; c:0),
    (u:$20DE; c:0), (u:$20DF; c:0), (u:$20E0; c:0), (u:$20E1; c:230),
    (u:$20E2; c:0), (u:$20E3; c:0), (u:$20E4; c:0), (u:$20E5; c:1),
    (u:$20E6; c:1), (u:$20E7; c:230), (u:$20E8; c:220), (u:$20E9; c:230),
    (u:$20EA; c:1), (u:$20EB; c:1), (u:$20EC; c:220), (u:$20ED; c:220),
    (u:$20EE; c:220), (u:$20EF; c:220), (u:$20F0; c:230), (u:$2CEF; c:230),
    (u:$2CF0; c:230), (u:$2CF1; c:230), (u:$2D7F; c:9), (u:$2DE0; c:230),
    (u:$2DE1; c:230), (u:$2DE2; c:230), (u:$2DE3; c:230), (u:$2DE4; c:230),
    (u:$2DE5; c:230), (u:$2DE6; c:230), (u:$2DE7; c:230), (u:$2DE8; c:230),
    (u:$2DE9; c:230), (u:$2DEA; c:230), (u:$2DEB; c:230), (u:$2DEC; c:230),
    (u:$2DED; c:230), (u:$2DEE; c:230), (u:$2DEF; c:230), (u:$2DF0; c:230),
    (u:$2DF1; c:230), (u:$2DF2; c:230), (u:$2DF3; c:230), (u:$2DF4; c:230),
    (u:$2DF5; c:230), (u:$2DF6; c:230), (u:$2DF7; c:230), (u:$2DF8; c:230),
    (u:$2DF9; c:230), (u:$2DFA; c:230), (u:$2DFB; c:230), (u:$2DFC; c:230),
    (u:$2DFD; c:230), (u:$2DFE; c:230), (u:$2DFF; c:230), (u:$302A; c:218),
    (u:$302B; c:228), (u:$302C; c:232), (u:$302D; c:222), (u:$302E; c:224),
    (u:$302F; c:224), (u:$3099; c:8), (u:$309A; c:8), (u:$A66F; c:230),
    (u:$A670; c:0), (u:$A671; c:0), (u:$A672; c:0), (u:$A674; c:230),
    (u:$A675; c:230), (u:$A676; c:230), (u:$A677; c:230), (u:$A678; c:230),
    (u:$A679; c:230), (u:$A67A; c:230), (u:$A67B; c:230), (u:$A67C; c:230),
    (u:$A67D; c:230), (u:$A69E; c:230), (u:$A69F; c:230), (u:$A6F0; c:230),
    (u:$A6F1; c:230), (u:$A802; c:0), (u:$A806; c:9), (u:$A80B; c:0),
    (u:$A823; c:210), (u:$A824; c:210), (u:$A825; c:0), (u:$A826; c:0),
    (u:$A827; c:210), (u:$A82C; c:9), (u:$A880; c:210), (u:$A881; c:210),
    (u:$A8B4; c:210), (u:$A8B5; c:210), (u:$A8B6; c:210), (u:$A8B7; c:210),
    (u:$A8B8; c:210), (u:$A8B9; c:210), (u:$A8BA; c:210), (u:$A8BB; c:210),
    (u:$A8BC; c:210), (u:$A8BD; c:210), (u:$A8BE; c:210), (u:$A8BF; c:210),
    (u:$A8C0; c:210), (u:$A8C1; c:210), (u:$A8C2; c:210), (u:$A8C3; c:210),
    (u:$A8C4; c:9), (u:$A8C5; c:0), (u:$A8E0; c:230), (u:$A8E1; c:230),
    (u:$A8E2; c:230), (u:$A8E3; c:230), (u:$A8E4; c:230), (u:$A8E5; c:230),
    (u:$A8E6; c:230), (u:$A8E7; c:230), (u:$A8E8; c:230), (u:$A8E9; c:230),
    (u:$A8EA; c:230), (u:$A8EB; c:230), (u:$A8EC; c:230), (u:$A8ED; c:230),
    (u:$A8EE; c:230), (u:$A8EF; c:230), (u:$A8F0; c:230), (u:$A8F1; c:230),
    (u:$A8FF; c:0), (u:$A926; c:0), (u:$A927; c:0), (u:$A928; c:0),
    (u:$A929; c:0), (u:$A92A; c:0), (u:$A92B; c:220), (u:$A92C; c:220),
    (u:$A92D; c:220), (u:$A947; c:0), (u:$A948; c:0), (u:$A949; c:0),
    (u:$A94A; c:0), (u:$A94B; c:0), (u:$A94C; c:0), (u:$A94D; c:0),
    (u:$A94E; c:0), (u:$A94F; c:0), (u:$A950; c:0), (u:$A951; c:0),
    (u:$A952; c:210), (u:$A953; c:9), (u:$A980; c:0), (u:$A981; c:0),
    (u:$A982; c:0), (u:$A983; c:210), (u:$A9B3; c:7), (u:$A9B4; c:210),
    (u:$A9B5; c:210), (u:$A9B6; c:0), (u:$A9B7; c:0), (u:$A9B8; c:0),
    (u:$A9B9; c:0), (u:$A9BA; c:208), (u:$A9BB; c:208), (u:$A9BC; c:0),
    (u:$A9BD; c:0), (u:$A9BE; c:210), (u:$A9BF; c:208), (u:$A9C0; c:9),
    (u:$A9E5; c:0), (u:$AA29; c:0), (u:$AA2A; c:0), (u:$AA2B; c:0),
    (u:$AA2C; c:0), (u:$AA2D; c:0), (u:$AA2E; c:0), (u:$AA2F; c:208),
    (u:$AA30; c:208), (u:$AA31; c:0), (u:$AA32; c:0), (u:$AA33; c:210),
    (u:$AA34; c:208), (u:$AA35; c:0), (u:$AA36; c:0), (u:$AA43; c:0),
    (u:$AA4C; c:0), (u:$AA4D; c:210), (u:$AA7B; c:210), (u:$AA7C; c:0),
    (u:$AA7D; c:210), (u:$AAB0; c:230), (u:$AAB2; c:230), (u:$AAB3; c:230),
    (u:$AAB4; c:220), (u:$AAB7; c:230), (u:$AAB8; c:230), (u:$AABE; c:230),
    (u:$AABF; c:230), (u:$AAC1; c:230), (u:$AAEB; c:210), (u:$AAEC; c:0),
    (u:$AAED; c:0), (u:$AAEE; c:210), (u:$AAEF; c:210), (u:$AAF5; c:210),
    (u:$AAF6; c:9), (u:$ABE3; c:210), (u:$ABE4; c:210), (u:$ABE5; c:0),
    (u:$ABE6; c:210), (u:$ABE7; c:210), (u:$ABE8; c:0), (u:$ABE9; c:210),
    (u:$ABEA; c:210), (u:$ABEC; c:210), (u:$ABED; c:9), (u:$FB1E; c:26),
    (u:$FE00; c:0), (u:$FE01; c:0), (u:$FE02; c:0), (u:$FE03; c:0),
    (u:$FE04; c:0), (u:$FE05; c:0), (u:$FE06; c:0), (u:$FE07; c:0),
    (u:$FE08; c:0), (u:$FE09; c:0), (u:$FE0A; c:0), (u:$FE0B; c:0),
    (u:$FE0C; c:0), (u:$FE0D; c:0), (u:$FE0E; c:0), (u:$FE0F; c:0),
    (u:$FE20; c:230), (u:$FE21; c:230), (u:$FE22; c:230), (u:$FE23; c:230),
    (u:$FE24; c:230), (u:$FE25; c:230), (u:$FE26; c:230), (u:$FE27; c:220),
    (u:$FE28; c:220), (u:$FE29; c:220), (u:$FE2A; c:220), (u:$FE2B; c:220),
    (u:$FE2C; c:220), (u:$FE2D; c:220), (u:$FE2E; c:230), (u:$FE2F; c:230),
    (u:$101FD; c:220), (u:$102E0; c:220), (u:$10376; c:230), (u:$10377; c:230),
    (u:$10378; c:230), (u:$10379; c:230), (u:$1037A; c:230), (u:$10A01; c:0),
    (u:$10A02; c:0), (u:$10A03; c:0), (u:$10A05; c:0), (u:$10A06; c:0),
    (u:$10A0C; c:0), (u:$10A0D; c:220), (u:$10A0E; c:0), (u:$10A0F; c:230),
    (u:$10A38; c:230), (u:$10A39; c:1), (u:$10A3A; c:220), (u:$10A3F; c:9),
    (u:$10AE5; c:230), (u:$10AE6; c:220), (u:$10D24; c:230), (u:$10D25; c:230),
    (u:$10D26; c:230), (u:$10D27; c:230), (u:$10EAB; c:230), (u:$10EAC; c:230),
    (u:$10F46; c:220), (u:$10F47; c:220), (u:$10F48; c:230), (u:$10F49; c:230),
    (u:$10F4A; c:230), (u:$10F4B; c:220), (u:$10F4C; c:230), (u:$10F4D; c:220),
    (u:$10F4E; c:220), (u:$10F4F; c:220), (u:$10F50; c:220), (u:$11000; c:210),
    (u:$11001; c:0), (u:$11002; c:210), (u:$11038; c:0), (u:$11039; c:0),
    (u:$1103A; c:0), (u:$1103B; c:0), (u:$1103C; c:0), (u:$1103D; c:0),
    (u:$1103E; c:0), (u:$1103F; c:0), (u:$11040; c:0), (u:$11041; c:0),
    (u:$11042; c:0), (u:$11043; c:0), (u:$11044; c:0), (u:$11045; c:0),
    (u:$11046; c:9), (u:$1107F; c:9), (u:$11080; c:0), (u:$11081; c:0),
    (u:$11082; c:210), (u:$110B0; c:210), (u:$110B1; c:210), (u:$110B2; c:210),
    (u:$110B3; c:0), (u:$110B4; c:0), (u:$110B5; c:0), (u:$110B6; c:0),
    (u:$110B7; c:210), (u:$110B8; c:210), (u:$110B9; c:9), (u:$110BA; c:7),
    (u:$11100; c:230), (u:$11101; c:230), (u:$11102; c:230), (u:$11127; c:0),
    (u:$11128; c:0), (u:$11129; c:0), (u:$1112A; c:0), (u:$1112B; c:0),
    (u:$1112C; c:210), (u:$1112D; c:0), (u:$1112E; c:0), (u:$1112F; c:0),
    (u:$11130; c:0), (u:$11131; c:0), (u:$11132; c:0), (u:$11133; c:9),
    (u:$11134; c:9), (u:$11145; c:210), (u:$11146; c:210), (u:$11173; c:7),
    (u:$11180; c:0), (u:$11181; c:0), (u:$11182; c:210), (u:$111B3; c:210),
    (u:$111B4; c:210), (u:$111B5; c:210), (u:$111B6; c:0), (u:$111B7; c:0),
    (u:$111B8; c:0), (u:$111B9; c:0), (u:$111BA; c:0), (u:$111BB; c:0),
    (u:$111BC; c:0), (u:$111BD; c:0), (u:$111BE; c:0), (u:$111BF; c:210),
    (u:$111C0; c:9), (u:$111C9; c:0), (u:$111CA; c:7), (u:$111CB; c:0),
    (u:$111CC; c:0), (u:$111CE; c:210), (u:$111CF; c:0), (u:$1122C; c:210),
    (u:$1122D; c:210), (u:$1122E; c:210), (u:$1122F; c:0), (u:$11230; c:0),
    (u:$11231; c:0), (u:$11232; c:210), (u:$11233; c:210), (u:$11234; c:0),
    (u:$11235; c:9), (u:$11236; c:7), (u:$11237; c:0), (u:$1123E; c:0),
    (u:$112DF; c:0), (u:$112E0; c:210), (u:$112E1; c:210), (u:$112E2; c:210),
    (u:$112E3; c:0), (u:$112E4; c:0), (u:$112E5; c:0), (u:$112E6; c:0),
    (u:$112E7; c:0), (u:$112E8; c:0), (u:$112E9; c:7), (u:$112EA; c:9),
    (u:$11300; c:0), (u:$11301; c:0), (u:$11302; c:210), (u:$11303; c:210),
    (u:$1133B; c:7), (u:$1133C; c:7), (u:$1133E; c:210), (u:$1133F; c:210),
    (u:$11340; c:0), (u:$11341; c:210), (u:$11342; c:210), (u:$11343; c:210),
    (u:$11344; c:210), (u:$11347; c:210), (u:$11348; c:210), (u:$1134B; c:210),
    (u:$1134C; c:210), (u:$1134D; c:9), (u:$11357; c:210), (u:$11362; c:210),
    (u:$11363; c:210), (u:$11366; c:230), (u:$11367; c:230), (u:$11368; c:230),
    (u:$11369; c:230), (u:$1136A; c:230), (u:$1136B; c:230), (u:$1136C; c:230),
    (u:$11370; c:230), (u:$11371; c:230), (u:$11372; c:230), (u:$11373; c:230),
    (u:$11374; c:230), (u:$11435; c:210), (u:$11436; c:210), (u:$11437; c:210),
    (u:$11438; c:0), (u:$11439; c:0), (u:$1143A; c:0), (u:$1143B; c:0),
    (u:$1143C; c:0), (u:$1143D; c:0), (u:$1143E; c:0), (u:$1143F; c:0),
    (u:$11440; c:210), (u:$11441; c:210), (u:$11442; c:9), (u:$11443; c:0),
    (u:$11444; c:0), (u:$11445; c:210), (u:$11446; c:7), (u:$1145E; c:230),
    (u:$114B0; c:210), (u:$114B1; c:210), (u:$114B2; c:210), (u:$114B3; c:0),
    (u:$114B4; c:0), (u:$114B5; c:0), (u:$114B6; c:0), (u:$114B7; c:0),
    (u:$114B8; c:0), (u:$114B9; c:210), (u:$114BA; c:0), (u:$114BB; c:210),
    (u:$114BC; c:210), (u:$114BD; c:210), (u:$114BE; c:210), (u:$114BF; c:0),
    (u:$114C0; c:0), (u:$114C1; c:210), (u:$114C2; c:9), (u:$114C3; c:7),
    (u:$115AF; c:210), (u:$115B0; c:210), (u:$115B1; c:210), (u:$115B2; c:0),
    (u:$115B3; c:0), (u:$115B4; c:0), (u:$115B5; c:0), (u:$115B8; c:210),
    (u:$115B9; c:210), (u:$115BA; c:210), (u:$115BB; c:210), (u:$115BC; c:0),
    (u:$115BD; c:0), (u:$115BE; c:210), (u:$115BF; c:9), (u:$115C0; c:7),
    (u:$115DC; c:0), (u:$115DD; c:0), (u:$11630; c:210), (u:$11631; c:210),
    (u:$11632; c:210), (u:$11633; c:0), (u:$11634; c:0), (u:$11635; c:0),
    (u:$11636; c:0), (u:$11637; c:0), (u:$11638; c:0), (u:$11639; c:0),
    (u:$1163A; c:0), (u:$1163B; c:210), (u:$1163C; c:210), (u:$1163D; c:0),
    (u:$1163E; c:210), (u:$1163F; c:9), (u:$11640; c:0), (u:$116AB; c:0),
    (u:$116AC; c:210), (u:$116AD; c:0), (u:$116AE; c:210), (u:$116AF; c:210),
    (u:$116B0; c:0), (u:$116B1; c:0), (u:$116B2; c:0), (u:$116B3; c:0),
    (u:$116B4; c:0), (u:$116B5; c:0), (u:$116B6; c:9), (u:$116B7; c:7),
    (u:$1171D; c:0), (u:$1171E; c:0), (u:$1171F; c:0), (u:$11720; c:210),
    (u:$11721; c:210), (u:$11722; c:0), (u:$11723; c:0), (u:$11724; c:0),
    (u:$11725; c:0), (u:$11726; c:210), (u:$11727; c:0), (u:$11728; c:0),
    (u:$11729; c:0), (u:$1172A; c:0), (u:$1172B; c:9), (u:$1182C; c:210),
    (u:$1182D; c:210), (u:$1182E; c:210), (u:$1182F; c:0), (u:$11830; c:0),
    (u:$11831; c:0), (u:$11832; c:0), (u:$11833; c:0), (u:$11834; c:0),
    (u:$11835; c:0), (u:$11836; c:0), (u:$11837; c:0), (u:$11838; c:210),
    (u:$11839; c:9), (u:$1183A; c:7), (u:$11930; c:210), (u:$11931; c:210),
    (u:$11932; c:210), (u:$11933; c:210), (u:$11934; c:210), (u:$11935; c:210),
    (u:$11937; c:210), (u:$11938; c:210), (u:$1193B; c:0), (u:$1193C; c:0),
    (u:$1193D; c:9), (u:$1193E; c:9), (u:$11940; c:210), (u:$11942; c:210),
    (u:$11943; c:7), (u:$119D1; c:210), (u:$119D2; c:210), (u:$119D3; c:210),
    (u:$119D4; c:0), (u:$119D5; c:0), (u:$119D6; c:0), (u:$119D7; c:0),
    (u:$119DA; c:0), (u:$119DB; c:0), (u:$119DC; c:210), (u:$119DD; c:210),
    (u:$119DE; c:210), (u:$119DF; c:210), (u:$119E0; c:9), (u:$119E4; c:210),
    (u:$11A01; c:0), (u:$11A02; c:0), (u:$11A03; c:0), (u:$11A04; c:0),
    (u:$11A05; c:0), (u:$11A06; c:0), (u:$11A09; c:0), (u:$11A0A; c:0),
    (u:$11A33; c:0), (u:$11A34; c:9), (u:$11A35; c:0), (u:$11A36; c:0),
    (u:$11A37; c:0), (u:$11A38; c:0), (u:$11A39; c:210), (u:$11A3B; c:0),
    (u:$11A3C; c:0), (u:$11A3D; c:0), (u:$11A3E; c:0), (u:$11A47; c:9),
    (u:$11A51; c:0), (u:$11A52; c:0), (u:$11A53; c:0), (u:$11A54; c:0),
    (u:$11A55; c:0), (u:$11A56; c:0), (u:$11A57; c:210), (u:$11A58; c:210),
    (u:$11A59; c:0), (u:$11A5A; c:0), (u:$11A5B; c:0), (u:$11A8A; c:0),
    (u:$11A8B; c:0), (u:$11A8C; c:0), (u:$11A8D; c:0), (u:$11A8E; c:0),
    (u:$11A8F; c:0), (u:$11A90; c:0), (u:$11A91; c:0), (u:$11A92; c:0),
    (u:$11A93; c:0), (u:$11A94; c:0), (u:$11A95; c:0), (u:$11A96; c:0),
    (u:$11A97; c:210), (u:$11A98; c:0), (u:$11A99; c:9), (u:$11C2F; c:210),
    (u:$11C30; c:0), (u:$11C31; c:0), (u:$11C32; c:0), (u:$11C33; c:0),
    (u:$11C34; c:0), (u:$11C35; c:0), (u:$11C36; c:0), (u:$11C38; c:0),
    (u:$11C39; c:0), (u:$11C3A; c:0), (u:$11C3B; c:0), (u:$11C3C; c:0),
    (u:$11C3D; c:0), (u:$11C3E; c:210), (u:$11C92; c:0), (u:$11C93; c:0),
    (u:$11C94; c:0), (u:$11C95; c:0), (u:$11C96; c:0), (u:$11C97; c:0),
    (u:$11C98; c:0), (u:$11C99; c:0), (u:$11C9A; c:0), (u:$11C9B; c:0),
    (u:$11C9C; c:0), (u:$11C9D; c:0), (u:$11C9E; c:0), (u:$11C9F; c:0),
    (u:$11CA0; c:0), (u:$11CA1; c:0), (u:$11CA2; c:0), (u:$11CA3; c:0),
    (u:$11CA4; c:0), (u:$11CA5; c:0), (u:$11CA6; c:0), (u:$11CA7; c:0),
    (u:$11CA9; c:210), (u:$11CAA; c:0), (u:$11CAB; c:0), (u:$11CAC; c:0),
    (u:$11CAD; c:0), (u:$11CAE; c:0), (u:$11CAF; c:0), (u:$11CB0; c:0),
    (u:$11CB1; c:210), (u:$11CB2; c:0), (u:$11CB3; c:0), (u:$11CB4; c:210),
    (u:$11CB5; c:0), (u:$11CB6; c:0), (u:$11D31; c:0), (u:$11D32; c:0),
    (u:$11D33; c:0), (u:$11D34; c:0), (u:$11D35; c:0), (u:$11D36; c:0),
    (u:$11D3A; c:0), (u:$11D3C; c:0), (u:$11D3D; c:0), (u:$11D3F; c:0),
    (u:$11D40; c:0), (u:$11D41; c:0), (u:$11D42; c:7), (u:$11D43; c:0),
    (u:$11D44; c:9), (u:$11D45; c:9), (u:$11D47; c:0), (u:$11D8A; c:210),
    (u:$11D8B; c:210), (u:$11D8C; c:210), (u:$11D8D; c:210), (u:$11D8E; c:210),
    (u:$11D90; c:0), (u:$11D91; c:0), (u:$11D93; c:210), (u:$11D94; c:210),
    (u:$11D95; c:0), (u:$11D96; c:210), (u:$11D97; c:9), (u:$11EF3; c:0),
    (u:$11EF4; c:0), (u:$11EF5; c:210), (u:$11EF6; c:210), (u:$16AF0; c:1),
    (u:$16AF1; c:1), (u:$16AF2; c:1), (u:$16AF3; c:1), (u:$16AF4; c:1),
    (u:$16B30; c:230), (u:$16B31; c:230), (u:$16B32; c:230), (u:$16B33; c:230),
    (u:$16B34; c:230), (u:$16B35; c:230), (u:$16B36; c:230), (u:$16F4F; c:0),
    (u:$16F51; c:210), (u:$16F52; c:210), (u:$16F53; c:210), (u:$16F54; c:210),
    (u:$16F55; c:210), (u:$16F56; c:210), (u:$16F57; c:210), (u:$16F58; c:210),
    (u:$16F59; c:210), (u:$16F5A; c:210), (u:$16F5B; c:210), (u:$16F5C; c:210),
    (u:$16F5D; c:210), (u:$16F5E; c:210), (u:$16F5F; c:210), (u:$16F60; c:210),
    (u:$16F61; c:210), (u:$16F62; c:210), (u:$16F63; c:210), (u:$16F64; c:210),
    (u:$16F65; c:210), (u:$16F66; c:210), (u:$16F67; c:210), (u:$16F68; c:210),
    (u:$16F69; c:210), (u:$16F6A; c:210), (u:$16F6B; c:210), (u:$16F6C; c:210),
    (u:$16F6D; c:210), (u:$16F6E; c:210), (u:$16F6F; c:210), (u:$16F70; c:210),
    (u:$16F71; c:210), (u:$16F72; c:210), (u:$16F73; c:210), (u:$16F74; c:210),
    (u:$16F75; c:210), (u:$16F76; c:210), (u:$16F77; c:210), (u:$16F78; c:210),
    (u:$16F79; c:210), (u:$16F7A; c:210), (u:$16F7B; c:210), (u:$16F7C; c:210),
    (u:$16F7D; c:210), (u:$16F7E; c:210), (u:$16F7F; c:210), (u:$16F80; c:210),
    (u:$16F81; c:210), (u:$16F82; c:210), (u:$16F83; c:210), (u:$16F84; c:210),
    (u:$16F85; c:210), (u:$16F86; c:210), (u:$16F87; c:210), (u:$16F8F; c:0),
    (u:$16F90; c:0), (u:$16F91; c:0), (u:$16F92; c:0), (u:$16FE4; c:0),
    (u:$16FF0; c:6), (u:$16FF1; c:6), (u:$1BC9D; c:0), (u:$1BC9E; c:1),
    (u:$1D165; c:216), (u:$1D166; c:216), (u:$1D167; c:1), (u:$1D168; c:1),
    (u:$1D169; c:1), (u:$1D16D; c:226), (u:$1D16E; c:216), (u:$1D16F; c:216),
    (u:$1D170; c:216), (u:$1D171; c:216), (u:$1D172; c:216), (u:$1D17B; c:220),
    (u:$1D17C; c:220), (u:$1D17D; c:220), (u:$1D17E; c:220), (u:$1D17F; c:220),
    (u:$1D180; c:220), (u:$1D181; c:220), (u:$1D182; c:220), (u:$1D185; c:230),
    (u:$1D186; c:230), (u:$1D187; c:230), (u:$1D188; c:230), (u:$1D189; c:230),
    (u:$1D18A; c:220), (u:$1D18B; c:220), (u:$1D1AA; c:230), (u:$1D1AB; c:230),
    (u:$1D1AC; c:230), (u:$1D1AD; c:230), (u:$1D242; c:230), (u:$1D243; c:230),
    (u:$1D244; c:230), (u:$1DA00; c:0), (u:$1DA01; c:0), (u:$1DA02; c:0),
    (u:$1DA03; c:0), (u:$1DA04; c:0), (u:$1DA05; c:0), (u:$1DA06; c:0),
    (u:$1DA07; c:0), (u:$1DA08; c:0), (u:$1DA09; c:0), (u:$1DA0A; c:0),
    (u:$1DA0B; c:0), (u:$1DA0C; c:0), (u:$1DA0D; c:0), (u:$1DA0E; c:0),
    (u:$1DA0F; c:0), (u:$1DA10; c:0), (u:$1DA11; c:0), (u:$1DA12; c:0),
    (u:$1DA13; c:0), (u:$1DA14; c:0), (u:$1DA15; c:0), (u:$1DA16; c:0),
    (u:$1DA17; c:0), (u:$1DA18; c:0), (u:$1DA19; c:0), (u:$1DA1A; c:0),
    (u:$1DA1B; c:0), (u:$1DA1C; c:0), (u:$1DA1D; c:0), (u:$1DA1E; c:0),
    (u:$1DA1F; c:0), (u:$1DA20; c:0), (u:$1DA21; c:0), (u:$1DA22; c:0),
    (u:$1DA23; c:0), (u:$1DA24; c:0), (u:$1DA25; c:0), (u:$1DA26; c:0),
    (u:$1DA27; c:0), (u:$1DA28; c:0), (u:$1DA29; c:0), (u:$1DA2A; c:0),
    (u:$1DA2B; c:0), (u:$1DA2C; c:0), (u:$1DA2D; c:0), (u:$1DA2E; c:0),
    (u:$1DA2F; c:0), (u:$1DA30; c:0), (u:$1DA31; c:0), (u:$1DA32; c:0),
    (u:$1DA33; c:0), (u:$1DA34; c:0), (u:$1DA35; c:0), (u:$1DA36; c:0),
    (u:$1DA3B; c:0), (u:$1DA3C; c:0), (u:$1DA3D; c:0), (u:$1DA3E; c:0),
    (u:$1DA3F; c:0), (u:$1DA40; c:0), (u:$1DA41; c:0), (u:$1DA42; c:0),
    (u:$1DA43; c:0), (u:$1DA44; c:0), (u:$1DA45; c:0), (u:$1DA46; c:0),
    (u:$1DA47; c:0), (u:$1DA48; c:0), (u:$1DA49; c:0), (u:$1DA4A; c:0),
    (u:$1DA4B; c:0), (u:$1DA4C; c:0), (u:$1DA4D; c:0), (u:$1DA4E; c:0),
    (u:$1DA4F; c:0), (u:$1DA50; c:0), (u:$1DA51; c:0), (u:$1DA52; c:0),
    (u:$1DA53; c:0), (u:$1DA54; c:0), (u:$1DA55; c:0), (u:$1DA56; c:0),
    (u:$1DA57; c:0), (u:$1DA58; c:0), (u:$1DA59; c:0), (u:$1DA5A; c:0),
    (u:$1DA5B; c:0), (u:$1DA5C; c:0), (u:$1DA5D; c:0), (u:$1DA5E; c:0),
    (u:$1DA5F; c:0), (u:$1DA60; c:0), (u:$1DA61; c:0), (u:$1DA62; c:0),
    (u:$1DA63; c:0), (u:$1DA64; c:0), (u:$1DA65; c:0), (u:$1DA66; c:0),
    (u:$1DA67; c:0), (u:$1DA68; c:0), (u:$1DA69; c:0), (u:$1DA6A; c:0),
    (u:$1DA6B; c:0), (u:$1DA6C; c:0), (u:$1DA75; c:0), (u:$1DA84; c:0),
    (u:$1DA9B; c:0), (u:$1DA9C; c:0), (u:$1DA9D; c:0), (u:$1DA9E; c:0),
    (u:$1DA9F; c:0), (u:$1DAA1; c:0), (u:$1DAA2; c:0), (u:$1DAA3; c:0),
    (u:$1DAA4; c:0), (u:$1DAA5; c:0), (u:$1DAA6; c:0), (u:$1DAA7; c:0),
    (u:$1DAA8; c:0), (u:$1DAA9; c:0), (u:$1DAAA; c:0), (u:$1DAAB; c:0),
    (u:$1DAAC; c:0), (u:$1DAAD; c:0), (u:$1DAAE; c:0), (u:$1DAAF; c:0),
    (u:$1E000; c:230), (u:$1E001; c:230), (u:$1E002; c:230), (u:$1E003; c:230),
    (u:$1E004; c:230), (u:$1E005; c:230), (u:$1E006; c:230), (u:$1E008; c:230),
    (u:$1E009; c:230), (u:$1E00A; c:230), (u:$1E00B; c:230), (u:$1E00C; c:230),
    (u:$1E00D; c:230), (u:$1E00E; c:230), (u:$1E00F; c:230), (u:$1E010; c:230),
    (u:$1E011; c:230), (u:$1E012; c:230), (u:$1E013; c:230), (u:$1E014; c:230),
    (u:$1E015; c:230), (u:$1E016; c:230), (u:$1E017; c:230), (u:$1E018; c:230),
    (u:$1E01B; c:230), (u:$1E01C; c:230), (u:$1E01D; c:230), (u:$1E01E; c:230),
    (u:$1E01F; c:230), (u:$1E020; c:230), (u:$1E021; c:230), (u:$1E023; c:230),
    (u:$1E024; c:230), (u:$1E026; c:230), (u:$1E027; c:230), (u:$1E028; c:230),
    (u:$1E029; c:230), (u:$1E02A; c:230), (u:$1E130; c:230), (u:$1E131; c:230),
    (u:$1E132; c:230), (u:$1E133; c:230), (u:$1E134; c:230), (u:$1E135; c:230),
    (u:$1E136; c:230), (u:$1E2EC; c:230), (u:$1E2ED; c:230), (u:$1E2EE; c:230),
    (u:$1E2EF; c:230), (u:$1E8D0; c:220), (u:$1E8D1; c:220), (u:$1E8D2; c:220),
    (u:$1E8D3; c:220), (u:$1E8D4; c:220), (u:$1E8D5; c:220), (u:$1E8D6; c:220),
    (u:$1E944; c:230), (u:$1E945; c:230), (u:$1E946; c:230), (u:$1E947; c:230),
    (u:$1E948; c:230), (u:$1E949; c:230), (u:$1E94A; c:7), (u:$E0100; c:0),
    (u:$E0101; c:0), (u:$E0102; c:0), (u:$E0103; c:0), (u:$E0104; c:0),
    (u:$E0105; c:0), (u:$E0106; c:0), (u:$E0107; c:0), (u:$E0108; c:0),
    (u:$E0109; c:0), (u:$E010A; c:0), (u:$E010B; c:0), (u:$E010C; c:0),
    (u:$E010D; c:0), (u:$E010E; c:0), (u:$E010F; c:0), (u:$E0110; c:0),
    (u:$E0111; c:0), (u:$E0112; c:0), (u:$E0113; c:0), (u:$E0114; c:0),
    (u:$E0115; c:0), (u:$E0116; c:0), (u:$E0117; c:0), (u:$E0118; c:0),
    (u:$E0119; c:0), (u:$E011A; c:0), (u:$E011B; c:0), (u:$E011C; c:0),
    (u:$E011D; c:0), (u:$E011E; c:0), (u:$E011F; c:0), (u:$E0120; c:0),
    (u:$E0121; c:0), (u:$E0122; c:0), (u:$E0123; c:0), (u:$E0124; c:0),
    (u:$E0125; c:0), (u:$E0126; c:0), (u:$E0127; c:0), (u:$E0128; c:0),
    (u:$E0129; c:0), (u:$E012A; c:0), (u:$E012B; c:0), (u:$E012C; c:0),
    (u:$E012D; c:0), (u:$E012E; c:0), (u:$E012F; c:0), (u:$E0130; c:0),
    (u:$E0131; c:0), (u:$E0132; c:0), (u:$E0133; c:0), (u:$E0134; c:0),
    (u:$E0135; c:0), (u:$E0136; c:0), (u:$E0137; c:0), (u:$E0138; c:0),
    (u:$E0139; c:0), (u:$E013A; c:0), (u:$E013B; c:0), (u:$E013C; c:0),
    (u:$E013D; c:0), (u:$E013E; c:0), (u:$E013F; c:0), (u:$E0140; c:0),
    (u:$E0141; c:0), (u:$E0142; c:0), (u:$E0143; c:0), (u:$E0144; c:0),
    (u:$E0145; c:0), (u:$E0146; c:0), (u:$E0147; c:0), (u:$E0148; c:0),
    (u:$E0149; c:0), (u:$E014A; c:0), (u:$E014B; c:0), (u:$E014C; c:0),
    (u:$E014D; c:0), (u:$E014E; c:0), (u:$E014F; c:0), (u:$E0150; c:0),
    (u:$E0151; c:0), (u:$E0152; c:0), (u:$E0153; c:0), (u:$E0154; c:0),
    (u:$E0155; c:0), (u:$E0156; c:0), (u:$E0157; c:0), (u:$E0158; c:0),
    (u:$E0159; c:0), (u:$E015A; c:0), (u:$E015B; c:0), (u:$E015C; c:0),
    (u:$E015D; c:0), (u:$E015E; c:0), (u:$E015F; c:0), (u:$E0160; c:0),
    (u:$E0161; c:0), (u:$E0162; c:0), (u:$E0163; c:0), (u:$E0164; c:0),
    (u:$E0165; c:0), (u:$E0166; c:0), (u:$E0167; c:0), (u:$E0168; c:0),
    (u:$E0169; c:0), (u:$E016A; c:0), (u:$E016B; c:0), (u:$E016C; c:0),
    (u:$E016D; c:0), (u:$E016E; c:0), (u:$E016F; c:0), (u:$E0170; c:0),
    (u:$E0171; c:0), (u:$E0172; c:0), (u:$E0173; c:0), (u:$E0174; c:0),
    (u:$E0175; c:0), (u:$E0176; c:0), (u:$E0177; c:0), (u:$E0178; c:0),
    (u:$E0179; c:0), (u:$E017A; c:0), (u:$E017B; c:0), (u:$E017C; c:0),
    (u:$E017D; c:0), (u:$E017E; c:0), (u:$E017F; c:0), (u:$E0180; c:0),
    (u:$E0181; c:0), (u:$E0182; c:0), (u:$E0183; c:0), (u:$E0184; c:0),
    (u:$E0185; c:0), (u:$E0186; c:0), (u:$E0187; c:0), (u:$E0188; c:0),
    (u:$E0189; c:0), (u:$E018A; c:0), (u:$E018B; c:0), (u:$E018C; c:0),
    (u:$E018D; c:0), (u:$E018E; c:0), (u:$E018F; c:0), (u:$E0190; c:0),
    (u:$E0191; c:0), (u:$E0192; c:0), (u:$E0193; c:0), (u:$E0194; c:0),
    (u:$E0195; c:0), (u:$E0196; c:0), (u:$E0197; c:0), (u:$E0198; c:0),
    (u:$E0199; c:0), (u:$E019A; c:0), (u:$E019B; c:0), (u:$E019C; c:0),
    (u:$E019D; c:0), (u:$E019E; c:0), (u:$E019F; c:0), (u:$E01A0; c:0),
    (u:$E01A1; c:0), (u:$E01A2; c:0), (u:$E01A3; c:0), (u:$E01A4; c:0),
    (u:$E01A5; c:0), (u:$E01A6; c:0), (u:$E01A7; c:0), (u:$E01A8; c:0),
    (u:$E01A9; c:0), (u:$E01AA; c:0), (u:$E01AB; c:0), (u:$E01AC; c:0),
    (u:$E01AD; c:0), (u:$E01AE; c:0), (u:$E01AF; c:0), (u:$E01B0; c:0),
    (u:$E01B1; c:0), (u:$E01B2; c:0), (u:$E01B3; c:0), (u:$E01B4; c:0),
    (u:$E01B5; c:0), (u:$E01B6; c:0), (u:$E01B7; c:0), (u:$E01B8; c:0),
    (u:$E01B9; c:0), (u:$E01BA; c:0), (u:$E01BB; c:0), (u:$E01BC; c:0),
    (u:$E01BD; c:0), (u:$E01BE; c:0), (u:$E01BF; c:0), (u:$E01C0; c:0),
    (u:$E01C1; c:0), (u:$E01C2; c:0), (u:$E01C3; c:0), (u:$E01C4; c:0),
    (u:$E01C5; c:0), (u:$E01C6; c:0), (u:$E01C7; c:0), (u:$E01C8; c:0),
    (u:$E01C9; c:0), (u:$E01CA; c:0), (u:$E01CB; c:0), (u:$E01CC; c:0),
    (u:$E01CD; c:0), (u:$E01CE; c:0), (u:$E01CF; c:0), (u:$E01D0; c:0),
    (u:$E01D1; c:0), (u:$E01D2; c:0), (u:$E01D3; c:0), (u:$E01D4; c:0),
    (u:$E01D5; c:0), (u:$E01D6; c:0), (u:$E01D7; c:0), (u:$E01D8; c:0),
    (u:$E01D9; c:0), (u:$E01DA; c:0), (u:$E01DB; c:0), (u:$E01DC; c:0),
    (u:$E01DD; c:0), (u:$E01DE; c:0), (u:$E01DF; c:0), (u:$E01E0; c:0),
    (u:$E01E1; c:0), (u:$E01E2; c:0), (u:$E01E3; c:0), (u:$E01E4; c:0),
    (u:$E01E5; c:0), (u:$E01E6; c:0), (u:$E01E7; c:0), (u:$E01E8; c:0),
    (u:$E01E9; c:0), (u:$E01EA; c:0), (u:$E01EB; c:0), (u:$E01EC; c:0),
    (u:$E01ED; c:0), (u:$E01EE; c:0), (u:$E01EF; c:0)
  );

