/***************************************************************************
 *   Copyright (C) 2007-2012 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "configgeneral.h"

#include <KFileDialog>
#include <KLocale>

// ------------------------------------------------------------------------------------------------------------------- //
//    Construction & Destruction                                                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

ConfigGeneral::ConfigGeneral(QWidget* parent)
    : QWidget(parent)
{
    m_ui.setupUi(this);

    m_ui.SelectBrowser->setIcon(KIcon("document-open"));
    connect(m_ui.SelectBrowser, SIGNAL(clicked()), this, SLOT(slotSelectBrowser()));

    m_ui.kcfg_CheckInterval->setSuffix(" " + i18np("second", "seconds", m_ui.kcfg_CheckInterval->value()));
    connect(m_ui.kcfg_CheckInterval, SIGNAL(valueChanged(int)), this, SLOT(slotCheckIntervalChanged()));
}

// ------------------------------------------------------------------------------------------------------------------- //

ConfigGeneral::~ConfigGeneral()
{
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Protected slots                                                                                                  //
// ------------------------------------------------------------------------------------------------------------------- //

void ConfigGeneral::slotCheckIntervalChanged()
{
    m_ui.kcfg_CheckInterval->setSuffix(" " + i18np("second", "seconds", m_ui.kcfg_CheckInterval->value()));
}

// ------------------------------------------------------------------------------------------------------------------- //

void ConfigGeneral::slotSelectBrowser()
{
    QString browserPath = KFileDialog::getOpenFileName(m_ui.kcfg_BrowserPath->text(), "", this, i18n("Select a file"));

    if (browserPath != QString::null)
    {
        if (QFile::exists(browserPath))
            m_ui.kcfg_BrowserPath->setText(browserPath);
    }
}

// ------------------------------------------------------------------------------------------------------------------- //

#include "configgeneral.moc"
