/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.esf;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;

public class CommitmentTypeQualifier
extends ASN1Encodable {
    private DERObjectIdentifier commitmentTypeIdentifier;
    private DEREncodable qualifier;

    public CommitmentTypeQualifier(DERObjectIdentifier dERObjectIdentifier) {
        this(dERObjectIdentifier, null);
    }

    public CommitmentTypeQualifier(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.commitmentTypeIdentifier = dERObjectIdentifier;
        this.qualifier = dEREncodable;
    }

    public CommitmentTypeQualifier(ASN1Sequence aSN1Sequence) {
        this.commitmentTypeIdentifier = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.size() > 1) {
            this.qualifier = aSN1Sequence.getObjectAt(1);
        }
    }

    public static CommitmentTypeQualifier getInstance(Object object) {
        if (object instanceof CommitmentTypeQualifier || object == null) {
            return (CommitmentTypeQualifier)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CommitmentTypeQualifier((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in getInstance.");
    }

    public DERObjectIdentifier getCommitmentTypeIdentifier() {
        return this.commitmentTypeIdentifier;
    }

    public DEREncodable getQualifier() {
        return this.qualifier;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.commitmentTypeIdentifier);
        if (this.qualifier != null) {
            aSN1EncodableVector.add(this.qualifier);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

