/* Built-in files */

#include "types.h"

unsigned char *builtins[]=
{
	USTR "joerc",
		USTR "-notite\n"
		"-assume_color\n"
		"-assume_256color\n"
		"-guess_non_utf8\n"
		"-guess_crlf\n"
		"-guess_indent\n"
		"-menu_above\n"
		"-transpose\n"
		"-joe_state\n"
		"-restore\n"
		"-search_prompting\n"
		"-lmsg \\i%k%T%W%I%X %n %m%y%R %M %x\n"
		"-rmsg  %S Row %r Col %c %t  Ctrl-K H for help\n"
		"-highlight\n"
		"-istep 2\n"
		":defmenu root\n"
		"mode,\"overwrite\",rtn	T Overtype %Zoverwrite%\n"
		"mode,\"hex\",rtn	% % Hex edit mode\n"
		"mode,\"autoindent\",rtn	I Autoindent %Zautoindent%\n"
		"mode,\"wordwrap\",rtn	W Word wrap %Zwordwrap%\n"
		"mode,\"tab\",rtn	D Tab width %Ztab%\n"
		"mode,\"lmargin\",rtn	L Left margin %Zlmargin%\n"
		"mode,\"rmargin\",rtn	R Right margin %Zrmargin%\n"
		"mode,\"square\",rtn	X Rectangle mode %Zsquare%\n"
		"mode,\"indentc\",rtn	% % Indent char %Zindentc%\n"
		"mode,\"istep\",rtn	% % Indent step %Zistep%\n"
		"mode,\"highlight\",rtn	H Highlighting %Zhighlight%\n"
		"mode,\"crlf\",rtn	Z CR-LF (MS-DOS) %Zcrlf%\n"
		"mode,\"linums\",rtn	N Line numbers %Zlinums%\n"
		"mode,\"beep\",rtn	B Beep %Zbeep%\n"
		"mode,\"rdonly\",rtn	O Read only %Zrdonly%\n"
		"mode,\"syntax\",rtn	Y Syntax\n"
		"mode,\"encoding\",rtn	E Encoding\n"
		"mode,\"asis\",rtn	% % Meta chars as-is\n"
		"mode,\"language\",rtn	V Language\n"
		"mode,\"picture\",rtn	P picture %Zpicture%\n"
		"menu,\"more-options\",rtn	  % % More options...\n"
		":defmenu more-options\n"
		"menu,\"^G\",rtn	% % ^G options\n"
		"menu,\"search\",rtn	% % search options\n"
		"menu,\"paragraph\",rtn	% % paragraph options\n"
		"menu,\"file\",rtn	% % file options\n"
		"menu,\"menu\",rtn	% % menu options\n"
		"menu,\"global\",rtn	% % global options\n"
		"menu,\"cursor\",rtn	% % cursor options\n"
		"menu,\"marking\",rtn	% % marking options\n"
		"menu,\"tab\",rtn	% % tab/indent options\n"
		":defmenu menu\n"
		"mode,\"menu_explorer\",rtn	% % Menu explorer %Zmenu_explorer%\n"
		"mode,\"menu_above\",rtn	% % Menu position %Zmenu_above%\n"
		"mode,\"menu_jump\",rtn	% % Jump into menu %Zmenu_jump%\n"
		"mode,\"transpose\",rtn	% % Transpose menus %Ztranspose%\n"
		":defmenu ^G\n"
		"mode,\"single_quoted\",rtn	% % ^G ignores '...' %Zsingle_quoted%\n"
		"mode,\"no_double_quoted\",rtn	% % ^G no ignore \"...\" %Zno_double_quoted%\n"
		"mode,\"c_comment\",rtn	% % ^G ignores /*...*/ %Zc_comment%\n"
		"mode,\"cpp_comment\",rtn	% % ^G ignores //... %Zcpp_comment%\n"
		"mode,\"pound_comment\",rtn	% % ^G ignores #... %Zpound_comment%\n"
		"mode,\"vhdl_comment\",rtn	% % ^G ignores --... %Zvhdl_comment%\n"
		"mode,\"semi_comment\",rtn	% % ^G ignores ;... %Zsemi_comment%\n"
		"mode,\"tex_comment\",rtn % % ^G ignores %... %Ztex_comment%\n"
		"mode,\"text_delimiters\",rtn % % Text delimiters %Ztext_delimiters%\n"
		":defmenu search\n"
		"mode,\"icase\",rtn	% % Case insensitivity %Zicase%\n"
		"mode,\"wrap\",rtn	% % Search wraps %Zwrap%\n"
		"mode,\"search_prompting\",rtn	% % Search prompting %Zsearch_prompting%\n"
		"mode,\"csmode\",rtn	% % Continued search %Zcsmode%\n"
		":defmenu paragraph\n"
		"mode,\"french\",rtn	% % French spacing %Zfrench%\n"
		"mode,\"flowed\",rtn	% % Flowed text %Zflowed%\n"
		"mode,\"cpara\",rtn	% % Paragraph indent chars %Zcpara%\n"
		":defmenu file\n"
		"mode,\"restore\",rtn	% % Restore cursor %Zrestore%\n"
		"mode,\"guess_crlf\",rtn	% % Auto detect CR-LF %Zguess_crlf%\n"
		"mode,\"guess_indent\",rtn	% % Guess indent %Zguess_indent%\n"
		"mode,\"guess_non_utf8\",rtn	% % Guess non-UTF-8 %Zguess_non_utf8%\n"
		"mode,\"guess_utf8\",rtn	% % Guess UTF-8 %Zguess_utf8%\n"
		"mode,\"force\",rtn	% % Force last NL %Zforce%\n"
		"mode,\"nobackup\",rtn	% % No backup %Znobackup%\n"
		":defmenu global\n"
		"mode,\"nolocks\",rtn	% % Disable locks %Znolocks%\n"
		"mode,\"nobackups\",rtn	% % Disable backups %Znobackups%\n"
		"mode,\"nomodcheck\",rtn	% % Disable mtime check %Znomodcheck%\n"
		"mode,\"nocurdir\",rtn	% % Disable current dir %Znocurdir%\n"
		"mode,\"exask\",rtn	% % Exit ask %Zexask%\n"
		"mode,\"nosta\",rtn	% % Disable status line %Znosta%\n"
		"mode,\"keepup\",rtn	% % Fast status line %Zkeepup%\n"
		"mode,\"break_hardlinks\",rtn	% % Break hard links %Zbreak_hardlinks%\n"
		"mode,\"break_links\",rtn	% % Break links %Zbreak_links%\n"
		"mode,\"joe_state\",rtn	% % Joe_state file %Zjoe_state%\n"
		"mode,\"undo_keep\",rtn	% % No. undo records %Zundo_keep%\n"
		"mode,\"backpath\",rtn	% % Path to backup files %Zbackpath%\n"
		":defmenu cursor\n"
		"mode,\"pg\",rtn	% % No. PgUp/PgDn lines %Zpg%\n"
		"mode,\"mid\",rtn	C Center on scroll %Zmid%\n"
		"mode,\"floatmouse\",rtn	% % Click past end %Zfloatmouse%\n"
		"mode,\"rtbutton\",rtn	% % Right button %Zrtbutton%\n"
		":defmenu marking\n"
		"mode,\"autoswap\",rtn	% % Autoswap mode %Zautoswap%\n"
		"mode,\"marking\",rtn	% % Marking %Zmarking%\n"
		"mode,\"lightoff\",rtn	% % Auto unmask %Zlightoff%\n"
		":defmenu tab\n"
		"mode,\"smarthome\",rtn	% % Smart home key %Zsmarthome%\n"
		"mode,\"smartbacks\",rtn	% % Smart backspace %Zsmartbacks%\n"
		"mode,\"indentfirst\",rtn	% % To indent first %Zindentfirst%\n"
		"mode,\"purify\",rtn	% % Clean up indents %Zpurify%\n"
		"mode,\"spaces\",rtn	% % No tabs %Zspaces%\n"
		"{Basic\n"
		"\\i   Help Screen    \\|turn off with ^KH    more help with ESC . (^[.)              \\i\n"
		"\\i \\i\\|\\uCURSOR\\u           \\|\\uGO TO\\u            \\|\\uBLOCK\\u      \\|\\uDELETE\\u   \\|\\uMISC\\u         \\|\\uEXIT\\u      \\|\\i \\i\n"
		"\\i \\i\\|^B left ^F right \\|^U  prev. screen \\|^KB begin  \\|^D char. \\|^KJ reformat \\|^KX save  \\|\\i \\i\n"
		"\\i \\i\\|^P up   ^N down  \\|^V  next screen  \\|^KK end    \\|^Y line  \\|^KA center   \\|^C  abort \\|\\i \\i\n"
		"\\i \\i\\|^Z previous word \\|^A  beg. of line \\|^KM move   \\|^W >word \\|^T  options  \\|^KZ shell \\|\\i \\i\n"
		"\\i \\i\\|^X next word     \\|^E  end of line  \\|^KC copy   \\|^O word< \\|^R  refresh  \\|\\uFILE\\u      \\|\\i \\i\n"
		"\\i \\i\\|\\uSEARCH\\u           \\|^KU top of file  \\|^KW file   \\|^J >line \\|\\uSPELL\\u        \\|^KE edit  \\|\\i \\i\n"
		"\\i \\i\\|^KF find text    \\|^KV end of file  \\|^KY delete \\|^_ undo  \\|^[N word     \\|^KR insert\\|\\i \\i\n"
		"\\i \\i\\|^L  find next    \\|^KL to line No.  \\|^K/ filter \\|^^ redo  \\|^[L file     \\|^KD save  \\|\\i \\i\n"
		"}\n"
		"{Windows\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i\\|^KO Split the window in half           \\|^KE Load file into window             \\|\\i \\i\n"
		"\\i \\i\\|^KG Make current window bigger         \\|^KT Make current window smaller       \\|\\i \\i\n"
		"\\i \\i\\|^KN Go to the window below             \\|^KP Go to the window above            \\|\\i \\i\n"
		"\\i \\i\\|^[V Switch to next buffer              \\|^[U Switch to previous buffer         \\|\\i \\i\n"
		"\\i \\i\\|^C  Eliminate the current window       \\|^KI Show all windows / Show one window\\|\\i \\i\n"
		"}\n"
		"{Advanced\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i\\|\\uMACROS\\u         \\|\\uMISC\\u            \\|\\uSCROLL\\u    \\|\\uSHELL\\u       \\|\\uGOTO\\u       \\|\\uI-SEARCH\\u     \\|\\i \\i\n"
		"\\i \\i\\|^K[ 0-9 Record \\|^K SPACE status \\|^[W Up    \\|^K' Window  \\|^[B To ^KB \\|^[R Backwards\\|\\i \\i\n"
		"\\i \\i\\|^K]     Stop   \\|^K\\\\ Repeat      \\|^[Z Down  \\|^[! Command \\|^[K To ^KK \\|^[S Forwards \\|\\i \\i\n"
		"\\i \\i\\|^K 0-9  Play   \\|\\uINSERT\\u          \\|^K< Left  \\|\\uQUOTE\\u       \\|\\uDELETE\\u     \\|\\uBOOKMARKS\\u    \\|\\i \\i\n"
		"\\i \\i\\|^K?     Query  \\|^] split line   \\|^K> Right \\|^[' Ctrl-   \\|^[Y yank   \\|^[ 0-9 Goto  \\|\\i \\i\n"
		"\\i \\i\\|^[D     Dump   \\|^SPACE ins space\\|          \\|^\\\\ Meta-    \\|^[O line<  \\|^[^[   Set   \\|\\i \\i\n"
		"}\n"
		"{Programs\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i\\|\\uGOTO\\u                 \\|\\uINDENT\\u   \\|\\uCOMPILING\\u          \\uQUICK\\u                       \\|\\i \\i\n"
		"\\i \\i\\|^G  Matching ( [ {   \\|^K, less \\|^[C Compile & parse ^G  find word under cursor \\|\\i \\i\n"
		"\\i \\i\\|^K- Previous place   \\|^K. more \\|^[G Grep & parse    ^[ENTER complete word      \\|\\i \\i\n"
		"\\i \\i\\|^K= Next place         \\|       \\|^[= To next error   ^[Y paste deleted text     \\|\\i \\i\n"
		"\\i \\i\\|^K; Tags file search   \\|       \\|^[- To prev. error  ^[^Y cycle through deleted \\|\\i \\i\n"
		"\\i \\i\\|                       \\|       \\|^[ SP Jump to error                            \\|\\i \\i\n"
		"}\n"
		"{Search\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\iSpecial search sequences:                                                    \\|\\i \\i\n"
		"\\i \\i    \\\\^  \\\\$  matches beg./end of line      \\\\?     match any single char       \\|\\i \\i\n"
		"\\i \\i    \\\\<  \\\\>  matches beg./end of word      \\\\*     match 0 or more chars       \\|\\i \\i\n"
		"\\i \\i    \\\\c      matches balanced C expression \\\\\\\\     matches a \\\\                 \\|\\i \\i\n"
		"\\i \\i    \\\\[..]   matches one of a set          \\\\n     matches a newline           \\|\\i \\i\n"
		"\\i \\i    \\\\+      matches 0 or more of the character which follows the \\\\+          \\|\\i \\i\n"
		"\\i \\iSpecial replace sequences:                                                   \\|\\i \\i\n"
		"\\i \\i    \\\\&      replaced with text which matched search string                   \\|\\i \\i\n"
		"\\i \\i    \\\\0 - 9  replaced with text which matched Nth \\\\*, \\\\?, \\\\c, \\\\+, or \\\\[..]    \\|\\i \\i\n"
		"\\i \\i    \\\\\\\\      replaced with \\\\               \\\\n     replaced with newline       \\|\\i \\i\n"
		"}\n"
		"{SearchOptions\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\iSearch options:                                                              \\|\\i \\i\n"
		"\\i \\i   r Replace                                                                 \\|\\i \\i\n"
		"\\i \\i   k Restrict search to highlighted block, which can be rectangular          \\|\\i \\i\n"
		"\\i \\i   b Search backward instead of forward                                      \\|\\i \\i\n"
		"\\i \\i   i Ignore case                                                             \\|\\i \\i\n"
		"\\i \\i   a Search across all loaded files                                          \\|\\i \\i\n"
		"\\i \\i   e Search across all files in Grep or Compile error list                   \\|\\i \\i\n"
		"\\i \\i   w Wrap to beginning of file for this search                               \\|\\i \\i\n"
		"\\i \\i   n Do not wrap to beginning of file for this search                        \\|\\i \\i\n"
		"\\i \\i   nnn Perform exaclty nnn replacements                                      \\|\\i \\i\n"
		"}\n"
		"{Math\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i \\uCOMMANDS\\u (hit ESC m for math)  \\uFUNCTIONS\\u                                    \\|\\i \\i\n"
		"\\i \\i     hex hex display mode       sin cos tab asin acos atan                   \\|\\i \\i\n"
		"\\i \\i     dec decimal mode           sinh cosh tanh asinh acosh atanh             \\|\\i \\i\n"
		"\\i \\i     ins type result into file  sqrt cbrt exp ln log                         \\|\\i \\i\n"
		"\\i \\i    eval evaluate block         int floor ceil abs erg ergc                  \\|\\i \\i\n"
		"\\i \\i    0xff enter number in hex    joe(..macro..) - runs an editor macro        \\|\\i \\i\n"
		"\\i \\i    3e-4 floating point decimal \\uBLOCK\\u                                        \\|\\i \\i\n"
		"\\i \\i    a=10 assign a variable      sum cnt  Sum, count                          \\|\\i \\i\n"
		"\\i \\i 2+3:ins multiple commands      avg dev  Average, std. deviation             \\|\\i \\i\n"
		"\\i \\i    e pi constants              \\uOPERATORS\\u                                    \\|\\i \\i\n"
		"\\i \\i     ans previous result        ! ^  * / %  + -  < <= > >= == !=  &&  ||  ? :\\|\\i \\i\n"
		"}\n"
		"{Names\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i Hit TAB at file name prompts to generate menu of file names                 \\|\\i \\i\n"
		"\\i \\i Or use up/down keys to access history of previously entered names           \\|\\i \\i\n"
		"\\i \\i Special file names:                                                         \\|\\i \\i\n"
		"\\i \\i      !command                 Pipe in/out of a shell command                \\|\\i \\i\n"
		"\\i \\i      >>filename               Append to a file                              \\|\\i \\i\n"
		"\\i \\i      -                        Read/Write to/from standard I/O               \\|\\i \\i\n"
		"\\i \\i      filename,START,SIZE      Read/Write a part of a file/device            \\|\\i \\i\n"
		"\\i \\i          Give START/SIZE in decimal (255), octal (0377) or hex (0xFF)       \\|\\i \\i\n"
		"}\n"
		"{Joe\n"
		"\\i   Help Screen    \\|turn off with ^KH    prev. screen ^[,                        \\i\n"
		"\\i \\i Send bug reports to: http://sourceforge.net/projects/joe-editor \\|\\i \\i\n"
		"\\i \\i \\|\\i \\i\n"
		"}\n"
		":windows		Bindings common to all windows\n"
		"type		^@ TO 		Type a character\n"
		"abort		^C		Abort window\n"
		"abort		^K Q\n"
		"abort		^K ^Q\n"
		"abort		^K q\n"
		"arg		^K \\		Repeat next command\n"
		"explode		^K I		Show all windows or show only one window\n"
		"explode		^K ^I\n"
		"explode		^K i\n"
		"help		^K H		Help menu\n"
		"help		^K ^H\n"
		"help		^K h\n"
		"hnext		^[ .		Next help window\n"
		"hprev		^[ ,		Previous help window\n"
		"math		^[ m		Calculator\n"
		"math		^[ M		Calculator\n"
		"msg		^[ h		Display a message\n"
		"msg		^[ H		Display a message\n"
		"msg		^[ ^H		Display a message\n"
		"nextw		^K N		Goto next window\n"
		"nextw		^K ^N\n"
		"nextw		^K n\n"
		"pgdn		.kN		Screen down\n"
		"pgdn		^V\n"
		"pgdn		^[ [ 6 ~\n"
		"pgup		.kP		Screen up\n"
		"pgup		^U\n"
		"pgup		^[ [ 5 ~\n"
		"play		^K 0 TO 9	Execute macro\n"
		"prevw		^K P		Goto previous window\n"
		"prevw		^K ^P\n"
		"prevw		^K p\n"
		"query		^K ?		Macro query insert\n"
		"record		^K [		Record a macro\n"
		"retype		^R		Refresh screen\n"
		"rtn		^M		Return\n"
		"shell		^K Z		Shell escape\n"
		"shell		^K ^Z\n"
		"shell		^K z\n"
		"stop		^K ]		Stop recording\n"
		"defmdown	MDOWN		Move the cursor to the mouse location\n"
		"defmup		MUP\n"
		"defmdrag	MDRAG		Select a region of characters\n"
		"defm2down	M2DOWN		Select the word at the mouse location\n"
		"defm2up		M2UP\n"
		"defm2drag	M2DRAG		Select a region of words\n"
		"defm3down	M3DOWN		Select the line at the mouse location\n"
		"defm3up		M3UP\n"
		"defm3drag	M3DRAG		Select a region of lines\n"
		"xtmouse		^[ [ M		Introduces an xterm mouse event\n"
		":main			Text editing window\n"
		":inherit windows\n"
		":def ispellfile filt,\"cat >ispell.tmp;ispell ispell.tmp </dev/tty >/dev/tty;cat ispell.tmp;/bin/rm ispell.tmp\",rtn,retype\n"
		":def ispellword psh,nextword,markk,prevword,markb,filt,\"cat >ispell.tmp;ispell ispell.tmp </dev/tty >/dev/tty;tr -d <ispell.tmp '\\\\012';/bin/rm ispell.tmp\",rtn,retype,nextword\n"
		":def aspellfile filt,\"SPLTMP=ispell.tmp;cat >$SPLTMP;aspell --lang=\",language,\".\",charset,\" -x -c $SPLTMP </dev/tty >/dev/tty;cat $SPLTMP;/bin/rm $SPLTMP\",rtn,retype\n"
		":def aspellword psh,nextword,markk,prevword,markb,filt,\"SPLTMP=ispell.tmp;cat >$SPLTMP;aspell --lang=\",language,\".\",charset,\" -x -c $SPLTMP </dev/tty >/dev/tty;tr -d <$SPLTMP '\\\\012';/bin/rm $SPLTMP\",rtn,retype,nextword\n"
		"aspellfile	^[ l\n"
		"aspellword	^[ n\n"
		":def compile mwind!,mfit!,querysave,query,scratch,\"* Build Log *\",rtn,bof,markb,eof,\" \",markk,blkdel,build\n"
		":def grep_find mwind!,mfit!,scratch,\"* Grep Log *\",rtn,bof,markb,eof,\" \",markk,blkdel,grep\n"
		":def man scratch,\"* Man Page *\",rtn,bof,markb,eof,\" \",markk,blkdel,\" \",ltarw,run,\"man -P cat -S 2:3 \"\n"
		"paste			^[ ] 5 2 ;		Bracketed paste\n"
		"insc			^[ [ 2 ~\n"
		"insc			^[ [ L			SCO\n"
		"delch			^[ [ 3 ~\n"
		"pgup			^[ [ I		SCO\n"
		"pgdn			^[ [ G		SCO\n"
		"home			^[ [ 1 ~		Putty, Linux, Cygwin\n"
		"home			^[ [ H			Xterm, Konsole, SCO\n"
		"home			^[ O H			gnome-terminal\n"
		"home			^[ [ 7 ~		RxVT\n"
		"eol			^[ [ 4 ~		Putty, Linux, Cygwin, ssh\n"
		"eol			^[ [ F			Xterm, Konsole, SCO\n"
		"eol			^[ O F			gnome-terminal\n"
		"eol			^[ [ 8 ~		RxVT\n"
		"rtarw,ltarw,begin_marking,rtarw,toggle_marking	^[ [ 1 ; 5 C    Mark right Xterm\n"
		"rtarw,ltarw,begin_marking,rtarw,toggle_marking	^[ [ 5 C        Mark right Gnome-terminal\n"
		"rtarw,ltarw,begin_marking,rtarw,toggle_marking	^[ O c		Mark right RxVT Ctrl-rtarw\n"
		"ltarw,rtarw,begin_marking,ltarw,toggle_marking	^[ [ 1 ; 5 D    Mark left\n"
		"ltarw,rtarw,begin_marking,ltarw,toggle_marking	^[ [ 5 D        Mark left\n"
		"ltarw,rtarw,begin_marking,ltarw,toggle_marking	^[ O d		Mark left RxVT Ctrl-ltarw\n"
		"uparw,dnarw,begin_marking,uparw,toggle_marking	^[ [ 1 ; 5 A    Mark up\n"
		"uparw,dnarw,begin_marking,uparw,toggle_marking	^[ [ 5 A        Mark up\n"
		"uparw,dnarw,begin_marking,uparw,toggle_marking	^[ O a		Mark up RxVT Ctrl-uparw\n"
		"dnarw,uparw,begin_marking,dnarw,toggle_marking	^[ [ 1 ; 5 B    Mark down\n"
		"dnarw,uparw,begin_marking,dnarw,toggle_marking	^[ [ 5 B        Mark down\n"
		"dnarw,uparw,begin_marking,dnarw,toggle_marking	^[ O b		Mark down RxVT Ctrl-dnarw\n"
		"blkdel,nmark   ^[ [ 3 ; 5 -	Gnome-terminal Ctrl-Del\n"
		"blkdel,nmark   ^[ [ 3 ; 5 ~	Xterm Ctrl-Del\n"
		"yank		^[ [ 2 ; 5 -	Gnome-terminal Ctrl-Ins\n"
		"yank		^[ [ 2 ; 5 ~    Xterm Ctrl-Ins\n"
		"delbol		^[ o		Delete to beginning of line\n"
		"delbol		^[ ^O		Delete to beginning of line\n"
		"dnslide		^[ z		Scroll down one line\n"
		"dnslide		^[ Z		Scroll down one line\n"
		"dnslide		^[ ^Z		Scroll down one line\n"
		"dnslide,dnslide,dnslide,dnslide		MWDOWN\n"
		"compile		^[ c		Compile\n"
		"compile		^[ C\n"
		"compile		^[ ^C		Compile\n"
		"grep_find	^[ g		Grep\n"
		"grep_find	^[ G		Grep\n"
		"grep_find	^[ ^G		Grep\n"
		"execmd		^[ x		Prompt for command to execute\n"
		"execmd		^[ X		Prompt for command to execute\n"
		"execmd		^[ ^X		Prompt for command to execute\n"
		"finish		^[ ^I		Complete word in document\n"
		"finish		^[ ^M		Complete word: used to be math\n"
		"mwind,mfit,jump,bol		^[ SP\n"
		"isrch		^[ s		Forward incremental search\n"
		"isrch		^[ S		Forward incremental search\n"
		"isrch		^[ ^S		Forward incremental search\n"
		"notmod		^[ ~		Not modified\n"
		"mwind,mfit,prevw,nxterr		^[ =		To next error\n"
		"parserr		^[ e		Parse errors in current buffer\n"
		"parserr		^[ E		Parse errors in current buffer\n"
		"parserr		^[ ^E		Parse errors in current buffer\n"
		"mwind,mfit,prevw,prverr		^[ -		To previous error\n"
		"rsrch		^[ r		Backward incremental search\n"
		"rsrch		^[ R		Backward incremental search\n"
		"rsrch		^[ ^R		Backward incremental search\n"
		"run		^[ !		Run a program in a window\n"
		"tomarkb		^[ b		Go to beginning of marked block\n"
		"tomarkb		^[ ^B		Go to beginning of marked block\n"
		"tomarkk		^[ k		Go to end of marked block\n"
		"tomarkk		^[ ^K		Go to end of marked block\n"
		"tomarkk		^[ K		Go to end of marked block\n"
		"txt		^[ i		Prompt for text and insert it\n"
		"txt		^[ I		Prompt for text and insert it\n"
		"upslide		^[ w		Scroll up one line\n"
		"upslide		^[ ^W		Scroll up one line\n"
		"upslide		^[ W		Scroll up one line\n"
		"upslide,upslide,upslide,upslide		MWUP\n"
		"yank		^[ y		Undelete text\n"
		"yankpop		^[ ^Y		Undelete text\n"
		"yank		^[ Y		Undelete text\n"
		"insc		^@		Ctrl-space used to insert a space\n"
		"nbuf		^[ v		Next buffer\n"
		"nbuf		^[ V		Next buffer\n"
		"nbuf		^[ ^V		Next buffer\n"
		"pbuf		^[ u		Prev buffer\n"
		"pbuf		^[ U		Prev buffer\n"
		"pbuf		^[ ^U		Prev buffer\n"
		"quote8		^\\		Enter Meta chars\n"
		"quote		^[ '		Enter Ctrl chars\n"
		"quote		^Q\n"
		"backs		^?		Backspace\n"
		"backs		^H\n"
		"backw		^O		Backspace word\n"
		"bknd		^K '		Shell window\n"
		"blkcpy		^K C		Copy marked block\n"
		"blkcpy		^K ^C\n"
		"blkcpy		^K c\n"
		"blkdel		^K Y		Delete marked block\n"
		"blkdel		^K ^Y\n"
		"blkdel		^K y\n"
		"blkmove		^K M		Move marked block\n"
		"blkmove		^K ^M\n"
		"blkmove		^K m\n"
		"blksave		^K W		Save marked block\n"
		"blksave		^K ^W\n"
		"blksave		^K w\n"
		"bof		^K U		Goto beginning of file\n"
		"bof		^K ^U\n"
		"bof		^K u\n"
		"home		.kh\n"
		"home		^A\n"
		"center		^K A		Center line\n"
		"center		^K ^A\n"
		"center		^K a\n"
		"crawll		^K <		Pan left\n"
		"crawlr		^K >		Pan right\n"
		"delch		.kD		Delete character\n"
		"delch		^D\n"
		"deleol		^J		Delete to end of line\n"
		"dellin		^Y		Delete entire line\n"
		"delw		^W		Delete word to right\n"
		"dnarw		.kd		Go down\n"
		"dnarw		^N\n"
		"dnarw		^[ O B\n"
		"dnarw		^[ [ B\n"
		"edit		^K E		Edit a file\n"
		"edit		^K ^E\n"
		"edit		^K e\n"
		"eof		^K V		Go to end of file\n"
		"eof		^K ^V\n"
		"eof		^K v\n"
		"eol		.kH		Go to end of line\n"
		"eol		.@7\n"
		"eol		^E\n"
		"exsave		^K X		Save and exit\n"
		"exsave		^K ^X\n"
		"exsave		^K x\n"
		"ffirst		^K F		Find first\n"
		"ffirst		^K ^F\n"
		"ffirst		^K f\n"
		"filt		^K /		Filter block\n"
		"fnext		^L		Find next\n"
		"fmtblk		^K J		Format paragraphs in block\n"
		"fmtblk		^K ^J\n"
		"fmtblk		^K j\n"
		"gomark		^[ 0 TO 9	Goto bookmark\n"
		"groww		^K G		Grow window\n"
		"groww		^K ^G\n"
		"groww		^K g\n"
		"insc		.kI		Insert a space\n"
		"insf		^K R		Insert a file\n"
		"insf		^K ^R\n"
		"insf		^K r\n"
		"lindent		^K ,		Indent to left\n"
		"line		^K L		Goto line no.\n"
		"line		^K ^L\n"
		"line		^K l\n"
		"ltarw		.kl		Go left\n"
		"ltarw		^B\n"
		"ltarw		^[ O D\n"
		"ltarw		^[ [ D\n"
		"macros		^[ d		Dump keyboard macros\n"
		"macros		^[ ^D\n"
		"markb		^K B		Set beginning of marked block\n"
		"markb		^K ^B\n"
		"markb		^K b\n"
		"markk		^K K		Set end of marked block\n"
		"markk		^K ^K\n"
		"markk		^K k\n"
		"menu,\"root\",rtn		^T		Options menu\n"
		"nextpos		^K =		Goto next position in position history\n"
		"nextword	^X		Goto next word\n"
		"open		^]		Split line\n"
		"prevpos		^K -		Previous position in history\n"
		"prevword	^Z		Previous word\n"
		"redo		^^		Redo changes\n"
		"rindent		^K .		Indent to right\n"
		"rtarw		.kr		Go right\n"
		"rtarw		^F\n"
		"rtarw		^[ O C\n"
		"rtarw		^[ [ C\n"
		"run		^K !		Run a shell command\n"
		"save		^K D		Save file\n"
		"save		^K S\n"
		"save		^K ^D\n"
		"save		^K ^S\n"
		"save		^K d\n"
		"save		^K s\n"
		"setmark		^[ ^[		Set bookmark\n"
		"shrinkw		^K T		Shrink window\n"
		"shrinkw		^K ^T\n"
		"shrinkw		^K t\n"
		"splitw		^K O		Split window\n"
		"splitw		^K ^O\n"
		"splitw		^K o\n"
		"stat		^K SP		Show status\n"
		"tag		^K ;		Tags file search\n"
		"tomatch		^G		Goto matching parenthasis\n"
		"undo		^_		Undo changes\n"
		"uparw		.ku		Go up\n"
		"uparw		^P\n"
		"uparw		^[ O A\n"
		"uparw		^[ [ A\n"
		":prompt			Prompt windows\n"
		":inherit main\n"
		"if,\"byte>size\",then,complete,complete,else,delch,endif	^D\n"
		"complete	^I\n"
		"dnarw,eol	.kd		Go down\n"
		"dnarw,eol	^N\n"
		"dnarw,eol	^[ O B\n"
		"dnarw,eol	^[ [ B\n"
		"uparw,eol	.ku		Go up\n"
		"uparw,eol	^P\n"
		"uparw,eol	^[ O A\n"
		"uparw,eol	^[ [ A\n"
		":menu			Selection menus\n"
		":inherit windows\n"
		"pgupmenu			^[ [ I\n"
		"pgdnmenu			^[ [ G\n"
		"bolmenu			^[ [ 1 ~		Putty, Linux, Cygwin\n"
		"bolmenu			^[ [ H			Xterm, Konsole\n"
		"bolmenu			^[ O H			gnome-terminal\n"
		"bolmenu			^[ [ 7 ~		RxVT\n"
		"eolmenu			^[ [ 4 ~		Putty, Linux, Cygwin, ssh\n"
		"eolmenu			^[ [ F			Xterm, Konsole\n"
		"eolmenu			^[ O F			gnome-terminal\n"
		"eolmenu			^[ [ 8 ~		RxVT\n"
		"abort		^[ ^[	Why?\n"
		"backsmenu	^?\n"
		"backsmenu	^H\n"
		"bofmenu		^K U\n"
		"bofmenu		^K ^U\n"
		"bofmenu		^K u\n"
		"bolmenu		.kh\n"
		"bolmenu		^A\n"
		"dnarwmenu	.kd\n"
		"dnarwmenu	^N\n"
		"dnarwmenu	^[ [ B\n"
		"dnarwmenu	^[ O B\n"
		"dnarwmenu	MWDOWN\n"
		"eofmenu		^K V\n"
		"eofmenu		^K ^V\n"
		"eofmenu		^K v\n"
		"eolmenu		.kH\n"
		"eolmenu		^E\n"
		"ltarwmenu	.kl\n"
		"ltarwmenu	^B\n"
		"ltarwmenu	^[ [ D\n"
		"ltarwmenu	^[ O D\n"
		"pgdnmenu	.kN		Screen down\n"
		"pgdnmenu	^V\n"
		"pgdnmenu	^[ [ 6 ~\n"
		"pgupmenu	.kP		Screen up\n"
		"pgupmenu	^U\n"
		"pgupmenu	^[ [ 5 ~\n"
		"rtarwmenu	.kr\n"
		"rtarwmenu	^F\n"
		"rtarwmenu	^[ [ C\n"
		"rtarwmenu	^[ O C\n"
		"rtn		SP\n"
		"rtn		^I\n"
		"rtn		^K H\n"
		"rtn		^K h\n"
		"rtn		^K ^H\n"
		"tabmenu		^I\n"
		"uparwmenu	.ku\n"
		"uparwmenu	^P\n"
		"uparwmenu	^[ [ A\n"
		"uparwmenu	^[ O A\n"
		"uparwmenu	MWUP\n"
		"defm2down	M2DOWN		Hits return key\n"
		":query			Single-key query window\n"
		":inherit windows\n"
		":querya			Single-key query window for quoting\n"
		"type		^@ TO \n"
		":querysr		Search & replace query window\n"
		"type		^@ TO \n"
,	USTR "c.jsf.in",
		USTR "=Idle\n"
		"=Bad		bold red\n"
		"=Preproc 	blue\n"
		"=Define		bold blue\n"
		"=Comment 	green\n"
		"=IncLocal	cyan\n"
		"=IncSystem	bold cyan\n"
		"=Constant 	cyan\n"
		"=Escape 	bold cyan\n"
		"=Type 		bold\n"
		"=Keyword 	bold\n"
		"=CppKeyword	bold\n"
		"=Brace		magenta\n"
		"=Control\n"
		"\n"
		":reset Idle\n"
		"	*		first		noeat\n"
		"	\" \\t\"		reset\n"
		"\n"
		":first Idle\n"
		"	*		idle		noeat\n"
		"	\"#\"		pre		recolor=-1\n"
		"\n"
		":pre Preproc\n"
		"	*		preproc		noeat\n"
		"	\" \\t\"		pre\n"
		"	\"a-z\"		preident	recolor=-1 buffer\n"
		"\n"
		":preident Preproc\n"
		"	*		preproc		noeat strings\n"
		"	\"define\"	predef\n"
		"	\"include\"	preinc\n"
		"done\n"
		"	\"a-z\"		preident\n"
		"\n"
		":preinc Preproc\n"
		"	*		preinc\n"
		"	\" \\t\"		preinc_ws\n"
		"	\"\\n\"		reset\n"
		"	\n"
		":preinc_ws Preproc\n"
		"	*		prebad		recolor=-1\n"
		"	\" \\t\"		preinc_ws\n"
		"	\"\\\"\"		preinc_local	recolor=-1\n"
		"	\"<\"		preinc_system	recolor=-1\n"
		"\n"
		":preinc_local IncLocal\n"
		"	*		preinc_local\n"
		"	\"\\\"\\n\"		reset\n"
		"	\n"
		":preinc_system IncSystem\n"
		"	*		preinc_system\n"
		"	\">\\n\"		reset\n"
		"\n"
		":prebad	Bad	\n"
		"	*		prebad\n"
		"	\"\\n\"		reset\n"
		"\n"
		"\n"
		":predef Preproc\n"
		"	*		predef\n"
		"	\" \\t\"		predef_ws\n"
		"	\"\\n\"		reset\n"
		"	\n"
		":predef_ws Preproc\n"
		"	*		prebad		recolor=-1\n"
		"	\" \\t\"		predef_ws\n"
		"	\"a-zA-Z0-9_\"	predef_ident	recolor=-1\n"
		"\n"
		":predef_ident Define\n"
		"	*		idle		noeat\n"
		"	\"a-zA-Z0-9_\"	predef_ident\n"
		"\n"
		"\n"
		":preproc Preproc\n"
		"	*		preproc\n"
		"	\"\\n\"		reset\n"
		"	\"\\\\\"		preproc_cont\n"
		"	\"/\"		preproc_slash\n"
		"	\n"
		":preproc_slash Preproc\n"
		"	*		preproc		noeat\n"
		"	\"*\"		comment		recolor=-2\n"
		"	\"/\"		line_comment	recolor=-2\n"
		"	\n"
		":preproc_cont Preproc\n"
		"	*		preproc_cont\n"
		"	\"\\n\"		preproc\n"
		"\n"
		":idle Idle\n"
		"	*		idle\n"
		"	\"\\n\"		reset\n"
		"	\"/\"		slash\n"
		"	\"0\"		first_digit	recolor=-1\n"
		"	\"1-9\"		decimal	recolor=-1\n"
		"	\".\"		maybe_float\n"
		"	\"\\\"\"		string		recolor=-1\n"
		"	\"'\"		char		recolor=-1\n"
		"	\"a-zA-Z_\"	ident		buffer\n"
		"	\"\\\\\"		outside_escape	recolor=-1\n"
		"	\"{}\"		brace		recolor=-1\n"
		"	\",:;=()><[]*&|!~+\\-%^\"	control		recolor=-1\n"
		"\n"
		":outside_escape	Escape\n"
		"	*	idle\n"
		"\n"
		":brace Brace\n"
		"	*	idle	noeat\n"
		"\n"
		":control Control\n"
		"	*	idle	noeat\n"
		"\n"
		":slash Idle\n"
		"	*		idle		noeat recolor=-2\n"
		"	\"*\"		comment		recolor=-2\n"
		"	\"/\"		line_comment	recolor=-2\n"
		"\n"
		":comment Comment\n"
		"	*		comment\n"
		"	\"*\"		maybe_end_comment\n"
		"\n"
		":maybe_end_comment Comment\n"
		"	*		comment\n"
		"	\"/\"		idle\n"
		"	\"*\"		maybe_end_comment\n"
		"\n"
		":line_comment Comment\n"
		"	*		line_comment\n"
		"	\"\\n\"		reset\n"
		"\n"
		":first_digit Constant\n"
		"	*		idle	noeat\n"
		"	\"xX\"		hex\n"
		"	\".\"		float\n"
		"	\"eE\"		epart\n"
		"	\"0-7\"		octal\n"
		"	\"89\"		bad_number	recolor=-1\n"
		"\n"
		":bad_number Bad\n"
		"	*		idle	noeat\n"
		"	\"0-9\"		bad_number\n"
		"\n"
		":octal Constant\n"
		"	*		idle	noeat\n"
		"	\"0-7\"		octal\n"
		"	\"89\"		bad_number	recolor=-1\n"
		"\n"
		":hex Constant\n"
		"	*		idle	noeat\n"
		"	\"0-9A-Fa-f\"	hex\n"
		"\n"
		":decimal Constant\n"
		"	*		idle	noeat\n"
		"	\"0-9\"		decimal\n"
		"	\"eE\"		epart\n"
		"	\".\"		float\n"
		"\n"
		":maybe_float Constant\n"
		"	*		idle	recolor=-2	noeat\n"
		"	\"0-9\"		float		recolor=-2\n"
		"\n"
		":float Constant\n"
		"	*		idle	noeat\n"
		"	\"eE\"		epart\n"
		"	\"0-9\"		float\n"
		"\n"
		":epart Constant\n"
		"	*		idle	noeat\n"
		"	\"0-9+\\-\"	enum\n"
		"\n"
		":enum Constant\n"
		"	*		idle	noeat\n"
		"	\"0-9\"		enum\n"
		"\n"
		":string	Constant\n"
		"	*		string\n"
		"	\"\\\"\"		idle\n"
		"	\"\\\\\"		string_escape	recolor=-1\n"
		"	\"%\"		string_control	recolor=-1\n"
		"\n"
		":string_escape Escape\n"
		"	*		string\n"
		"	\"x\"		string_hex1\n"
		"	\"0-7\"		string_octal2\n"
		"	\"\\n\"		string		recolor=-2\n"
		"\n"
		":string_hex1 Escape\n"
		"	*		string		noeat\n"
		"	\"0-9a-fA-F\"	string_hex2\n"
		"\n"
		":string_hex2 Escape\n"
		"	*		string		noeat\n"
		"	\"0-9a-fA-F\"	string\n"
		"\n"
		":string_octal2 Escape\n"
		"	*		string		noeat\n"
		"	\"0-7\"		string_octal3\n"
		"\n"
		":string_octal3 Escape\n"
		"	*		string		noeat\n"
		"	\"0-7\"		string\n"
		"\n"
		":string_control Escape\n"
		"	*		string\n"
		"	\"\\\"\"		string noeat\n"
		"	\"\\n\"		reset\n"
		"	\"0-9.\\-+ #hjILtz$\"	string_control\n"
		"\n"
		":char Constant\n"
		"	*		char\n"
		"	\"\\n\"		reset\n"
		"	\"'\"		idle\n"
		"	\"\\\\\"		char_escape	recolor=-1\n"
		"\n"
		":char_escape	Escape\n"
		"	*		char\n"
		"	\"x\"		char_hex1\n"
		"	\"0-7\"		char_octal2\n"
		"	\"\\n\"		char		recolor=-2\n"
		"\n"
		":char_hex1 Escape\n"
		"	*		char		noeat\n"
		"	\"0-9a-fA-F\"	char_hex2\n"
		"\n"
		":char_hex2 Escape\n"
		"	*		char		noeat\n"
		"	\"0-9a-fA-F\"	char\n"
		"\n"
		":char_octal2 Escape\n"
		"	*		char		noeat\n"
		"	\"0-7\"		char_octal3\n"
		"\n"
		":char_octal3 Escape\n"
		"	*		char		noeat\n"
		"	\"0-7\"		char\n"
		"\n"
		":ident Idle\n"
		"	*		idle		noeat strings\n"
		"	\"int\"		type\n"
		"	\"float\"		type\n"
		"	\"long\"		type\n"
		"	\"short\"		type\n"
		"	\"char\"		type\n"
		"	\"double\"	type\n"
		"	\"signed\"	type\n"
		"	\"unsigned\"	type\n"
		"	\"void\"		type\n"
		"	\"static\"	type\n"
		"	\"register\"	type\n"
		"	\"extern\"	type\n"
		"	\"inline\"	type\n"
		"	\"auto\"		type\n"
		"	\"const\"		type\n"
		"	\"volatile\"	type\n"
		"	\"if\"		kw\n"
		"	\"else\"		kw\n"
		"	\"while\"		kw\n"
		"	\"for\"		kw\n"
		"	\"break\"		kw\n"
		"	\"continue\"	kw\n"
		"	\"do\"		kw\n"
		"	\"case\"		kw\n"
		"	\"default\"	kw\n"
		"	\"switch\"	kw\n"
		"	\"goto\"		kw\n"
		"	\"struct\"	kw\n"
		"	\"enum\"		kw\n"
		"	\"return\"	kw\n"
		"	\"sizeof\"	kw\n"
		"	\"typedef\"	kw\n"
		"	\"union\"		kw\n"
		"	\"asm\"		kw\n"
		"	\"class\"		cppkw\n"
		"	\"public\"	cppkw\n"
		"	\"private\"	cppkw\n"
		"	\"protected\"	cppkw\n"
		"	\"friend\"	cppkw\n"
		"	\"new\"		cppkw\n"
		"	\"delete\"	cppkw\n"
		"	\"bool\"		cppkw\n"
		"	\"namespace\"	cppkw\n"
		"	\"operator\"	cppkw\n"
		"	\"template\"	cppkw\n"
		"	\"catch\"		cppkw\n"
		"	\"throw\"		cppkw\n"
		"	\"try\"		cppkw\n"
		"	\"typeof\"	cppkw\n"
		"done\n"
		"	\"a-zA-Z0-9_\"	ident\n"
		"\n"
		":type Type\n"
		"	*	idle	noeat\n"
		"\n"
		":kw Keyword\n"
		"	*	idle	noeat\n"
		"\n"
		":cppkw CppKeyword\n"
		"	*	idle	noeat\n"
,	NULL
};

