package net.sf.fmj.media.rtp;

import java.io.*;

public class RTCPAPPPacket extends RTCPPacket
{
    int ssrc;
    int name;
    int subtype;
    byte data[];

    public RTCPAPPPacket(int ssrc, int name, int subtype, byte data[])
    {
        this.ssrc = ssrc;
        this.name = name;
        this.subtype = subtype;
        this.data = data;
        super.type = 204;
        super.received = false;
        if ((data.length & 3) != 0)
            throw new IllegalArgumentException("Bad data length");
        if (subtype < 0 || subtype > 31)
            throw new IllegalArgumentException("Bad subtype");
        else
            return;
    }

    public RTCPAPPPacket(RTCPPacket parent)
    {
        super(parent);
        super.type = 204;
    }

    @Override
    void assemble(DataOutputStream out) throws IOException
    {
        out.writeByte(128 + subtype);
        out.writeByte(204);
        out.writeShort(2 + (data.length >> 2));
        out.writeInt(ssrc);
        out.writeInt(name);
        out.write(data);
    }

    @Override
    public int calcLength()
    {
        return 12 + data.length;
    }

    public String nameString(int name)
    {
        return "" + (char) (name >>> 24) + (char) (name >>> 16 & 0xff)
                + (char) (name >>> 8 & 0xff) + (char) (name & 0xff);
    }

    @Override
    public String toString()
    {
        return "\tRTCP APP Packet from SSRC " + ssrc + " with name "
                + nameString(name) + " and subtype " + subtype
                + "\n\tData (length " + data.length + "): " + new String(data)
                + "\n";
    }
}
