/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.parser.OutputFile;

final class NodeFiles {
    static final String nodeVersion = "4.1";
    static Set nodesGenerated = new HashSet();

    private NodeFiles() {
    }

    static void ensure(IO iO, String string) {
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".java");
        if (!string.equals("Node")) {
            if (string.equals("SimpleNode")) {
                NodeFiles.ensure(iO, "Node");
            } else {
                NodeFiles.ensure(iO, "SimpleNode");
            }
        }
        if (!string.equals("Node") && !JJTreeOptions.getBuildNodeFiles()) {
            return;
        }
        if (file.exists() && nodesGenerated.contains(file.getName())) {
            return;
        }
        try {
            String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY"};
            OutputFile outputFile = new OutputFile(file, nodeVersion, stringArray);
            outputFile.setToolName("JJTree");
            nodesGenerated.add(file.getName());
            if (!outputFile.needToWrite) {
                return;
            }
            if (string.equals("Node")) {
                NodeFiles.generateNode_java(outputFile);
            } else if (string.equals("SimpleNode")) {
                NodeFiles.generateSimpleNode_java(outputFile);
            } else {
                NodeFiles.generateMULTINode_java(outputFile, string);
            }
            outputFile.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    static void generatePrologue(PrintWriter printWriter) {
        if (!JJTreeGlobals.nodePackageName.equals("")) {
            printWriter.println("package " + JJTreeGlobals.nodePackageName + ";");
            printWriter.println();
            if (!JJTreeGlobals.nodePackageName.equals(JJTreeGlobals.packageName)) {
                printWriter.println("import " + JJTreeGlobals.packageName + ".*;");
                printWriter.println();
            }
        }
    }

    static String nodeConstants() {
        return JJTreeGlobals.parserName + "TreeConstants";
    }

    static void generateTreeConstants_java() {
        String string = NodeFiles.nodeConstants();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".java");
        try {
            String string2;
            int n;
            OutputFile outputFile = new OutputFile(file);
            PrintWriter printWriter = outputFile.getPrintWriter();
            Vector vector = ASTNodeDescriptor.getNodeIds();
            Vector vector2 = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(printWriter);
            printWriter.println("public interface " + string);
            printWriter.println("{");
            for (n = 0; n < vector.size(); ++n) {
                string2 = (String)vector.elementAt(n);
                printWriter.println("  public int " + string2 + " = " + n + ";");
            }
            printWriter.println();
            printWriter.println();
            printWriter.println("  public String[] jjtNodeName = {");
            for (n = 0; n < vector2.size(); ++n) {
                string2 = (String)vector2.elementAt(n);
                printWriter.println("    \"" + string2 + "\",");
            }
            printWriter.println("  };");
            printWriter.println("}");
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    static String visitorClass() {
        return JJTreeGlobals.parserName + "Visitor";
    }

    static void generateVisitor_java() {
        if (!JJTreeOptions.getVisitor()) {
            return;
        }
        String string = NodeFiles.visitorClass();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".java");
        try {
            OutputFile outputFile = new OutputFile(file);
            PrintWriter printWriter = outputFile.getPrintWriter();
            Vector vector = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(printWriter);
            printWriter.println("public interface " + string);
            printWriter.println("{");
            String string2 = NodeFiles.mergeVisitorException();
            String string3 = "Object";
            if (!JJTreeOptions.getVisitorDataType().equals("")) {
                string3 = JJTreeOptions.getVisitorDataType();
            }
            printWriter.println("  public " + JJTreeOptions.getVisitorReturnType() + " visit(SimpleNode node, " + string3 + " data)" + string2 + ";");
            if (JJTreeOptions.getMulti()) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string4 = (String)vector.elementAt(i);
                    if (string4.equals("void")) continue;
                    String string5 = JJTreeOptions.getNodePrefix() + string4;
                    printWriter.println("  public " + JJTreeOptions.getVisitorReturnType() + " visit(" + string5 + " node, " + string3 + " data)" + string2 + ";");
                }
            }
            printWriter.println("}");
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    private static String mergeVisitorException() {
        String string = JJTreeOptions.getVisitorException();
        if (!"".equals(string)) {
            string = " throws " + string;
        }
        return string;
    }

    private static void generateNode_java(OutputFile outputFile) throws IOException {
        PrintWriter printWriter = outputFile.getPrintWriter();
        NodeFiles.generatePrologue(printWriter);
        printWriter.println("/* All AST nodes must implement this interface.  It provides basic");
        printWriter.println("   machinery for constructing the parent and child relationships");
        printWriter.println("   between nodes. */");
        printWriter.println("");
        printWriter.println("public interface Node {");
        printWriter.println("");
        printWriter.println("  /** This method is called after the node has been made the current");
        printWriter.println("    node.  It indicates that child nodes can now be added to it. */");
        printWriter.println("  public void jjtOpen();");
        printWriter.println("");
        printWriter.println("  /** This method is called after all the child nodes have been");
        printWriter.println("    added. */");
        printWriter.println("  public void jjtClose();");
        printWriter.println("");
        printWriter.println("  /** This pair of methods are used to inform the node of its");
        printWriter.println("    parent. */");
        printWriter.println("  public void jjtSetParent(Node n);");
        printWriter.println("  public Node jjtGetParent();");
        printWriter.println("");
        printWriter.println("  /** This method tells the node to add its argument to the node's");
        printWriter.println("    list of children.  */");
        printWriter.println("  public void jjtAddChild(Node n, int i);");
        printWriter.println("");
        printWriter.println("  /** This method returns a child node.  The children are numbered");
        printWriter.println("     from zero, left to right. */");
        printWriter.println("  public Node jjtGetChild(int i);");
        printWriter.println("");
        printWriter.println("  /** Return the number of children the node has. */");
        printWriter.println("  public int jjtGetNumChildren();");
        if (JJTreeOptions.getVisitor()) {
            String string = "Object";
            if (!JJTreeOptions.getVisitorDataType().equals("")) {
                string = JJTreeOptions.getVisitorDataType();
            }
            printWriter.println("");
            printWriter.println("  /** Accept the visitor. **/");
            printWriter.println("  public " + JJTreeOptions.getVisitorReturnType() + " jjtAccept(" + NodeFiles.visitorClass() + " visitor, " + string + " data)" + NodeFiles.mergeVisitorException() + ";");
        }
        printWriter.println("}");
        printWriter.close();
    }

    private static void generateSimpleNode_java(OutputFile outputFile) throws IOException {
        PrintWriter printWriter = outputFile.getPrintWriter();
        NodeFiles.generatePrologue(printWriter);
        printWriter.print("public class SimpleNode");
        if (!JJTreeOptions.getNodeExtends().equals("")) {
            printWriter.print(" extends " + JJTreeOptions.getNodeExtends());
        }
        printWriter.println(" implements Node {");
        printWriter.println("  protected Node parent;");
        printWriter.println("  protected Node[] children;");
        printWriter.println("  protected int id;");
        printWriter.println("  protected Object value;");
        printWriter.println("  protected " + JJTreeGlobals.parserName + " parser;");
        if (JJTreeOptions.getTrackTokens()) {
            printWriter.println("  protected Token firstToken;");
            printWriter.println("  protected Token lastToken;");
        }
        printWriter.println("");
        printWriter.println("  public SimpleNode(int i) {");
        printWriter.println("    id = i;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  public SimpleNode(" + JJTreeGlobals.parserName + " p, int i) {");
        printWriter.println("    this(i);");
        printWriter.println("    parser = p;");
        printWriter.println("  }");
        printWriter.println("");
        if (JJTreeOptions.getNodeFactory().length() > 0) {
            printWriter.println("  public static Node jjtCreate(int id) {");
            printWriter.println("    return new SimpleNode(id);");
            printWriter.println("  }");
            printWriter.println("");
            printWriter.println("  public static Node jjtCreate(" + JJTreeGlobals.parserName + " p, int id) {");
            printWriter.println("    return new SimpleNode(p, id);");
            printWriter.println("  }");
            printWriter.println("");
        }
        printWriter.println("  public void jjtOpen() {");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  public void jjtClose() {");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  public void jjtSetParent(Node n) { parent = n; }");
        printWriter.println("  public Node jjtGetParent() { return parent; }");
        printWriter.println("");
        printWriter.println("  public void jjtAddChild(Node n, int i) {");
        printWriter.println("    if (children == null) {");
        printWriter.println("      children = new Node[i + 1];");
        printWriter.println("    } else if (i >= children.length) {");
        printWriter.println("      Node c[] = new Node[i + 1];");
        printWriter.println("      System.arraycopy(children, 0, c, 0, children.length);");
        printWriter.println("      children = c;");
        printWriter.println("    }");
        printWriter.println("    children[i] = n;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  public Node jjtGetChild(int i) {");
        printWriter.println("    return children[i];");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  public int jjtGetNumChildren() {");
        printWriter.println("    return (children == null) ? 0 : children.length;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  public void jjtSetValue(Object value) { this.value = value; }");
        printWriter.println("  public Object jjtGetValue() { return value; }");
        printWriter.println("");
        if (JJTreeOptions.getTrackTokens()) {
            printWriter.println("  public Token jjtGetFirstToken() { return firstToken; }");
            printWriter.println("  public void jjtSetFirstToken(Token token) { this.firstToken = token; }");
            printWriter.println("  public Token jjtGetLastToken() { return lastToken; }");
            printWriter.println("  public void jjtSetLastToken(Token token) { this.lastToken = token; }");
            printWriter.println("");
        }
        if (JJTreeOptions.getVisitor()) {
            String string = NodeFiles.mergeVisitorException();
            String string2 = "Object";
            if (!JJTreeOptions.getVisitorDataType().equals("")) {
                string2 = JJTreeOptions.getVisitorDataType();
            }
            printWriter.println("  /** Accept the visitor. **/");
            printWriter.println("  public " + JJTreeOptions.getVisitorReturnType() + " jjtAccept(" + NodeFiles.visitorClass() + " visitor, " + string2 + " data)" + string + " {");
            printWriter.println("    " + (JJTreeOptions.getVisitorReturnType().equals("void") ? "" : "return ") + "visitor.visit(this, data);");
            printWriter.println("  }");
            printWriter.println("");
            printWriter.println("  /** Accept the visitor. **/");
            printWriter.println("  public Object childrenAccept(" + NodeFiles.visitorClass() + " visitor, " + string2 + " data)" + string + " {");
            printWriter.println("    if (children != null) {");
            printWriter.println("      for (int i = 0; i < children.length; ++i) {");
            printWriter.println("        children[i].jjtAccept(visitor, data);");
            printWriter.println("      }");
            printWriter.println("    }");
            printWriter.println("    return data;");
            printWriter.println("  }");
            printWriter.println("");
        }
        printWriter.println("  /* You can override these two methods in subclasses of SimpleNode to");
        printWriter.println("     customize the way the node appears when the tree is dumped.  If");
        printWriter.println("     your output uses more than one line you should override");
        printWriter.println("     toString(String), otherwise overriding toString() is probably all");
        printWriter.println("     you need to do. */");
        printWriter.println("");
        printWriter.println("  public String toString() { return " + NodeFiles.nodeConstants() + ".jjtNodeName[id]; }");
        printWriter.println("  public String toString(String prefix) { return prefix + toString(); }");
        printWriter.println("");
        printWriter.println("  /* Override this method if you want to customize how the node dumps");
        printWriter.println("     out its children. */");
        printWriter.println("");
        printWriter.println("  public void dump(String prefix) {");
        printWriter.println("    System.out.println(toString(prefix));");
        printWriter.println("    if (children != null) {");
        printWriter.println("      for (int i = 0; i < children.length; ++i) {");
        printWriter.println("  SimpleNode n = (SimpleNode)children[i];");
        printWriter.println("  if (n != null) {");
        printWriter.println("    n.dump(prefix + \" \");");
        printWriter.println("  }");
        printWriter.println("      }");
        printWriter.println("    }");
        printWriter.println("  }");
        printWriter.println("}");
        printWriter.println("");
    }

    private static void generateMULTINode_java(OutputFile outputFile, String string) throws IOException {
        PrintWriter printWriter = outputFile.getPrintWriter();
        NodeFiles.generatePrologue(printWriter);
        if (JJTreeOptions.getNodeClass().length() > 0) {
            printWriter.println("public class " + string + " extends " + JJTreeOptions.getNodeClass() + "{");
        } else {
            printWriter.println("public class " + string + " extends SimpleNode {");
        }
        printWriter.println("  public " + string + "(int id) {");
        printWriter.println("    super(id);");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public " + string + "(" + JJTreeGlobals.parserName + " p, int id) {");
        printWriter.println("    super(p, id);");
        printWriter.println("  }");
        printWriter.println();
        if (JJTreeOptions.getNodeFactory().length() > 0) {
            printWriter.println("  public static Node jjtCreate(int id) {");
            printWriter.println("      return new " + string + "(id);");
            printWriter.println("  }");
            printWriter.println();
            printWriter.println("  public static Node jjtCreate(" + JJTreeGlobals.parserName + " p, int id) {");
            printWriter.println("      return new " + string + "(p, id);");
            printWriter.println("  }");
        }
        if (JJTreeOptions.getVisitor()) {
            String string2 = "Object";
            if (!JJTreeOptions.getVisitorDataType().equals("")) {
                string2 = JJTreeOptions.getVisitorDataType();
            }
            printWriter.println("");
            printWriter.println("  /** Accept the visitor. **/");
            printWriter.println("  public " + JJTreeOptions.getVisitorReturnType() + " jjtAccept(" + NodeFiles.visitorClass() + " visitor, " + string2 + " data)" + NodeFiles.mergeVisitorException() + " {");
            printWriter.println("    " + (JJTreeOptions.getVisitorReturnType().equals("void") ? "" : "return ") + "visitor.visit(this, data);");
            printWriter.println("  }");
        }
        printWriter.println("}");
        printWriter.close();
    }
}

