#!/bin/sh
set -e

TMPDIR=`mktemp -t -d jaspyt-cvs.XXXXXXXXXX` || exit 1
trap "rm -Rf $TMPDIR" 0
VERSION=$(dpkg-parsechangelog | grep '^Version:' | cut -f 2 -d ' ' | sed "s/-\(.*\)$//")

TAR=jasypt_$VERSION.orig.tar.gz
DIR=jasypt-$VERSION
TAG="jasypt-`echo $VERSION | tr . _`"
CVSROOT=":pserver:anonymous@jasypt.cvs.sourceforge.net:/cvsroot/jasypt"

echo "retrieving Jasypt sources tagged $TAG"
(cd $TMPDIR && cvs -d $CVSROOT export -d $DIR -r$TAG jasypt >/dev/null 2>&1)

echo "generating ../$TAR"
tar -C $TMPDIR -czf ../$TAR $DIR

