.\"                                      Hey, EMACS: -*- nroff -*-
.TH XC "1" "June 2021" "IRAF 2.17" "IRAF commands"
.SH NAME
xc \- portable IRAF compile/link utility
.SH SYNOPSIS
.B xc
.RI [ flags ] " files" ...

.SH DESCRIPTION
\fBXC\fP is a machine independent utility for compiling and linking
IRAF tasks or files.  The XC utility may also be used to compile
and/or link non-IRAF files and tasks. It can be used to generate
fortran from xpp or ratfor code, to compile any number of files, and
then link them if desired.  XC accepts and maps IRAF virtual
filenames, but since it is a standalone bootstrap utility the
environment is not passed, hence logical directories cannot be used.

It is suggested that everyone stick with the iraf virtual file name
extensions.  These are : .x, .r, .f, .c, .s, .o, .a, .e. The meaning
of these is:

.nf
     .x   SPP code
     .r   Ratfor code
     .f   Fortran code
     .c   C code
     .s   Macro assembler code
     .o   Object module
     .a   Library file
     .e   Executable Image
.fi

XC is available both in the CL and as
a standalone task.  Usage is equivalent in either case.

.SH FLAGS
.TP
.B -c
Tells \fBxc\fR not to link, i.e., not to create an executable.
.TP
.B -d
Causes debug messages to be printed during execution.
.TP
.B -F\fR,\fB -f
Do not delete the Fortran translation of an SPP source file.
.TP
.B -g
Generates debugging information .
.TP
.B -h
Causes the executable to be linked as a host program, i.e., without
the IRAF main and without searching the IRAF libraries, unless
explicitly referenced on the command line.  Used to compile and link
host (e.g., Fortran) programs which may or may not reference the IRAF
libraries.
.TP
.B -H
Link a host program as with "-h", but include the VOS libraries.
.TP
.B -A
Force architecture specific include files.
.TP
.B -C
Link a host program which has a C main.  We may need to tweak the
command line as a special case here since we normally assume Fortran
sources.
.TP
.B -/\fIflag\fR, \fB-//\fIfoo
Pass \fIflag\fR to host compiler without further
interpretation. "-/\fIflag\fR" becomes "-\fIfoo\fR", "-//\fIfoo\fR"
becomes "\fIfoo\fR".
.TP
.B -D\fIdefine
Pass a -D\fIdefine\fR flag on to the host compiler.
.TP
.B -I\fIdir
Pass a -I\fIdir\fR flag on to the host compiler.  A special case is
"-Inolibc" which disables automatic inclusion of the IRAF LIBC
includes (hlib$libc).
.TP
.B -l\fIlib\fR, \fB-L\fIdir\fR
This tells the linker which library files or library directories
besides the standard ones to include.  These must be either on the current
directory, or in an IRAF system library (lib$ or hlib$).
The library specification must be immediately after the option as in
"-lxtools".  No other option may follow the 'l' option in the same
argument as in -lxtoolsO.	
.TP
.B -N
Generates the output temp file in /tmp during the link, then moves it
to the output directory in one operation when done.  For cases such as
linking in an NFS-mounted directory, where all the NFS i/o may slow
the link down excessively.
.TP
.B -Nh \fR[\fIfilename\fR]
This tells xpp that the foreign definitions in the file specified
should be used in preference to standard include files.
.TP
.B -o
This flag redirects the output of the compile if used in conjunction
with \-c option or specifies where the executable or object is to be
placed.  If not given the first file name is used to obtain the name
for the executable or object.
.TP
.B -O
Optimize object code produced; this is now the default, but this
switch is still provided for backwards compatibility.
.TP
.B -p \fIpkgname
Load the package environment for the named external package, e.g., 
"xc \-c \-p noao file.x".  If the same package is always specified the
environment variable or logical name PKGENV may be defined at the host
level to accomplish the same thing.  The package name \fImust\fR be
specified when doing software development in an external or layered
package.
.TP
.B -q
Disable optimization.  Opposite of \-O.  Object code will be optimized
by default.
.TP
.B -s
Strips all symbols and debugging information.
.TP
.B -S
Same as \-s for VMS.
.TP
.B -v
Verbose mode.  Causes messages to be printed during execution telling
what the \fBxc\fR program is doing.
.TP
.B -w
Suppress warnings.                              
.TP
.B -z
Create a non-shareable image (default).
.TP
.B V
Print XC version identification.

.SH SEE ALSO
.BR mkpkg (1),
.BR generic (1).

.SH AUTHOR
This manual page was taken from the xc.hlp file in the IRAF sources.
