.\"
.\" ippserver man page.
.\"
.\" Copyright 2014-2017 by Apple Inc.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH ippserver 8 "ippsample" "14 September 2017" "Apple Inc."
.SH NAME
ippserver \- a simple ipp server
.SH SYNOPSIS
.B ippserver
[
.B \-2
] [
.B \-C
.I config-directory
] [
.B \-K
.I keypath
] [
.B \-M
.I manufacturer
] [
.B \-P
] [
.B \-a
.I attributes-file
] [
.B \-c
.I command
] [
.B \-d
.I spool-directory
] [
.B \-f
.I type/subtype[,...]
] [
.B \-h
] [
.B \-i
.I iconfile.png
] [
.B \-k
] [
.B \-l
.I location
] [
.B \-m
.I model
] [
.B \-n
.I hostname
] [
.B \-p
.I port
] [
.B \-r
.I subtype
] [
.B \-s
.I speed[,color-speed]
] [
.B \-u
.I username:password
] [
.B \-v[vvv]
]
.I "service name"
.SH DESCRIPTION
.B ippserver
is a simple Internet Printing Protocol (IPP) server conforming to the IPP Everywhere and IPP Shared Infrastructure Extensions (INFRA) specifications. It can be used as a standalone print server and/or a very basic infrastructure server between standard IPP clients and IPP proxies conforming to the INFRA specification.
.SH OPTIONS
The following options are recognized by
.B ippserver:
.TP 5
\fB\-2\fR
Specifies that the printer supports two-sided printing.
.TP 5
\fB\-C \fIconfig-directory\fR
Specifies the location of a directory containing files that define the configuration of the server and the service instances that are available.
See the section titled "CONFIGURATION DIRECTORIES" below.
.TP 5
\fB\-K \fIkeypath\fR
Specifies the location of TLS certificates and private keys.
.TP 5
\fB\-M \fImanufacturer\fR
Specifies the manufacturer for the printer.
.TP 5
\fB\-P\fR
Specifies that the printer will require a PIN ("job-password") for submitted print jobs.
.TP 5
\fB\-a \fIattributes-file\fR
Specifies a file containing attribute definitions for the printer.
.TP 5
\fB\-c \fIcommand\fR
Specifies a command that is used to process job files.
.TP 5
\fB\-d \fIspool-directory\fR
Specifies the directory that will hold the print files.
The default is a directory under the user's current temporary directory.
.TP 5
\fB\-f \fItype/subtype,[...]\fR
Specifies the list of supported MIME media types.
.TP 5
.B \-h
Shows program help.
.TP 5
\fB\-i \fIiconfile.png\fR
Specifies a PNG file for the printer icon.
.TP 5
.B \-k
Keeps the print documents in the spool directory rather than deleting them.
.TP 5
\fB\-l \fIlocation\fR
Specifies the "printer-location" string for the printer.
.TP 5
\fB\-m \fImodel\fR
Specifies the model name of the printer.
.TP 5
\fB\-n \fIhostname\fR
Specifies the hostname that is reported by the server.
The default is the name returned by the
.BR hostname (1)
command.
.TP 5
\fB\-p \fIport\fR
Specifies the port number to listen on.
The default is a user-specific number from 8000 to 8999.
.TP 5
\fB\-r \fIsubtype\fR
Specifies the Bonjour subtype to advertise for the printer.
The default subtype is "_print".
.TP 5
\fB\-s \fIspeed[,color-speed]\fR
Specifies the printer speed in pages-per-minute.
.TP 5
\fB\-u \fIusername:password\fR
Specifies the username and password for the IPP proxy.
.TP 5
.B \-v[vvv]
Be (very) verbose when logging activity to the standard output.
.SH EXIT STATUS
The
.B ippserver
program returns 1 if it is unable to process the command-line arguments.
Otherwise
.B ippserver
will run continuously until terminated.
.SH EXAMPLES
Run
.B ippserver
with a service name of My Cool Printer:
.nf

    ippserver "My Cool Printer"
.fi
.LP
Specify a proxy username of "foo" and password of "bar":
.nf

    ippserver \-u foo:bar "My Cool Printer"
.fi
.SH CONFIGURATION DIRECTORIES
When the \fB\-C\fR option is specified, \fBippserver\fR reads a series of configuration files from the specified directory to configure the server and services supported by the server.
.SS SYSTEM.CONF CONFIGURATION FILE
The \fIsystem.conf\fR configuration file specifies settings that apply to all services.
Each line consists of a directive followed by its value(s).
Comments start with the # character and continue to the end of the line.
The following directives are supported:
.TP 5
\fBDataDirectory \fIdirectory\fR
Specifies the location of server data files.
.TP 5
\fBDefaultPrinter \fIname\fR
Specifies the default print service name.
.TP 5
\fBEncryption \fI{Always|IfRequested|Never|Required}\fR
Specifies when to use TLS encryption for client connections.
"Always" means that all connections are encrypted when established (HTTPS).
"IfRequested" means that connections are encrypted when an upgrade is requested by the client.
"Never" means that encryption is not allowed or supported.
"Required" means that all connections are encrypted, either when established (HTTPS) or immediately thereafter using HTTP Upgrade.
.TP 5
\fBKeepFiles \fI{No|Yes}\fR
Specifies whether job data files are retained after processing.
.TP 5
\fBListen \fIaddress[:port]\fR
Listens for client connections on the specified address and port.
If the address is "*" the server will listen for connections on all network interfaces.
If the port is omitted, a port between 8000 and 8999 will be used.
.TP 5
\fBLogFile \fIpath\fR
Specifies a log file to use.
The path "stderr" causes all log messages to be directed to the standard error file descriptor.
.TP 5
\fBLogLevel \fI{Debug|Info|Error}\fR
Specifies the verbosity of logged messages.
"Debug" is the most verbose level, logging all messages.
"Info" provides basic progress and status messages.
"Error" provides only error messages.
.TP 5
\fBMaxCompletedJobs \fInumber\fR
Specifies the maximum number of completed jobs that are retained for job history.
The value 0 specifies there is no limit.
Note: \fBippserver\fR currently removes completed jobs from the job history after 60 seconds.
.TP 5
\fBMaxJobs \fInumber\fR
Specifies the maximum number of pending and active jobs that can be queued at any given time.
The value 0 specifies there is no limit.
.TP 5
\fBSpoolDirectory \fIpath\fR
Specifies the location of print job spool files.
.SS PRINT SERVICE CONFIGURATION FILES
Each 2D print service is configured by a \fIprint/name.conf\fR configuration file, where "name" is the name of the service in the printer URI, e.g., "ipps://hostname/ipp/print/name".
Each 3D print service is configured by a \fIprint3d/name.conf\fR configuration file, where "name" is the name of the service in the printer URI, e.g., "ipps://hostname/ipp/print3d/name".
Each line consists of a directive followed by its value(s).
Comments start with the # character and continue to the end of the line.
The following directives are supported:
.TP 5
\fBAttr \fIvalue-tag name value(s)\fR
Specifies a Printer Description attribute.
The format is further defined in
.BR ipptoolfile (7).
.TP 5
\fBAuthType \fI{None|Basic}\fR
Specifies the type of authentication to require.
"None" specifies that no authentication is required.
"Basic" specifies that HTTP Basic authentication (username + password) is required.
.TP 5
\fBCommand \fIcommand\fR
Specifies the command to run when processing jobs.
The
.BR ipptransform (1)
command can be used for many printers.
.TP 5
\fBDeviceURI \fIuri\fR
Specifies the printer's device URI.
.TP 5
\fBMake \fImanufacturer\fR
Specifies the manufacturer name for the printer.
.TP 5
\fBModel \fImodel\fR
Specifies the model for the printer.
.TP 5
\fBProxyUser \fIuser\fR
Specifies the name of the proxy user for the printer.
.SS PRINT SERVICE ICON FILES
The icon for each 2D print service is stored in the \fIprint/name.png\fR  file. Similarly, the icon for each 3D print service is stored in the \fIprint3d/name.png\fR file.
.SH SEE ALSO
ISTO PWG Internet Printing Protocol Workgroup (http://www.pwg.org/ipp)
.SH COPYRIGHT
Copyright \[co] 2007-2016 by Apple Inc.
