## Unreleased changes

## 2.8.2.3

* Require extensions in a more friendly manner. [#1030](https://github.com/yesodweb/persistent/pull/1030)
* Specify a strategy for all deriving clauses, which avoids the `-Wmissing-deriving-strategy` warning introduced in GHC 8.8.2. [#1030](https://github.com/yesodweb/persistent/pull/1030)

## 2.8.2.2

* Fix the `mkPersist` function to not require importing the classes explicitly. [#1027](https://github.com/yesodweb/persistent/pull/1027)

## 2.8.2.1

* Fix the test-suite for persistent-template. [#1023](https://github.com/yesodweb/persistent/pull/1023)

## 2.8.2

* Add `fieldError` to the export list of `Database.Persist.TH` [#1008](https://github.com/yesodweb/persistent/pull/1008)

## 2.8.1

* Let the user pass instances that will be derived for record and for key types (https://github.com/yesodweb/persistent/pull/990

## 2.8.0.1

* Small optimization/code cleanup to generated Template Haskell code size, by slimming the implementation of to/fromPersistValue for Entities. [#1014](https://github.com/yesodweb/persistent/pull/1014)

## 2.8.0

* Reduces the amount of code generated by Template Haskell. The amount of code generated for a certain function was O(N^2) with respect to the number of fields on a given Entity. This change shows dramatic improvements in benchmarks for compiling Persistent models. [#]()
* Drops support for GHC 8.0, so that `DerivingStrategies` can be used by `persistent-template`
* `persistent-template` now requires `DerivingStrategies`, `GeneralizedNewtypeDeriving`, and `StandaloneDeriving` to be enabled in the file where Persistent entities are created
* Fixes a long-standing issue where persistent-template would fail when `DeriveAnyClass` was enabled (See #578)
* [#1002](https://github.com/yesodweb/persistent/pull/1002)

## 2.7.4

* Remove an overlapping instance for `Lift a`. [#998](https://github.com/yesodweb/persistent/pull/998)

## 2.7.3

* Update module documentation for `Database.Persist.TH` to better describe the purpose of the module [#968](https://github.com/yesodweb/persistent/pull/968)
* Support template-haskell-2.15 [#959](https://github.com/yesodweb/persistent/pull/959)

## 2.7.2

* Expose the knot tying logic of `parseReferences` so that users can build
  migrations from independently define entities at runtime [#932](https://github.com/yesodweb/persistent/pull/932)

## 2.7.1

* Add the `mkEntityDefList` function to work around [#902](https://github.com/yesodweb/persistent/issues/902). [#904](https://github.com/yesodweb/persistent/pull/904)

## 2.7.0

* Depends on `persistent-2.10.0` which provides the `OnlyOneUniqueKey` and `AtLeastOneUniqueKey` classes. Automatically generates instances for these classes based on how many unique keys the entity definition gets. This changes requires `UndecidableInstances` to be enabled on each module that generates entity definitions. [#885](https://github.com/yesodweb/persistent/pull/885)
* Removed deprecated `sqlOnlySettings`. Please use `sqlSettings` instead. [#894](https://github.com/yesodweb/persistent/pull/894)

## 2.6.0
* [persistent#846](https://github.com/yesodweb/persistent/pull/846): Improve error message when marshalling fails
* [persistent#826](https://github.com/yesodweb/persistent/pull/826): Change `Unique` derive `Show`

## 2.5.4

* [persistent#778](https://github.com/yesodweb/persistent/issues/778): Add `persistManyFileWith`.

## 2.5.3.1

* Slight improvement to the error message when a Persistent field can't be parsed from database results

## 2.5.3

* Exposed `parseReferences` to allow custom QuasiQuoters

## 2.5.2

* Fix incorrect `ToJSON`/`FromJSON` instance generation for generic
  backends

## 2.5.1.6

Allow non-null self-references in a list

## 2.5.1.4

* Allow composite Primary keys for tables that contain nullable fields.
* Support foreign keys to non-integer ids

## 2.5.1.3

* fix GHC 7.8 bug when a field name is "type"

## 2.5.1.2

* fix a bad Eq instance /= definition for Key when mpsGenetric=True

## 2.5.0.1

* workaround TH bug in GHC 7.10

## 2.5

* read/write typeclass split

## 2.1.6

* aeson 0.11
* transformers 0.5
## 2.1.4

support http-api-data for url serialization

## 2.1.3.3

By default explicitly use Int64 for foreign key references.
This avoids confusion on a 32 bit system.

## 2.1.3.1

Support foreign key references to composite primary keys

## 2.1.0.1

Support for monad-control 1.0
