-- Can we do operations on i16s, even though these are not natively supported?
-- ==
--
-- input  {
--   [0i16, 0i16, 0i16, 0i16, 0i16]
--   [1i16, 1i16, 1i16, 1i16, 1i16]
--   [1i16, 1i16, 1i16, 1i16, 1i16]
-- }
-- output {
--   [0i16, 5i16, 0i16, 0i16, 0i16]
-- }
--
-- input  {
--   [0i16, 0i16, 0i16, 0i16, 0i16]
--   [0i16, 0i16, 0i16, 0i16, 1i16]
--   [1i16, 1i16, 1i16, 1i16, 1i16]
-- }
-- output {
--   [4i16, 1i16, 0i16, 0i16, 0i16]
-- }
--
-- input  {
--   [0i16, 0i16, 0i16, 0i16, 0i16]
--   [1i16, 1i16, 4i16, 4i16, 4i16]
--   [1i16, 1i16, 4i16, 4i16, 4i16]
-- }
-- output {
--   [0i16, 2i16, 0i16, 0i16, 12i16]
-- }
--
-- input  {
--   [1i16, 2i16, 3i16, 4i16, 5i16]
--   [1i16, 1i16, 4i16, 4i16, 4i16]
--   [1i16, 1i16, 4i16, 4i16, 4i16]
-- }
-- output {
--   [1i16, 4i16, 3i16, 4i16, 17i16]
-- }
--
-- input  {
--   [1i16, 1i16, 3i16, 4i16, 5i16]
--   [1i16, 1i16, 0i16, 0i16, 4i16]
--   [-1i16, 1i16, -1i16, 4i16, 4i16]
-- }
-- output {
--   [4i16, 1i16, 3i16, 4i16, 9i16]
-- }

def main [m] [n] (hist: *[n]i16) (is: [m]i16) (image: [m]i16) : [n]i16 =
  reduce_by_index hist (+) 0i16 (map i64.i16 is) image
