//
// C++ Implementation: initaksmode
//
// Description: 
//
//
// Author: Spiros Georgaras <sng@hellug.gr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "initaskmode.h"
// #include "settings.h"

#include <klocale.h>
#include <QtGui/QDialog>


// gWen::gWen(QDialog *)
initaskMode::initaskMode(QDialog* )
	:QDialog()
{
	setupUi(this);
	setWindowTitle(i18n("Mode selection")+" - GwenRename");
}



initaskMode::initaskMode(QDialog* , iconload* ic,  QString folder)
	:QDialog()
{
	setupUi(this);
	setWindowTitle(i18n("Mode selection")+" - GwenRename");
	pix->setPixmap(ic->Icon(0));
	renameDir->setIcon(KIcon(ic->Icon(1)));
	renameFiles->setIcon(KIcon(ic->Icon(5)));
	buttonCancel->setIcon(KIcon(ic->Icon(4)));
	Message->setText(QString(i18n("<p>The folder <b>%1</b> is the only parameter passed to <b>GwenRename</b>.<br><br>Do you want to rename this folder, or the files contained in it?</p>")).arg(folder));
}


initaskMode::~initaskMode(){
}


int initaskMode::Result(){
    return mResult;
}


void initaskMode::renameFilesClicked(){
    mResult=1;
    accept();
}


void initaskMode::renameDirClicked(){
    mResult=2;
    accept();
}


void initaskMode::setFolder(QString folder){
	Message->setText(QString(i18n("<p>The folder <b>%1</b> is the only parameter passed to <b>GwenRename</b>.<br><br>Do you want to rename this folder, or the files contained in it?</p>")).arg(folder));
}


void initaskMode::showHelp(){
		KRun::runCommand(QString("khelpcenter \"help:/gwenrename/using-GwenRename.html#mode-selection\""),this);
		
		

// 		KURL url(QString("mailto:sng@hellug.gr?subject=GwenRename selection error&body=I have just stumbled to this error\n\nError Code = %1").arg(theErrorMessage));
// 		new KRun(url);
}


void initaskMode::keyPressEvent( QKeyEvent *e ){
	e->accept();
// 	if(e->key()==Qt::Key_F1 && e->state()==Qt::NoButton) old impl
	if(e->key()==Qt::Key_F1 && e->modifiers()==Qt::NoModifier)
		showHelp();
// 	else if(e->key()==Qt::Key_Escape && e->state()==Qt::NoButton) old impl
	else if(e->key()==Qt::Key_Escape && e->modifiers()==Qt::NoModifier)
		reject();
}


void initaskMode::resizeEvent ( QResizeEvent *e ){
	setMaximumHeight(height());
	e->accept();
}


#include "initaskmode.moc"