#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXArray.h"
#include "FXHash.h"
#include "FXStream.h"
#include "FXTextCodec.h"
#include "FXCP1258Codec.h"

namespace FX {

FXIMPLEMENT(FXCP1258Codec,FXTextCodec,nullptr,0)


//// Created by codec tool on 03/25/2005 from: CP1258.TXT ////
static const unsigned short forward_data[256]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   8364, 65533, 8218, 402,  8222, 8230, 8224, 8225, 710,  8240, 65533, 8249, 338,  65533, 65533, 65533,
   65533, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732,  8482, 65533, 8250, 339,  65533, 65533, 376,
   160,  161,  162,  163,  164,  165,  166,  167,  168,  169,  170,  171,  172,  173,  174,  175,
   176,  177,  178,  179,  180,  181,  182,  183,  184,  185,  186,  187,  188,  189,  190,  191,
   192,  193,  194,  258,  196,  197,  198,  199,  200,  201,  202,  203,  768,  205,  206,  207,
   272,  209,  777,  211,  212,  416,  214,  215,  216,  217,  218,  219,  220,  431,  771,  223,
   224,  225,  226,  259,  228,  229,  230,  231,  232,  233,  234,  235,  769,  237,  238,  239,
   273,  241,  803,  243,  244,  417,  246,  247,  248,  249,  250,  251,  252,  432,  8363, 255,
  };


static const unsigned char reverse_plane[17]={
  0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
  };

static const unsigned char reverse_pages[73]={
  0,  51, 51, 51, 51, 51, 51, 51, 114,51, 51, 51, 51, 51, 51, 51,
  51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
  51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
  51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
  51, 51, 51, 51, 51, 51, 51, 51, 51,
  };

static const unsigned short reverse_block[178]={
  0,   16,  32,  48,  64,  80,  96,  112, 128, 128, 144, 160, 176, 192, 208, 224,
  240, 256, 128, 128, 128, 270, 128, 278, 128, 292, 308, 324, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 334, 341, 128, 128,
  357, 128, 370, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 383, 399, 415, 128, 128, 128, 128, 128, 128, 426, 128, 128, 128,
  128, 128, 128, 128, 440, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128,
  };

static const unsigned char reverse_data[456]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   160,  161,  162,  163,  164,  165,  166,  167,  168,  169,  170,  171,  172,  173,  174,  175,
   176,  177,  178,  179,  180,  181,  182,  183,  184,  185,  186,  187,  188,  189,  190,  191,
   192,  193,  194,  26,   196,  197,  198,  199,  200,  201,  202,  203,  26,   205,  206,  207,
   26,   209,  26,   211,  212,  26,   214,  215,  216,  217,  218,  219,  220,  26,   26,   223,
   224,  225,  226,  26,   228,  229,  230,  231,  232,  233,  234,  235,  26,   237,  238,  239,
   26,   241,  26,   243,  244,  26,   246,  247,  248,  249,  250,  251,  252,  26,   26,   255,
   26,   26,   195,  227,  26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   208,  240,  26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   140,  156,  26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   159,  26,
   26,   26,   26,   26,   26,   26,   131,  26,   26,   26,   26,   26,   26,   26,   26,   26,
   26,   26,   26,   26,   213,  245,  26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   26,   26,   26,   221,  253,  26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   26,   26,   26,   26,   136,  26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   26,   152,  26,   26,   26,   204,  236,  26,   222,  26,   26,   26,   26,   26,   210,  26,
   26,   26,   26,   26,   26,   242,  26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   26,   26,   150,  151,  26,   26,   26,   145,  146,  130,  26,   147,  148,  132,  26,   134,
   135,  149,  26,   26,   26,   133,  26,   26,   26,   26,   26,   26,   26,   26,   26,   137,
   26,   26,   26,   26,   26,   26,   26,   26,   139,  155,  26,   26,   26,   26,   26,   26,
   26,   26,   26,   26,   26,   254,  128,  26,   26,   26,   153,  26,   26,   26,   26,   26,
   26,   26,   26,   26,   26,   26,   26,   26,
  };


FXint FXCP1258Codec::mb2wc(FXwchar& wc,const FXchar* src,FXint nsrc) const {
  if(nsrc<1) return -1;
  wc=forward_data[(FXuchar)src[0]];
  return 1;
  }


FXint FXCP1258Codec::wc2mb(FXchar* dst,FXint ndst,FXwchar wc) const {
  if(ndst<1) return -1;
  dst[0]=reverse_data[reverse_block[reverse_pages[reverse_plane[wc>>16]+((wc>>10)&63)]+((wc>>4)&63)]+(wc&15)];
  return 1;
  }

FXint FXCP1258Codec::mibEnum() const {
  return 2258;
  }


const FXchar* FXCP1258Codec::name() const {
  return "windows-1258";
  }


const FXchar* FXCP1258Codec::mimeName() const {
  return "windows-1258";
  }


const FXchar* const* FXCP1258Codec::aliases() const {
  static const FXchar *const list[]={"microsoft-cp1258","windows-1258","cp1258",nullptr};
  return list;
  }

}

