/* puzzle.c generated by valac 0.39.92.14-46f76, the Vala compiler
 * generated from puzzle.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*
  1   2   4

  8   *   16

  32  64  128
*/


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
typedef struct _PuzzlePrivate PuzzlePrivate;
enum  {
	PUZZLE_0_PROPERTY,
	PUZZLE_NUM_PROPERTIES
};
static GParamSpec* puzzle_properties[PUZZLE_NUM_PROPERTIES];
enum  {
	PUZZLE_CHANGED_SIGNAL,
	PUZZLE_MOVED_SIGNAL,
	PUZZLE_NUM_SIGNALS
};
static guint puzzle_signals[PUZZLE_NUM_SIGNALS] = {0};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};


static gpointer puzzle_parent_class = NULL;

GType puzzle_get_type (void) G_GNUC_CONST;
Puzzle* puzzle_new (gint width,
                    gint height,
                    const gchar* data);
Puzzle* puzzle_construct (GType object_type,
                          gint width,
                          gint height,
                          const gchar* data);
static gchar* _vala_array_dup1 (gchar* self,
                         int length);
static gchar* _vala_array_dup2 (gchar* self,
                         int length);
static void puzzle_set_piece_id (Puzzle* self,
                          gchar* src,
                          int src_length1,
                          gint x,
                          gint y,
                          gchar id);
static gchar* _vala_array_dup3 (gchar* self,
                         int length);
static gchar* _vala_array_dup4 (gchar* self,
                         int length);
gchar puzzle_get_piece_id (Puzzle* self,
                           gchar* src,
                           int src_length1,
                           gint x,
                           gint y);
gint puzzle_get_piece_nr (Puzzle* self,
                          gint x,
                          gint y);
gboolean puzzle_game_over (Puzzle* self);
gboolean puzzle_mapcmp (Puzzle* self,
                        gchar* m1,
                        int m1_length1,
                        gchar* m2,
                        int m2_length1);
gboolean puzzle_movable (Puzzle* self,
                         gint id);
gboolean puzzle_move_piece (Puzzle* self,
                            gchar id,
                            gint x1,
                            gint y1,
                            gint x2,
                            gint y2);
static gboolean puzzle_check_valid_move (Puzzle* self,
                                  gint id,
                                  gint dx,
                                  gint dy);
static gboolean puzzle_do_move_piece (Puzzle* self,
                               gchar id,
                               gint dx,
                               gint dy);
static gchar* _vala_array_dup5 (gchar* self,
                         int length);
static gchar* _vala_array_dup6 (gchar* self,
                         int length);
static void puzzle_finalize (GObject * obj);

const gint image_map[110] = {0, 0, 64, 1, 66, 2, 2, 3, 16, 4, 24, 5, 8, 6, 208, 7, 248, 8, 104, 9, 214, 10, 255, 11, 107, 12, 22, 13, 31, 14, 11, 15, 18, 16, 10, 17, 80, 18, 72, 19, 56, 5, 152, 5, 70, 2, 67, 2, 194, 2, 98, 2, 9, 6, 20, 4, 144, 4, 3, 3, 40, 6, 25, 5, 28, 5, 96, 1, 19, 16, 201, 19, 146, 16, 198, 2, 84, 18, 46, 17, 112, 18, 6, 3, 184, 5, 192, 1, 147, 16, 73, 19, 42, 17, 200, 19, 99, 2, 116, 18, 29, 5, 14, 17, 26, 25, 224, 1, -1, -1};

static gchar*
_vala_array_dup1 (gchar* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gchar));
}


static gchar*
_vala_array_dup2 (gchar* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gchar));
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gchar*
_vala_array_dup3 (gchar* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gchar));
}


static gchar*
_vala_array_dup4 (gchar* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gchar));
}


Puzzle*
puzzle_construct (GType object_type,
                  gint width,
                  gint height,
                  const gchar* data)
{
	Puzzle * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gint _tmp19__length1;
	self = (Puzzle*) g_object_new (object_type, NULL);
	self->width = width;
	self->height = height;
	_tmp0_ = g_new0 (gchar, (width + 2) * (height + 2));
	self->map = (g_free (self->map), NULL);
	self->map = _tmp0_;
	self->map_length1 = (width + 2) * (height + 2);
	_tmp1_ = self->map;
	_tmp1__length1 = self->map_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	self->move_map = (g_free (self->move_map), NULL);
	self->move_map = _tmp2_;
	self->move_map_length1 = _tmp2__length1;
	_tmp3_ = self->map;
	_tmp3__length1 = self->map_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	self->undomove_map = (g_free (self->undomove_map), NULL);
	self->undomove_map = _tmp4_;
	self->undomove_map_length1 = _tmp4__length1;
	if (data != NULL) {
		gint i = 0;
		i = 0;
		{
			gint y = 0;
			y = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gint _tmp7_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = y;
						y = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = y;
					if (!(_tmp7_ < height)) {
						break;
					}
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp8_ = FALSE;
							_tmp8_ = TRUE;
							while (TRUE) {
								gint _tmp10_;
								gchar* _tmp11_;
								gint _tmp11__length1;
								gint _tmp12_;
								gint _tmp13_;
								gint _tmp14_;
								gint _tmp15_;
								if (!_tmp8_) {
									gint _tmp9_;
									_tmp9_ = x;
									x = _tmp9_ + 1;
								}
								_tmp8_ = FALSE;
								_tmp10_ = x;
								if (!(_tmp10_ < width)) {
									break;
								}
								_tmp11_ = self->map;
								_tmp11__length1 = self->map_length1;
								_tmp12_ = x;
								_tmp13_ = y;
								_tmp14_ = i;
								puzzle_set_piece_id (self, _tmp11_, _tmp11__length1, _tmp12_, _tmp13_, string_get (data, (glong) _tmp14_));
								_tmp15_ = i;
								i = _tmp15_ + 1;
							}
						}
					}
				}
			}
		}
	}
	_tmp16_ = self->map;
	_tmp16__length1 = self->map_length1;
	_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup3 (_tmp16_, _tmp16__length1) : ((gpointer) _tmp16_);
	_tmp17__length1 = _tmp16__length1;
	self->orig_map = (g_free (self->orig_map), NULL);
	self->orig_map = _tmp17_;
	self->orig_map_length1 = _tmp17__length1;
	_tmp18_ = self->map;
	_tmp18__length1 = self->map_length1;
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup4 (_tmp18_, _tmp18__length1) : ((gpointer) _tmp18_);
	_tmp19__length1 = _tmp18__length1;
	self->lastmove_map = (g_free (self->lastmove_map), NULL);
	self->lastmove_map = _tmp19_;
	self->lastmove_map_length1 = _tmp19__length1;
	return self;
}


Puzzle*
puzzle_new (gint width,
            gint height,
            const gchar* data)
{
	return puzzle_construct (TYPE_PUZZLE, width, height, data);
}


gchar
puzzle_get_piece_id (Puzzle* self,
                     gchar* src,
                     int src_length1,
                     gint x,
                     gint y)
{
	gchar result = '\0';
	gint _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = self->width;
	_tmp1_ = src[(x + 1) + ((y + 1) * (_tmp0_ + 2))];
	result = _tmp1_;
	return result;
}


static void
puzzle_set_piece_id (Puzzle* self,
                     gchar* src,
                     int src_length1,
                     gint x,
                     gint y,
                     gchar id)
{
	gint _tmp0_;
	gchar _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->width;
	src[(x + 1) + ((y + 1) * (_tmp0_ + 2))] = id;
	_tmp1_ = src[(x + 1) + ((y + 1) * (_tmp0_ + 2))];
}


gint
puzzle_get_piece_nr (Puzzle* self,
                     gint x,
                     gint y)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar c = '\0';
	gchar* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gchar _tmp4_;
	gchar _tmp5_;
	gchar _tmp6_;
	gchar _tmp7_;
	gint nr = 0;
	gchar* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	gchar _tmp10_;
	gchar _tmp11_;
	gchar* _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	gchar _tmp15_;
	gchar _tmp16_;
	gchar* _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_;
	gchar _tmp20_;
	gchar _tmp21_;
	gchar* _tmp23_;
	gint _tmp23__length1;
	gint _tmp24_;
	gchar _tmp25_;
	gchar _tmp26_;
	gchar* _tmp28_;
	gint _tmp28__length1;
	gint _tmp29_;
	gchar _tmp30_;
	gchar _tmp31_;
	gchar* _tmp33_;
	gint _tmp33__length1;
	gint _tmp34_;
	gchar _tmp35_;
	gchar _tmp36_;
	gchar* _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_;
	gchar _tmp40_;
	gchar _tmp41_;
	gchar* _tmp43_;
	gint _tmp43__length1;
	gint _tmp44_;
	gchar _tmp45_;
	gchar _tmp46_;
	gint i = 0;
	gint _tmp55_;
	gint _tmp56_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	x = _tmp0_ + 1;
	_tmp1_ = y;
	y = _tmp1_ + 1;
	_tmp2_ = self->map;
	_tmp2__length1 = self->map_length1;
	_tmp3_ = self->width;
	_tmp4_ = _tmp2_[x + (y * (_tmp3_ + 2))];
	c = _tmp4_;
	_tmp5_ = c;
	if (_tmp5_ == '-') {
		result = 23;
		return result;
	}
	_tmp6_ = c;
	if (_tmp6_ == ' ') {
		result = 21;
		return result;
	}
	_tmp7_ = c;
	if (_tmp7_ == '.') {
		result = 20;
		return result;
	}
	nr = 0;
	_tmp8_ = self->map;
	_tmp8__length1 = self->map_length1;
	_tmp9_ = self->width;
	_tmp10_ = _tmp8_[(x - 1) + ((y - 1) * (_tmp9_ + 2))];
	_tmp11_ = c;
	if (_tmp10_ == _tmp11_) {
		gint _tmp12_;
		_tmp12_ = nr;
		nr = _tmp12_ + 1;
	}
	_tmp13_ = self->map;
	_tmp13__length1 = self->map_length1;
	_tmp14_ = self->width;
	_tmp15_ = _tmp13_[(x - 0) + ((y - 1) * (_tmp14_ + 2))];
	_tmp16_ = c;
	if (_tmp15_ == _tmp16_) {
		gint _tmp17_;
		_tmp17_ = nr;
		nr = _tmp17_ + 2;
	}
	_tmp18_ = self->map;
	_tmp18__length1 = self->map_length1;
	_tmp19_ = self->width;
	_tmp20_ = _tmp18_[(x + 1) + ((y - 1) * (_tmp19_ + 2))];
	_tmp21_ = c;
	if (_tmp20_ == _tmp21_) {
		gint _tmp22_;
		_tmp22_ = nr;
		nr = _tmp22_ + 4;
	}
	_tmp23_ = self->map;
	_tmp23__length1 = self->map_length1;
	_tmp24_ = self->width;
	_tmp25_ = _tmp23_[(x - 1) + ((y - 0) * (_tmp24_ + 2))];
	_tmp26_ = c;
	if (_tmp25_ == _tmp26_) {
		gint _tmp27_;
		_tmp27_ = nr;
		nr = _tmp27_ + 8;
	}
	_tmp28_ = self->map;
	_tmp28__length1 = self->map_length1;
	_tmp29_ = self->width;
	_tmp30_ = _tmp28_[(x + 1) + ((y - 0) * (_tmp29_ + 2))];
	_tmp31_ = c;
	if (_tmp30_ == _tmp31_) {
		gint _tmp32_;
		_tmp32_ = nr;
		nr = _tmp32_ + 16;
	}
	_tmp33_ = self->map;
	_tmp33__length1 = self->map_length1;
	_tmp34_ = self->width;
	_tmp35_ = _tmp33_[(x - 1) + ((y + 1) * (_tmp34_ + 2))];
	_tmp36_ = c;
	if (_tmp35_ == _tmp36_) {
		gint _tmp37_;
		_tmp37_ = nr;
		nr = _tmp37_ + 32;
	}
	_tmp38_ = self->map;
	_tmp38__length1 = self->map_length1;
	_tmp39_ = self->width;
	_tmp40_ = _tmp38_[(x - 0) + ((y + 1) * (_tmp39_ + 2))];
	_tmp41_ = c;
	if (_tmp40_ == _tmp41_) {
		gint _tmp42_;
		_tmp42_ = nr;
		nr = _tmp42_ + 64;
	}
	_tmp43_ = self->map;
	_tmp43__length1 = self->map_length1;
	_tmp44_ = self->width;
	_tmp45_ = _tmp43_[(x + 1) + ((y + 1) * (_tmp44_ + 2))];
	_tmp46_ = c;
	if (_tmp45_ == _tmp46_) {
		gint _tmp47_;
		_tmp47_ = nr;
		nr = _tmp47_ + 128;
	}
	i = 0;
	while (TRUE) {
		gboolean _tmp48_ = FALSE;
		gint _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _tmp54_;
		_tmp49_ = nr;
		_tmp50_ = i;
		_tmp51_ = image_map[_tmp50_];
		if (_tmp49_ != _tmp51_) {
			gint _tmp52_;
			gint _tmp53_;
			_tmp52_ = i;
			_tmp53_ = image_map[_tmp52_];
			_tmp48_ = _tmp53_ != -1;
		} else {
			_tmp48_ = FALSE;
		}
		if (!_tmp48_) {
			break;
		}
		_tmp54_ = i;
		i = _tmp54_ + 2;
	}
	_tmp55_ = i;
	_tmp56_ = image_map[_tmp55_ + 1];
	result = _tmp56_;
	return result;
}


gboolean
puzzle_game_over (Puzzle* self)
{
	gboolean result = FALSE;
	gboolean over = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	over = TRUE;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = y;
				_tmp3_ = self->height;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gint _tmp7_;
							gboolean _tmp8_ = FALSE;
							gchar* _tmp9_;
							gint _tmp9__length1;
							gint _tmp10_;
							gint _tmp11_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = x;
								x = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = x;
							_tmp7_ = self->width;
							if (!(_tmp6_ < _tmp7_)) {
								break;
							}
							_tmp9_ = self->map;
							_tmp9__length1 = self->map_length1;
							_tmp10_ = x;
							_tmp11_ = y;
							if (puzzle_get_piece_id (self, _tmp9_, _tmp9__length1, _tmp10_, _tmp11_) == '*') {
								gchar* _tmp12_;
								gint _tmp12__length1;
								gint _tmp13_;
								gint _tmp14_;
								_tmp12_ = self->orig_map;
								_tmp12__length1 = self->orig_map_length1;
								_tmp13_ = x;
								_tmp14_ = y;
								_tmp8_ = puzzle_get_piece_id (self, _tmp12_, _tmp12__length1, _tmp13_, _tmp14_) != '.';
							} else {
								_tmp8_ = FALSE;
							}
							if (_tmp8_) {
								over = FALSE;
							}
						}
					}
				}
			}
		}
	}
	result = over;
	return result;
}


gboolean
puzzle_mapcmp (Puzzle* self,
               gchar* m1,
               int m1_length1,
               gchar* m2,
               int m2_length1)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = y;
				_tmp3_ = self->height;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gint _tmp7_;
							gint _tmp8_;
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = x;
								x = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = x;
							_tmp7_ = self->width;
							if (!(_tmp6_ < _tmp7_)) {
								break;
							}
							_tmp8_ = x;
							_tmp9_ = y;
							_tmp10_ = x;
							_tmp11_ = y;
							if (puzzle_get_piece_id (self, m1, m1_length1, _tmp8_, _tmp9_) != puzzle_get_piece_id (self, m2, m2_length1, _tmp10_, _tmp11_)) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean
puzzle_movable (Puzzle* self,
                gint id)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (id == ((gint) '#')) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = id == ((gint) '.');
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = id == ((gint) ' ');
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = id == ((gint) '-');
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean
puzzle_move_piece (Puzzle* self,
                   gchar id,
                   gint x1,
                   gint y1,
                   gint x2,
                   gint y2)
{
	gboolean result = FALSE;
	gboolean return_value = FALSE;
	gchar* _tmp0_;
	gint _tmp0__length1;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	return_value = FALSE;
	if (!puzzle_movable (self, (gint) id)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->map;
	_tmp0__length1 = self->map_length1;
	if (puzzle_get_piece_id (self, _tmp0_, _tmp0__length1, x2, y2) == id) {
		return_value = TRUE;
	}
	if (y1 == y2) {
		_tmp2_ = abs (x1 - x2) == 1;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (x1 == x2) {
			_tmp3_ = abs (y1 - y2) == 1;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	if (abs (y1 - y2) == 1) {
		if ((y1 - y2) < 0) {
			if (puzzle_check_valid_move (self, (gint) id, 0, 1)) {
				result = puzzle_do_move_piece (self, id, 0, 1);
				return result;
			}
		}
		if ((y1 - y2) > 0) {
			if (puzzle_check_valid_move (self, (gint) id, 0, -1)) {
				result = puzzle_do_move_piece (self, id, 0, -1);
				return result;
			}
		}
	}
	if (abs (x1 - x2) == 1) {
		if ((x1 - x2) < 0) {
			if (puzzle_check_valid_move (self, (gint) id, 1, 0)) {
				result = puzzle_do_move_piece (self, id, 1, 0);
				return result;
			}
		}
		if ((x1 - x2) > 0) {
			if (puzzle_check_valid_move (self, (gint) id, -1, 0)) {
				result = puzzle_do_move_piece (self, id, -1, 0);
				return result;
			}
		}
	}
	result = return_value;
	return result;
}


static gboolean
puzzle_check_valid_move (Puzzle* self,
                         gint id,
                         gint dx,
                         gint dy)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = y;
				_tmp3_ = self->height;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gint _tmp7_;
							gchar* _tmp8_;
							gint _tmp8__length1;
							gint _tmp9_;
							gint _tmp10_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = x;
								x = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = x;
							_tmp7_ = self->width;
							if (!(_tmp6_ < _tmp7_)) {
								break;
							}
							_tmp8_ = self->map;
							_tmp8__length1 = self->map_length1;
							_tmp9_ = x;
							_tmp10_ = y;
							if (((gint) puzzle_get_piece_id (self, _tmp8_, _tmp8__length1, _tmp9_, _tmp10_)) == id) {
								gchar z = '\0';
								gchar* _tmp11_;
								gint _tmp11__length1;
								gint _tmp12_;
								gint _tmp13_;
								gboolean _tmp14_ = FALSE;
								gboolean _tmp15_ = FALSE;
								gboolean _tmp16_ = FALSE;
								gchar _tmp17_;
								_tmp11_ = self->map;
								_tmp11__length1 = self->map_length1;
								_tmp12_ = x;
								_tmp13_ = y;
								z = puzzle_get_piece_id (self, _tmp11_, _tmp11__length1, _tmp12_ + dx, _tmp13_ + dy);
								_tmp17_ = z;
								if (_tmp17_ == ' ') {
									_tmp16_ = TRUE;
								} else {
									gchar _tmp18_;
									_tmp18_ = z;
									_tmp16_ = _tmp18_ == '.';
								}
								if (_tmp16_) {
									_tmp15_ = TRUE;
								} else {
									gchar _tmp19_;
									_tmp19_ = z;
									_tmp15_ = ((gint) _tmp19_) == id;
								}
								if (_tmp15_) {
									_tmp14_ = TRUE;
								} else {
									gboolean _tmp20_ = FALSE;
									if (id == ((gint) '*')) {
										gchar _tmp21_;
										_tmp21_ = z;
										_tmp20_ = _tmp21_ == '-';
									} else {
										_tmp20_ = FALSE;
									}
									_tmp14_ = _tmp20_;
								}
								if (!_tmp14_) {
									result = FALSE;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gchar*
_vala_array_dup5 (gchar* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gchar));
}


static gchar*
_vala_array_dup6 (gchar* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gchar));
}


static gboolean
puzzle_do_move_piece (Puzzle* self,
                      gchar id,
                      gint dx,
                      gint dy)
{
	gboolean result = FALSE;
	gchar* tmpmap = NULL;
	gchar* _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gint tmpmap_length1;
	gint _tmpmap_size_;
	gchar* _tmp58_;
	gint _tmp58__length1;
	gchar* _tmp59_;
	gint _tmp59__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->map;
	_tmp0__length1 = self->map_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	tmpmap = _tmp1_;
	tmpmap_length1 = _tmp1__length1;
	_tmpmap_size_ = tmpmap_length1;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = y;
					y = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = y;
				_tmp5_ = self->height;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gint _tmp9_;
							gchar* _tmp10_;
							gint _tmp10__length1;
							gint _tmp11_;
							gint _tmp12_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = x;
								x = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = x;
							_tmp9_ = self->width;
							if (!(_tmp8_ < _tmp9_)) {
								break;
							}
							_tmp10_ = tmpmap;
							_tmp10__length1 = tmpmap_length1;
							_tmp11_ = x;
							_tmp12_ = y;
							if (puzzle_get_piece_id (self, _tmp10_, _tmp10__length1, _tmp11_, _tmp12_) == id) {
								gchar* _tmp13_;
								gint _tmp13__length1;
								gint _tmp14_;
								gint _tmp15_;
								_tmp13_ = tmpmap;
								_tmp13__length1 = tmpmap_length1;
								_tmp14_ = x;
								_tmp15_ = y;
								puzzle_set_piece_id (self, _tmp13_, _tmp13__length1, _tmp14_, _tmp15_, ' ');
							}
						}
					}
				}
			}
		}
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = y;
					y = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = y;
				_tmp19_ = self->height;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp20_ = FALSE;
						_tmp20_ = TRUE;
						while (TRUE) {
							gint _tmp22_;
							gint _tmp23_;
							gchar* _tmp24_;
							gint _tmp24__length1;
							gint _tmp25_;
							gint _tmp26_;
							if (!_tmp20_) {
								gint _tmp21_;
								_tmp21_ = x;
								x = _tmp21_ + 1;
							}
							_tmp20_ = FALSE;
							_tmp22_ = x;
							_tmp23_ = self->width;
							if (!(_tmp22_ < _tmp23_)) {
								break;
							}
							_tmp24_ = self->map;
							_tmp24__length1 = self->map_length1;
							_tmp25_ = x;
							_tmp26_ = y;
							if (puzzle_get_piece_id (self, _tmp24_, _tmp24__length1, _tmp25_, _tmp26_) == id) {
								gchar* _tmp27_;
								gint _tmp27__length1;
								gint _tmp28_;
								gint _tmp29_;
								_tmp27_ = tmpmap;
								_tmp27__length1 = tmpmap_length1;
								_tmp28_ = x;
								_tmp29_ = y;
								puzzle_set_piece_id (self, _tmp27_, _tmp27__length1, _tmp28_ + dx, _tmp29_ + dy, id);
							}
						}
					}
				}
			}
		}
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = y;
					y = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				_tmp32_ = y;
				_tmp33_ = self->height;
				if (!(_tmp32_ < _tmp33_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp34_ = FALSE;
						_tmp34_ = TRUE;
						while (TRUE) {
							gint _tmp36_;
							gint _tmp37_;
							gboolean _tmp38_ = FALSE;
							gchar* _tmp39_;
							gint _tmp39__length1;
							gint _tmp40_;
							gint _tmp41_;
							gboolean _tmp48_ = FALSE;
							gchar* _tmp49_;
							gint _tmp49__length1;
							gint _tmp50_;
							gint _tmp51_;
							if (!_tmp34_) {
								gint _tmp35_;
								_tmp35_ = x;
								x = _tmp35_ + 1;
							}
							_tmp34_ = FALSE;
							_tmp36_ = x;
							_tmp37_ = self->width;
							if (!(_tmp36_ < _tmp37_)) {
								break;
							}
							_tmp39_ = tmpmap;
							_tmp39__length1 = tmpmap_length1;
							_tmp40_ = x;
							_tmp41_ = y;
							if (puzzle_get_piece_id (self, _tmp39_, _tmp39__length1, _tmp40_, _tmp41_) == ' ') {
								gchar* _tmp42_;
								gint _tmp42__length1;
								gint _tmp43_;
								gint _tmp44_;
								_tmp42_ = self->orig_map;
								_tmp42__length1 = self->orig_map_length1;
								_tmp43_ = x;
								_tmp44_ = y;
								_tmp38_ = puzzle_get_piece_id (self, _tmp42_, _tmp42__length1, _tmp43_, _tmp44_) == '.';
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								gchar* _tmp45_;
								gint _tmp45__length1;
								gint _tmp46_;
								gint _tmp47_;
								_tmp45_ = tmpmap;
								_tmp45__length1 = tmpmap_length1;
								_tmp46_ = x;
								_tmp47_ = y;
								puzzle_set_piece_id (self, _tmp45_, _tmp45__length1, _tmp46_, _tmp47_, '.');
							}
							_tmp49_ = tmpmap;
							_tmp49__length1 = tmpmap_length1;
							_tmp50_ = x;
							_tmp51_ = y;
							if (puzzle_get_piece_id (self, _tmp49_, _tmp49__length1, _tmp50_, _tmp51_) == ' ') {
								gchar* _tmp52_;
								gint _tmp52__length1;
								gint _tmp53_;
								gint _tmp54_;
								_tmp52_ = self->orig_map;
								_tmp52__length1 = self->orig_map_length1;
								_tmp53_ = x;
								_tmp54_ = y;
								_tmp48_ = puzzle_get_piece_id (self, _tmp52_, _tmp52__length1, _tmp53_, _tmp54_) == '-';
							} else {
								_tmp48_ = FALSE;
							}
							if (_tmp48_) {
								gchar* _tmp55_;
								gint _tmp55__length1;
								gint _tmp56_;
								gint _tmp57_;
								_tmp55_ = tmpmap;
								_tmp55__length1 = tmpmap_length1;
								_tmp56_ = x;
								_tmp57_ = y;
								puzzle_set_piece_id (self, _tmp55_, _tmp55__length1, _tmp56_, _tmp57_, '-');
							}
						}
					}
				}
			}
		}
	}
	g_signal_emit (self, puzzle_signals[PUZZLE_CHANGED_SIGNAL], 0);
	_tmp58_ = tmpmap;
	_tmp58__length1 = tmpmap_length1;
	_tmp59_ = (_tmp58_ != NULL) ? _vala_array_dup6 (_tmp58_, _tmp58__length1) : ((gpointer) _tmp58_);
	_tmp59__length1 = _tmp58__length1;
	self->map = (g_free (self->map), NULL);
	self->map = _tmp59_;
	self->map_length1 = _tmp59__length1;
	result = TRUE;
	tmpmap = (g_free (tmpmap), NULL);
	return result;
}


static void
puzzle_class_init (PuzzleClass * klass)
{
	puzzle_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = puzzle_finalize;
	puzzle_signals[PUZZLE_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	puzzle_signals[PUZZLE_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
puzzle_instance_init (Puzzle * self)
{
	self->moves = 0;
}


static void
puzzle_finalize (GObject * obj)
{
	Puzzle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE, Puzzle);
	self->map = (g_free (self->map), NULL);
	self->move_map = (g_free (self->move_map), NULL);
	self->orig_map = (g_free (self->orig_map), NULL);
	self->lastmove_map = (g_free (self->lastmove_map), NULL);
	self->undomove_map = (g_free (self->undomove_map), NULL);
	G_OBJECT_CLASS (puzzle_parent_class)->finalize (obj);
}


GType
puzzle_get_type (void)
{
	static volatile gsize puzzle_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Puzzle), 0, (GInstanceInitFunc) puzzle_instance_init, NULL };
		GType puzzle_type_id;
		puzzle_type_id = g_type_register_static (G_TYPE_OBJECT, "Puzzle", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_type_id__volatile, puzzle_type_id);
	}
	return puzzle_type_id__volatile;
}



