#ifndef __GM_MCP_ICECREW_PLAYERDB_H__
#define __GM_MCP_ICECREW_PLAYERDB_H__

#include <glib-object.h>
#include <gtk/gtk.h>
#include "gm-mcp-package.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_MCP_ICECREW_PLAYERDB					(gm_mcp_icecrew_playerdb_get_type())
#define GM_MCP_ICECREW_PLAYERDB(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_MCP_ICECREW_PLAYERDB, GmMcpIcecrewPlayerdb))
#define GM_MCP_ICECREW_PLAYERDB_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj),\
		GM_TYPE_MCP_ICECREW_PLAYERDB, GmMcpIcecrewPlayerdb const))
#define GM_MCP_ICECREW_PLAYERDB_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_MCP_ICECREW_PLAYERDB, GmMcpIcecrewPlayerdbClass))
#define GM_IS_MCP_ICECREW_PLAYERDB(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_MCP_ICECREW_PLAYERDB))
#define GM_IS_MCP_ICECREW_PLAYERDB_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_MCP_ICECREW_PLAYERDB))
#define GM_MCP_ICECREW_PLAYERDB_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_MCP_ICECREW_PLAYERDB, GmMcpIcecrewPlayerdbClass))

/* Private structure type */
typedef struct _GmMcpIcecrewPlayerdbPrivate GmMcpIcecrewPlayerdbPrivate;

/*
 * Main object structure
 */
typedef struct _GmMcpIcecrewPlayerdb GmMcpIcecrewPlayerdb;
 
struct _GmMcpIcecrewPlayerdb {
	GmMcpPackage parent;
	
	/*< private > */
	GmMcpIcecrewPlayerdbPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmMcpIcecrewPlayerdbClass 	GmMcpIcecrewPlayerdbClass;

struct _GmMcpIcecrewPlayerdbClass {
	GmMcpPackageClass parent_class;

	/* Signals */
	void (* add) (GmMcpIcecrewPlayerdb *obj, gpointer player_info);
	void (* set) (GmMcpIcecrewPlayerdb *obj, gpointer player_info, 
			gchar const *key, gchar const *value, gchar const *old_value);
	void (* delete) (GmMcpIcecrewPlayerdb *obj, gpointer player_info);
};

typedef struct _GmPlayerdbPlayerInfo {
	gint id;
	GHashTable *values;
} GmPlayerdbPlayerInfo;

typedef void (*PlayerdbFindFunc) (GmPlayerdbPlayerInfo *, gpointer user_data);

GType gm_mcp_icecrew_playerdb_get_type(void) G_GNUC_CONST;
GmMcpIcecrewPlayerdb *gm_mcp_icecrew_playerdb_new(void);

GList *gm_mcp_icecrew_playerdb_players(GmMcpIcecrewPlayerdb *db);

GmPlayerdbPlayerInfo *gm_mcp_icecrew_playerdb_find(
		GmMcpIcecrewPlayerdb *package, gint id);

gchar const *gm_playerdb_player_info_get_prop(GmPlayerdbPlayerInfo *ppi, 
		gchar const *key);
void gm_mcp_icecrew_playerdb_find_players_with(GmMcpIcecrewPlayerdb *package,
		gchar const *key, gchar const *value, PlayerdbFindFunc func,
		gpointer user_data);
gboolean gm_mcp_icecrew_playerdb_initializing(GmMcpIcecrewPlayerdb *package);

G_END_DECLS
#endif /* __GM_MCP_ICECREW_PLAYERDB_H__ */
