/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _globus_rls_server_auth_h_
#define _globus_rls_server_auth_h_

#include <sys/types.h>
#include <regex.h>

#define P_LRCREAD	0x01
#define P_LRCUPDATE	0x02
#define P_RLIREAD	0x04
#define P_RLIUPDATE	0x08
#define P_ADMIN		0x10
#define P_STATS		0x20

typedef struct acl_ {
  char		*dn;
  regex_t	re;
  int		perms;
  struct acl_	*nxt;
} ACL;

extern int	auth_getperms(ACL *acllist, char *dn);
extern ACL	*auth_freeacl(ACL *acllist);
extern ACL	*auth_newacl(ACL *acllist, char *val);
extern char	*auth_perms2s(int p);

#endif
