# Введение

Добро пожаловать в  *ghostwriter*! Эта краткая справка показывает примеры использования Markdown, облегчённого языка разметки, созданного Джоном Грубером (John Gruber). Для дополнительной информации, посетите сайт Джона Грубера на <http://www.daringfireball.net>.
Официальный сайт *ghostwriter* доступен на <http://www.github.com/wereturtle/ghostwriter>.

*ghostwriter* имеет встроенный конвертер Sundown. Однако, он может также автоматически обнаружить конвертеры Pandoc, MultiMarkdown, Discount, или cmark. Для их использования, просто установите их, и убедитесь, что их пути установки добавлены в переменную окружения `PATH`. *ghostwriter* обнаружит конвертеры при запуске и предоставит соответствующие опции для предпросмотра HTML и экспорта.


# Заголовки

    # Заголовок первого уровня
    ## Заголовок второго уровня ##
    ###### Заголовок шестого уровня
    
    Заголовок первого уровня
    ===============
    какой-то текст
    
    Заголовок второго уровня
    ---------------
    ещё текст

# Абзацы

    Это абзац.
    Это другая строка всё того же абзаца, с ручным переводом строки.
    
    Это — новый абзац.

# Форматирование строк

Слова можно делать *курсивными* и даже **жирными** двумя способами. Первый — окружить их звёздочками (\*). Второй — окружить подчёркиваниями (\_).

	*Курсив* со звёздочками.
	_Курсив_ с подчёркиваниями.

	**Жирно** и со звёздочками.
	__Жирно__ и с подчёркиваниями.

Смешивая то и другое, можно получить ***жирный курсив***:

	***Жирный курсив*** со звёздочками.
	**_Жирный курвив_** с тем и другим.
	Вот ещё один *__жирный курсив__*.
	Ну и так далее.

# Ссылки

Можно делать ссылки на сайты:

	Жми [сюда](http://url.com "Заголовок") чтобы зайти на сайт.
	
Ещё можно делать ссылки-сноски:

	[Эту][id] ссылку определят чуть ниже.
	
	[id]: http://url.com "Заголовок"

# Картинки

Картинки вставляют вот так:

	![альтернативный текст](./image.jpg "Заголовок")

Их можно определять так же, как и ссылки-сноски:

    ![alternate text][id] for a reference defined below.
    
    [id]: ./image.jpg "Title"

# Списки

Можно сделать нумерованный список:

    1. Пункт первый.
    2. Пункт второй.
    3. Пункт третий.

А можно — маркированный:

    * Первый пункт.
    + Второй.
    - Третий.

Ещё их можно смешивать:

    1. Пункт первый
        * Подпункт первый
        * Подпункт второй
    2. Пункт второй
        - Подпункт раз
        - Подпункт два
    3. Пункт третий
        1. Подпункт три

# Блоки кода

Отступ четырьмя и более пробелами (а также отступ символами табуляции) порождает блок кода:

    Простой абзац, за которым следует блок кода.
        
        for (int i = 0; i < 10; i++) {
            System.out.println("i = " + i);
        }
        
    Фрагмент выше станет отформатированным блоком кода

Некоторые конвертеры Markdown, такие как Pandoc, позволяют выделить блок кода обратными апострофами вместо отступов:

    ```
    for (int i = 0; i < 10; i++) {
        System.out.println("i = " + i);
    }
    ```

Этот блок будет также отображён как неформатированный блок кода.

# Строчный код

Код в середине абзаца можно обозначить обратными апострофами, как вот этот `` `<html>` `` тег. Содержащий обратные апострофы код можно выделить используя дополнительные апострофы, вот так: ``` `` `экранированные апострофы` `` ```.

# Блочные цитаты

Блочные цитаты обозначаются так же, как и в электронных письмах:

    > Это — блочная цитата.
    >
    >> А это вложенная блочная цитата.

# Горизонтальная черта

Горизонтальная черта получается из трёх дефисов (\-), подчёркиваний (\_) или звёздочек (\*):

    ---
    
    ***
    ___

Между ними даже могут быть пробелы:

    - - -

# Расширения Markdown

Некоторые конвертеры Markdown добавляют синтаксис для таблиц, сносок и прочего, расширяя первоначальную спецификацию Markdown. Вот пример сноски для Pandoc, MultiMarkdown и других конвертеров, поддерживающих это расширение:

    Этот текст снабжён сноской.[^footnoteid]
    
    [^footnoteid]:  А вот, собственно, и она.

Вот пример таблицы Pandoc:

    Column One     Column Two
    ----------     ----------
    Row Text 1     Row Text 2
    Row Text 1     Row Text 2
    
    Table:  Pandoc sample table.

А вот пример таблицы Sundown или MultiMarkdown:

    Column One  |  Column Two
    ----------  |  ----------
    Row Text 1  |  Row Text 2
    Row Text 1  |  Row Text 2

Конвертеры Markdown могут поддерживать множество других синтаксисов таблиц. И существует ещё много других расширений. Для дополнительной информации, посетите следующие сайты:

+ Sundown: <http://github.com/vmg/sundown/>
+ Pandoc: <http://johnmacfarlane.net/pandoc/>
+ MultiMarkdown: <http://fletcherpenney.net/multimarkdown/>
+ Discount: <http://www.pell.portland.or.us/~orc/Code/discount/>
+ cmark: <http://github.com/jgm/cmark/>

Первоначальная спецификация Джона Грубера можно найти на <http://daringfireball.net/projects/markdown/>.

# Горячие клавиши

У *ghostwriter* есть несколько горячих клавиш для редактирования Markdown:

`Ctrl+B`
:   Применяет жирное форматирование.

`Ctrl+I`
:   Применяет курсивное форматирование.

`Ctrl+K`
:   Применяет перечёркнуторе форматирование.

`Ctrl+/`
:   Нажатие клавиши `Ctrl` вместе с `/` либо вставит комментарий HTML на место курсора, либо пребразует выделенный текст в комментарий.

`Tab`
:   Когда текст в редакторе выделен, нажатие клавиши табуляции добавляет отступы к выбраным строкам текста.

`Shift+Tab`
:   Когда текст в редакторе выделен, нажатие `Tab` вместе с `Shift` уберёт один уровень отступа у выбранных строк текста.

`Shift+Enter`
:   Вставляет перевод строки в стиле Markdown.

`Ctrl+Enter`
:   Вставляет обычные перевод строки, но игнорируя текущий отступ. Иначе говоря, если нажать `Ctrl+Enter` в строке с отступом, новая строка добавится без него. Обратите внимание, `Ctrl` можно совместить с `Shift`, получив тем самым перевод строки в стиле Markdown с новой стркой без отступа.

`Ctrl+.`
:   Нажатие `Ctrl` вместе с `.` превращает выделеные строки в блочную цитату.

`Ctrl+,`
:   Нажатие `Ctrl` вместе с `,` отменяет цитирование, превращая все блочные цитаты в выделеных строках в обычный текст.

`Ctrl+8`
:   Нажатие `Ctrl` вместе с `8` превращает выделенные строки в маркированный список с `*` в качестве маркера. Например, пусть выбраны следующие строки:

        Первый элемент списка.
        Второй элемент списка.
        
    Нажатие `Ctrl+8` превратит эти строки в такой список:

        * Первый элемент списка.
        * Второй элемент списка.

`Ctrl+Shift+-`
:   Нажатие `Ctrl` вместе с `Shift` и `-` превращает выделенные строки в маркированный список с `-` в качестве маркера. Например, пусть выбраны следующие строки:

        Первый элемент списка.
        Второй элемент списка.
        
    Нажатие `Ctrl+Shift+-` превратит эти строки в такой список:

        - Первый элемент списка.
        - Второй элемент списка.

`Ctrl+Shift+=`
:   Нажатие `Ctrl` вместе с `Shift` и `-` превращает выделенные строки в маркированный список с `+` в качестве маркера. Например, пусть выбраны следующие строки:

        Первый элемент списка.
        Второй элемент списка.
        
    Нажатие `Ctrl+Shift+=` превратит эти строки в такой список:

        + Первый элемент списка.
        + Второй элемент списка.

`Ctrl+1`
:   Нажатие `Ctrl` вместе с `1` (число 1) превращает выделенные строки в нумерованный список с маркером `.`. Например, пусть выбраны следующие строки:

        Первый элемент списка.
        Второй элемент списка.
        
    Нажатие `Ctrl+1` превратит эти строки в такой список:

        1. Первый элемент списка.
        2. Второй элемент списка.

`Ctrl+0`
:   Нажатие `Ctrl` вместе с `1` (число 0) превращает выделенные строки в нумерованный список с маркером `)`. Например, пусть выбраны следующие строки:

        Первый элемент списка.
        Второй элемент списка.
        
    Нажатие `Ctrl+0` превратит эти строки в такой список:

        1) Первый элемент списка.
        2) Второй элемент списка.

`Ctrl+T`
:   Нажатие `Ctrl+T` превращает выбранные строки в список задач в стиле Github. Например, пусть выбраны следующие строки:

        Важная задача!
        Другая задача, не менее важная.
        
    Нажатие `Ctrl+T` превратит эти строки в список задач:

        - [ ] Важная задача!
        - [ ] Другая задача, не менее важная.

`Ctrl+D`
:   Если текущая строка является пунктом списка задач, нажатие `Ctrl+D` поменяет состояние задачи, поставив крестик, если его нет, или убрав крестик, если он есть. Например:

        - [ ] Невыполненная задача.
        - [x] `Ctrl+D` пометило эту задачу как выполненую!

`"`, `'`, `(`, `[`, `{`, `*`, `_`, `` ` ``, `<`
:   Если выбран текст внутри строки, ввод любого из этих символов заключит выделеный текст между этим символом и соответствующим закрывающим символом. Например, если выбрать слово `кот` и затем ввести `(`, слово `кот` будет заключено в скобки и превратится в `(кот)`. Вот таблица открывающих и закрывающих символов:

    Открывающие | Закрывающие
    ------------|------------
    `"`         | `"`
    `'`         | `'`
    `(`         | `)`
    `[`         | `]`
    `{`         | `}`
    `*`         | `*`
    `_`         | `_`
    `` ` ``     | `` ` ``
    `<`         | `>`
    
    Чтобы сиволы автоматически дополнялись при наборе, включите опцию «Автоматически дополнять символы» в параметрах редактора. Там же можно настроить и то, какие именно символы дополнять.

Перетаскивание изображений
:   Вместо того, чтобы выбирать открывать меню правки и выбирать там «Вставить изображение...», можно просто перетащить файл изображения в окно редактора. Приложение вставит изображение с путём, относительным к расположению текущего документа, или же, если докумен не сохранён, изображение с полным путём. Например:

        ![](../../относительный/путь/к/файлу.png)

    или если документ не сохранён:

        ![](file:///полный/путь/к/файлу.png)

- - - -

Все права защищены © 2014-2017 [wereturtle](http://www.github.com/wereturtle)
