*
* $Id: casasm.F,v 1.1.1.1 1995/10/24 10:21:02 cernlib Exp $
*
* $Log: casasm.F,v $
* Revision 1.1.1.1  1995/10/24 10:21:02  cernlib
* Geant
*
*
#include "geant321/pilot.h"
*CMZ :  3.21/02 29/03/94  15.41.39  by  S.Giani
*-- Author :
      SUBROUTINE CASASM(K,INT,NFL)
C
C *** CASCADE OF ANTI SIGMA- ***
C *** NVE 04-MAY-1988 CERN GENEVA ***
C
C ORIGIN : H.FESEFELDT (13-SEP-1987)
C
C S-B UNDERGOES INTERACTION WITH NUCLEON WITHIN NUCLEUS.
C CHECK IF ENERGETICALLY POSSIBLE TO PRODUCE PIONS/KAONS.
C IF NOT ASSUME NUCLEAR EXCITATION OCCURS AND INPUT PARTICLE
C IS DEGRADED IN ENERGY.    NO OTHER PARTICLES PRODUCED.
C IF REACTION IS POSSIBLE FIND CORRECT NUMBER OF PIONS/PROTONS/
C NEUTRONS PRODUCED USING AN INTERPOLATION TO MULTIPLICITY DATA.
C REPLACE SOME PIONS OR PROTONS/NEUTRONS BY KAONS OR STRANGE BARYONS
C ACCORDING TO AVERAGE MULTIPLICITY PER INELASTIC REACTIONS.
C
#include "geant321/mxgkgh.inc"
#include "geant321/s_consts.inc"
#include "geant321/s_curpar.inc"
#include "geant321/s_result.inc"
#include "geant321/s_prntfl.inc"
#include "geant321/s_kginit.inc"
#include "geant321/limits.inc"
C
      REAL N
      DIMENSION PMUL1(2,1200),PMUL2(2,400),ANORM1(2,60),ANORM2(2,60),
     $          CECH(10),ANHL(25),IIPA(10,2),B(2)
      DIMENSION RNDM(2)
      SAVE PMUL1,ANORM1,PMUL2,ANORM2
      DATA CECH/0.50,0.45,0.40,0.35,0.30,0.25,0.06,0.04,0.005,0./
      DATA ANHL/1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,0.97,0.88
     $         ,0.85,0.81,0.75,0.64,0.64,0.55,0.55,0.45,0.47,0.40
     $         ,0.39,0.36,0.33,0.10,0.01/
      DATA IIPA/14,14,14,14,14,19,24,16,14,14,
     $          25,25,25,25,25,14,14,25,19,24/
      DATA B/0.7,0.7/,C/1.25/
C
C --- INITIALIZATION INDICATED BY KGINIT(2) ---
      IF (KGINIT(2) .NE. 0) GO TO 10
      KGINIT(2)=1
C
C --- INITIALIZE PMUL AND ANORM ARRAYS ---
      DO 9000 J=1,1200
      DO 9001 I=1,2
      PMUL1(I,J)=0.0
      IF (J .LE. 400) PMUL2(I,J)=0.0
      IF (J .LE. 60) ANORM1(I,J)=0.0
      IF (J .LE. 60) ANORM2(I,J)=0.0
 9001 CONTINUE
 9000 CONTINUE
C
C** COMPUTE NORMALIZATION CONSTANTS
C** FOR P AS TARGET
C
      L=0
      DO 1 NP1=1,20
      NP=NP1-1
      NMM1=NP1-2
      IF(NMM1.LE.1) NMM1=1
      NPP1=NP1
      DO 1 NM1=NMM1,NPP1
      NM=NM1-1
      DO 1 NZ1=1,20
      NZ=NZ1-1
      L=L+1
      IF(L.GT.1200) GOTO 1
      NT=NP+NM+NZ
      IF(NT.LE.0.OR.NT.GT.60) GOTO 1
      PMUL1(1,L)=PMLTPC(NP,NM,NZ,NT,B(1),C)
      ANORM1(1,NT)=ANORM1(1,NT)+PMUL1(1,L)
    1 CONTINUE
C** FOR N AS TARGET
      L=0
      DO 2 NP1=1,20
      NP=NP1-1
      NMM1=NP1-1
      IF(NMM1.LT.1) NMM1=1
      NPP1=NP1+1
      DO 2 NM1=NMM1,NPP1
      NM=NM1-1
      DO 2 NZ1=1,20
      NZ=NZ1-1
      L=L+1
      IF(L.GT.1200) GOTO 2
      NT=NP+NM+NZ
      IF(NT.LE.0.OR.NT.GT.60) GOTO 2
      PMUL1(2,L)=PMLTPC(NP,NM,NZ,NT,B(2),C)
      ANORM1(2,NT)=ANORM1(2,NT)+PMUL1(2,L)
    2 CONTINUE
      DO 3 I=1,60
      IF(ANORM1(1,I).GT.0.) ANORM1(1,I)=1./ANORM1(1,I)
      IF(ANORM1(2,I).GT.0.) ANORM1(2,I)=1./ANORM1(2,I)
    3 CONTINUE
      IF(.NOT.NPRT(10)) GOTO 9
      WRITE(NEWBCD,2001)
      DO 4 NFL=1,2
      WRITE(NEWBCD,2002) NFL
      WRITE(NEWBCD,2003) (ANORM1(NFL,I),I=1,60)
      WRITE(NEWBCD,2003) (PMUL1(NFL,I),I=1,1200)
    4 CONTINUE
C** DO THE SAME FOR ANNIHILATION CHANNELS
C** FOR P AS TARGET
C
    9 L=0
      DO 5 NP1=3,20
      NP=NP1-1
      NM=NP-2
      DO 5 NZ1=1,20
      NZ=NZ1-1
      IF(NM+NZ.EQ.0) GOTO 5
      L=L+1
      IF(L.GT.400) GOTO 5
      NT=NP+NM+NZ
      IF(NT.LE.2.OR.NT.GT.60) GOTO 5
      PMUL2(1,L)=PMLTPC(NP,NM,NZ,NT,B(1),C)
      ANORM2(1,NT)=ANORM2(1,NT)+PMUL2(1,L)
    5 CONTINUE
C** FOR N AS TARGET
      L=0
      DO 6 NP1=2,20
      NP=NP1-1
      NM=NP-1
      DO 6 NZ1=1,20
      NZ=NZ1-1
      IF(NM+NZ.EQ.0) GOTO 6
      L=L+1
      IF(L.GT.400) GOTO 6
      NT=NP+NM+NZ
      IF(NT.LE.1.OR.NT.GT.60) GOTO 6
      PMUL2(2,L)=PMLTPC(NP,NM,NZ,NT,B(2),C)
      ANORM2(2,NT)=ANORM2(2,NT)+PMUL2(2,L)
    6 CONTINUE
      DO 7 I=1,60
      IF(ANORM2(1,I).GT.0.) ANORM2(1,I)=1./ANORM2(1,I)
      IF(ANORM2(2,I).GT.0.) ANORM2(2,I)=1./ANORM2(2,I)
    7 CONTINUE
      IF(.NOT.NPRT(10)) GOTO 10
      WRITE(NEWBCD,3001)
      DO 8 NFL=1,2
      WRITE(NEWBCD,3002) NFL
      WRITE(NEWBCD,3003) (ANORM2(NFL,I),I=1,60)
      WRITE(NEWBCD,3003) (PMUL2(NFL,I),I=1,400)
    8 CONTINUE
C** CHOOSE PROTON OR NEUTRON AS TARGET
   10 NFL=2
      CALL GRNDM(RNDM,1)
      IF(RNDM(1).LT.ZNO2/ATNO2) NFL=1
      TARMAS=RMASS(14)
      IF (NFL .EQ. 2) TARMAS=RMASS(16)
      S=AMASQ+TARMAS**2+2.0*TARMAS*EN
      RS=SQRT(S)
      ENP(8)=AMASQ+TARMAS**2+2.0*TARMAS*ENP(6)
      ENP(9)=SQRT(ENP(8))
      EAB=RS-TARMAS-ABS(RMASS(25))
C**  ELASTIC SCATTERING
      NP=0
      NM=0
      NZ=0
      IPA(1)=25
      IPA(2)=14
      IF(NFL.EQ.2) IPA(2)=16
      N=0.
      IF(INT.EQ.2) GOTO 20
      IPLAB=IFIX(P*2.5)+1
      IF(IPLAB.GT.10) IPLAB=10
      CALL GRNDM(RNDM,1)
      IF(RNDM(1).GT.CECH(IPLAB)/ATNO2**0.42) GOTO 120
C** INTRODUCE CHARGE AND STRANGENESS EXCHANGE REACTION
C** S-B N --> LB P, S-B N --> S0B P,
C**                                  S-B P --> P S-B
C** S-B N --> N S-B, S-B N --> P LB, S-B N --> P S0B
      CALL GRNDM(RNDM,1)
      RAN=RNDM(1)
      IRN=IFIX(RAN/0.2)+1
      IF(IRN.GT.5) IRN=5
      IRN=IRN+(NFL-1)*5
      IPA(1)=IIPA(IRN,1)
      IPA(2)=IIPA(IRN,2)
      GOTO 120
C** ANNIHILATION CHANNELS
   20 IPLAB=IFIX(P*10.)+1
      IF(IPLAB.GT.10) IPLAB=IFIX((P-1.)*5.)+11
      IF(IPLAB.GT.15) IPLAB=IFIX( P-2.    )+16
      IF(IPLAB.GT.23) IPLAB=IFIX((P-10.)/10.)+24
      IF(IPLAB.GT.25) IPLAB=25
      CALL GRNDM(RNDM,1)
      IF(RNDM(1).GT.ANHL(IPLAB)) GOTO 19
      EAB=RS
      IF (EAB .LE. RMASS(7)+RMASS(10)) GOTO 55
      GOTO 222
C**  CHECK IF ENERGETICALLY POSSIBLE TO PRODUCE ONE EXTRA PION IN REACT.
   19 IF (EAB .LE. RMASS(7)) GOTO 55
      ALEAB=LOG(EAB)
C** NO. OF TOTAL PARTICLES VS SQRT(S)-2*MP
      N=3.62567+0.665843*ALEAB+0.336514*ALEAB*ALEAB
     * +0.117712*ALEAB*ALEAB*ALEAB+0.0136912*ALEAB*ALEAB*ALEAB*ALEAB
      N=N-2.
C** NORMALIZATION CONSTANT FOR  KNO-DISTRIBUTION
      ANPN=0.
      DO 21 NT=1,60
      TEST=-(PI/4.0)*(NT/N)**2
      IF (TEST .LT. EXPXL) TEST=EXPXL
      IF (TEST .GT. EXPXU) TEST=EXPXU
      DUM1=PI*NT/(2.0*N*N)
      DUM2=ABS(DUM1)
      DUM3=EXP(TEST)
      ADDNVE=0.0
      IF (DUM2 .GE. 1.0) ADDNVE=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GE. 1.0E-10)) ADDNVE=DUM1*DUM3
      ANPN=ANPN+ADDNVE
   21 CONTINUE
      ANPN=1./ANPN
C** P OR N AS TARGET
      CALL GRNDM(RNDM,1)
      RAN=RNDM(1)
      EXCS=0.
      GOTO (30,40),NFL
C** FOR P AS TARGET
   30 L=0
      DO 31 NP1=1,20
      NP=NP1-1
      NMM1=NP1-2
      IF(NMM1.LE.1) NMM1=1
      NPP1=NP1
      DO 31 NM1=NMM1,NPP1
      NM=NM1-1
      DO 31 NZ1=1,20
      NZ=NZ1-1
      L=L+1
      IF(L.GT.1200) GOTO 31
      NT=NP+NM+NZ
      IF(NT.LE.0.OR.NT.GT.60) GOTO 31
      TEST=-(PI/4.0)*(NT/N)**2
      IF (TEST .LT. EXPXL) TEST=EXPXL
      IF (TEST .GT. EXPXU) TEST=EXPXU
      DUM1=ANPN*PI*NT*PMUL1(1,L)*ANORM1(1,NT)/(2.0*N*N)
      DUM2=ABS(DUM1)
      DUM3=EXP(TEST)
      ADDNVE=0.0
      IF (DUM2 .GE. 1.0) ADDNVE=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GE. 1.0E-10)) ADDNVE=DUM1*DUM3
      EXCS=EXCS+ADDNVE
      IF(RAN.LT.EXCS) GOTO 100
   31 CONTINUE
      GOTO 80
C** FOR N AS TARGET
   40 L=0
      DO 41 NP1=1,20
      NP=NP1-1
      NMM1=NP1-1
      IF(NMM1.LT.1) NMM1=1
      NPP1=NP1+1
      DO 41 NM1=NMM1,NPP1
      NM=NM1-1
      DO 41 NZ1=1,20
      NZ=NZ1-1
      L=L+1
      IF(L.GT.1200) GOTO 41
      NT=NP+NM+NZ
      IF(NT.LE.0.OR.NT.GT.60) GOTO 41
      TEST=-(PI/4.0)*(NT/N)**2
      IF (TEST .LT. EXPXL) TEST=EXPXL
      IF (TEST .GT. EXPXU) TEST=EXPXU
      DUM1=ANPN*PI*NT*PMUL1(2,L)*ANORM1(2,NT)/(2.0*N*N)
      DUM2=ABS(DUM1)
      DUM3=EXP(TEST)
      ADDNVE=0.0
      IF (DUM2 .GE. 1.0) ADDNVE=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GE. 1.0E-10)) ADDNVE=DUM1*DUM3
      EXCS=EXCS+ADDNVE
      IF(RAN.LT.EXCS) GOTO 100
   41 CONTINUE
      GOTO 80
C** ANNIHILATION CHANNELS
  222 IPA(1)=0
      IPA(2)=0
      ALEAB=LOG(EAB)
C** NO. OF TOTAL PARTICLES VS SQRT(S)
      N=3.62567+0.665843*ALEAB+0.336514*ALEAB*ALEAB
     * +0.117712*ALEAB*ALEAB*ALEAB+0.0136912*ALEAB*ALEAB*ALEAB*ALEAB
      N=N-2.
C** NORMALIZATION CONSTANT FOR  KNO-DISTRIBUTION
      ANPN=0.
      DO 221 NT=2,60
      TEST=-(PI/4.0)*(NT/N)**2
      IF (TEST .LT. EXPXL) TEST=EXPXL
      IF (TEST .GT. EXPXU) TEST=EXPXU
      DUM1=PI*NT/(2.0*N*N)
      DUM2=ABS(DUM1)
      DUM3=EXP(TEST)
      ADDNVE=0.0
      IF (DUM2 .GE. 1.0) ADDNVE=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GE. 1.0E-10)) ADDNVE=DUM1*DUM3
      ANPN=ANPN+ADDNVE
  221 CONTINUE
      ANPN=1./ANPN
C** P OR N AS TARGET
      CALL GRNDM(RNDM,1)
      RAN=RNDM(1)
      EXCS=0.
      GOTO (230,240),NFL
C** FOR P AS TARGET
  230 L=0
      DO 231 NP1=3,20
      NP=NP1-1
      NM=NP-2
      DO 231 NZ1=1,20
      NZ=NZ1-1
      IF(NM+NZ.EQ.0) GOTO 231
      L=L+1
      IF(L.GT.400) GOTO 231
      NT=NP+NM+NZ
      IF(NT.LE.2.OR.NT.GT.60) GOTO 231
      TEST=-(PI/4.0)*(NT/N)**2
      IF (TEST .LT. EXPXL) TEST=EXPXL
      IF (TEST .GT. EXPXU) TEST=EXPXU
      DUM1=ANPN*PI*NT*PMUL2(1,L)*ANORM2(1,NT)/(2.0*N*N)
      DUM2=ABS(DUM1)
      DUM3=EXP(TEST)
      ADDNVE=0.0
      IF (DUM2 .GE. 1.0) ADDNVE=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GE. 1.0E-10)) ADDNVE=DUM1*DUM3
      EXCS=EXCS+ADDNVE
      IF(RAN.LT.EXCS) GOTO 120
  231 CONTINUE
      GOTO 80
C** FOR N AS TARGET
  240 L=0
      DO 241 NP1=2,20
      NP=NP1-1
      NM=NP-1
      DO 241 NZ1=1,20
      NZ=NZ1-1
      IF(NM+NZ.EQ.0) GOTO 241
      L=L+1
      IF(L.GT.400) GOTO 241
      NT=NP+NM+NZ
      IF(NT.LE.1.OR.NT.GT.60) GOTO 241
      TEST=-(PI/4.0)*(NT/N)**2
      IF (TEST .LT. EXPXL) TEST=EXPXL
      IF (TEST .GT. EXPXU) TEST=EXPXU
      DUM1=ANPN*PI*NT*PMUL2(2,L)*ANORM2(2,NT)/(2.0*N*N)
      DUM2=ABS(DUM1)
      DUM3=EXP(TEST)
      ADDNVE=0.0
      IF (DUM2 .GE. 1.0) ADDNVE=DUM1*DUM3
      IF ((DUM2 .LT. 1.0) .AND. (DUM3 .GE. 1.0E-10)) ADDNVE=DUM1*DUM3
      EXCS=EXCS+ADDNVE
      IF(RAN.LT.EXCS) GOTO 120
  241 CONTINUE
      GOTO 80
   50 IF(NPRT(4))
     *WRITE(NEWBCD,1003) EAB,N,NFL,NP,NM,NZ
      IF(INT.EQ.1) CALL TWOB(25,NFL,N)
      IF(INT.EQ.2) CALL GENXPT(25,NFL,N)
      GO TO 9999
   55 IF(NPRT(4))
     *WRITE(NEWBCD,1001)
      GOTO 53
C** EXCLUSIVE REACTION NOT FOUND,ASSUME ELASTIC SCATTERING
   80 IF(NPRT(4))
     *WRITE(NEWBCD,1004) RS,N
   53 INT=1
      NP=0
      NM=0
      NZ=0
      IPA(1)=25
      IPA(2)=14
      IF(NFL.EQ.2) IPA(2)=16
      GOTO 120
  100 DO 101 I=1,60
  101 IPA(I)=0
      IF(INT.LE.0) GOTO 131
      GOTO (102,112),NFL
  102 NCHT=NP-NM
      NCHT=NCHT+1
      IF(NCHT.LE.0) NCHT=1
      IF(NCHT.GT.3) NCHT=3
      GOTO(103,104,105),NCHT
  103 IPA(1)=25
      IPA(2)=14
      GOTO 120
  104 IPA(1)=25
      IPA(2)=16
      CALL GRNDM(RNDM,2)
      IF(RNDM(1).LT.0.5) GOTO 120
      IPA(1)=24
      IF(RNDM(2).LT.0.5) IPA(1)=19
      IPA(2)=14
      GOTO 120
  105 IPA(1)=24
      CALL GRNDM(RNDM,1)
      IF(RNDM(1).LT.0.5) IPA(1)=19
      IPA(2)=16
      GOTO 120
  112 NCHT=NP-NM
      NCHT=NCHT+2
      IF(NCHT.LE.0) NCHT=1
      IF(NCHT.GT.3) NCHT=3
      GOTO(113,114,115),NCHT
  113 IPA(1)=25
      IPA(2)=14
      GOTO 120
  114 IPA(1)=24
      CALL GRNDM(RNDM,2)
      IF(RNDM(1).LT.0.5) IPA(1)=19
      IPA(2)=14
      IF(RNDM(2).LT.0.5) GOTO 120
      IPA(1)=25
      IPA(2)=16
      GOTO 120
  115 IPA(1)=24
      CALL GRNDM(RNDM,1)
      IF(RNDM(1).LT.0.5) IPA(1)=19
      IPA(2)=16
  120 NT=2
      IF(IPA(1).NE.0) GOTO 119
      IF(NZ.EQ.0) GOTO 118
      IF(NM.EQ.0) GOTO 117
      CALL GRNDM(RNDM,1)
      IF(RNDM(1).LT.0.5) GOTO 118
  117 IPA(3)=12
      NZ=NZ-1
      NT=3
      GOTO 119
  118 IF(NM.EQ.0) GOTO 119
      IPA(3)=13
      NM=NM-1
      NT=3
  119 IF(NP.EQ.0) GOTO 122
      DO 121 I=1,NP
      NT=NT+1
  121 IPA(NT)=7
  122 IF(NM.EQ.0) GOTO 124
      DO 123 I=1,NM
      NT=NT+1
  123 IPA(NT)=9
  124 IF(NZ.EQ.0) GOTO 130
      DO 125 I=1,NZ
      NT=NT+1
  125 IPA(NT)=8
  130 IF(NPRT(4))
     *WRITE(NEWBCD,2004) NT,(IPA(I),I=1,20)
      GOTO 50
  131 IF(NPRT(4))
     *WRITE(NEWBCD,2005)
C
1001  FORMAT('0*CASASM* CASCADE ENERGETICALLY NOT POSSIBLE',
     $ ' CONTINUE WITH QUASI-ELASTIC SCATTERING')
1003  FORMAT(' *CASASM* ANTISIGMA- -INDUCED CASCADE',
     $ ' AVAIL. ENERGY',2X,F8.4,
     $ 2X,'<NTOT>',2X,F8.4,2X,'FROM',4(2X,I3),2X,'PARTICLES')
1004  FORMAT(' *CASASM* ANTISIGMA- -INDUCED CASCADE,',
     $ ' EXCLUSIVE REACTION',
     $' NOT FOUND  TRY ELASTIC SCATTERING  AVAIL. ENERGY',2X,F8.4,2X,
     $ '<NTOT>',2X,F8.4)
2001  FORMAT('0*CASASM* TABLES FOR MULT. DATA ANTISIGMA- INDUCED ',
     $'REACTION  FOR DEFINITION OF NUMBERS SEE FORTRAN CODING')
2002  FORMAT(' *CASASM* TARGET PARTICLE FLAG',2X,I5)
2003  FORMAT(1H ,10E12.4)
2004  FORMAT(' *CASASM* ',I3,2X,'PARTICLES , MASS INDEX ARRAY',2X,20I4)
2005  FORMAT(' *CASASM* NO PARTICLES PRODUCED')
3001  FORMAT('0*CASASM* TABLES FOR MULT. DATA ANTISIGMA- INDUCED ',
     *'ANNIHILATION REACTION  FOR DEFINITION OF NUMBERS SEE FORTRAN',
     *' CODING')
3002  FORMAT(' *CASASM* TARGET PARTICLE FLAG',2X,I5)
3003  FORMAT(1H ,10E12.4)
C
 9999 CONTINUE
      END
