import { BinaryView } from "@ot-builder/bin-util";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Data } from "@ot-builder/prelude";
import { ReadTimeIVS } from "@ot-builder/var-store";
import { CffGlyphNaming } from "../charset/glyph-data-sink";
import { CffStringSource } from "../strings/source";
export declare class CffReadContext {
    version: number;
    readonly vwCffTable: BinaryView;
    constructor(version: number | undefined, vwCffTable: BinaryView, gss?: Data.Maybe<OtGlyph.CoStat.Source>);
    ivs: null | ReadTimeIVS;
    strings: null | CffStringSource;
    coStat: CffGlyphCoStatSource;
    naming: null | CffGlyphNaming<OtGlyph>;
}
export declare class CffGlyphCoStatSource implements OtGlyph.CoStat.Source {
    private readonly outer?;
    constructor(outer?: Data.Maybe<OtGlyph.CoStat.Source>);
    getHMetric(gid: number, extent: Data.Maybe<OtGlyph.Stat.BoundingBox>): Data.Maybe<OtGlyph.Metric>;
    getVMetric(gid: number, extent: Data.Maybe<OtGlyph.Stat.BoundingBox>): Data.Maybe<OtGlyph.Metric>;
}
//# sourceMappingURL=read.d.ts.map