/* $Id: xpm2logo.c,v 1.7 2009-01-28 17:20:10 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>

char *progname;

static void
do_work(void)
{
	unsigned char width;
	unsigned char height;
	unsigned int x;
	unsigned int y;
	unsigned int n;

	/* Check width and height. */
	width = getchar();
	height = getchar();
	if (17 < width
	 || 9 < height) {
		fprintf(stderr, "No EPA file.\n");
		exit(1);
	}

	printf("const unsigned char logo[] = {\n");
	printf("\t%d, /* width */\n", width);
	printf("\t%d, /* height */\n", height);

	for (y = 0; y < height; y++) {
		printf("\t");
		for (x = 0; x < width; x++) {
			printf("0x%02x, ", getchar());
		}
		printf("/* colors line %d */\n", y);
	}
	for (y = 0; y < height; y++) {
		for (x = 0; x < width; x++) {
			printf("\t");
			for (n = 0; n < 14; n++) {
				printf("0x%02x, ", getchar());
			}
			printf("/* pattern %d,%d */\n", x, y);
		}
	}

	printf("};\n");
}

static void
usage(int retval) __attribute__((__noreturn__));
static void
usage(int retval)
{
	fprintf(stderr, "Usage: %s < <infile> > <outfile>\n", progname);
	exit(retval);
}

int
main(int argc, char *argv[])
{
	int c;

	progname = *argv;

	while ((c = getopt(argc, argv, "")) != -1) {
		switch (c) {
		default:
			usage(1);
			/*NOTREACHED*/
		}
	}
	argc -= optind;
	argv += optind;

	if (argc != 0) {
		usage(1);
	}

	do_work();

	return 0;
}
