/*
 * $Id: conn_vga.c,v 1.10 2012-02-22 09:27:20 siflkres Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "conn_vga.h"

struct cpssp {
	struct sig_video_merge *forward_video;
	struct sig_i2c_bus_merge *forward_i2c_bus;
};

void *
conn_vga_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_vga *port_port_vga,
	struct sig_vga *port_vga
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_video = sig_video_merge(
			port_port_vga->video, port_vga->video);
	cpssp->forward_i2c_bus = sig_i2c_bus_merge(
			port_port_vga->ddc, port_vga->ddc);

	return cpssp;
}

void
conn_vga_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
conn_vga_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
conn_vga_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
