#ifndef __DOLFIN_H
#define __DOLFIN_H

// DOLFIN interface
// Autogeneration of SWIG interface is dependent on the comments about 
// SWIG modules. The order of the modules and the internal submodules 
// are important for the SWIG interface and 

// SWIG module common 
#include <dolfin/common/dolfin_common.h>
#include <dolfin/parameter/dolfin_parameter.h>
#include <dolfin/log/dolfin_log.h>

// SWIG module mesh
#include <dolfin/mesh/dolfin_mesh.h>
#include <dolfin/generation/dolfin_generation.h>
#include <dolfin/geometry/dolfin_geometry.h>
#include <dolfin/refinement/dolfin_refinement.h>
#include <dolfin/graph/dolfin_graph.h>

// SWIG module la
#include <dolfin/la/dolfin_la.h>
#include <dolfin/nls/dolfin_nls.h>

// SWIG module function
#include <dolfin/function/dolfin_function.h>
#include <dolfin/math/dolfin_math.h>
#include <dolfin/ale/dolfin_ale.h>

// SWIG module fem
#include <dolfin/fem/dolfin_fem.h>
#include <dolfin/multistage/dolfin_multistage.h>
#include <dolfin/adaptivity/dolfin_adaptivity.h>

// SWIG module io
#include <dolfin/io/dolfin_io.h>

#endif
