# Sample script to install Python and pip under Windows
# Authors: Olivier Grisel, Jonathan Helmus and Kyle Kastner
# License: CC0 1.0 Universal: https://creativecommons.org/publicdomain/zero/1.0/

# Adapted from VisPy

$MESA_GL_URL = "https://github.com/vispy/demo-data/raw/main/mesa/"

# Mesa DLLs found linked from:
#     https://wiki.qt.io/Cross_compiling_Mesa_for_Windows
# to:
#     http://sourceforge.net/projects/msys2/files/REPOS/MINGW/x86_64/mingw-w64-x86_64-mesa-10.2.4-1-any.pkg.tar.xz/download

function DownloadMesaOpenGL ($architecture) {
    [Net.ServicePointManager]::SecurityProtocol = 'Ssl3, Tls, Tls11, Tls12'
    $webclient = New-Object System.Net.WebClient
    # Download and retry up to 3 times in case of network transient errors.
    $url = $MESA_GL_URL + "opengl32_mingw_" + $architecture + ".dll"
    if ($architecture -eq "32") {
        $filepath = "C:\Windows\SysWOW64\opengl32.dll"
    } else {
        $filepath = "C:\Windows\system32\opengl32.dll"
    }
    takeown /F $filepath /A
    icacls $filepath /grant "${env:ComputerName}\${env:UserName}:F"
    Remove-item -LiteralPath $filepath
    Write-Output "Downloading" $url
    $retry_attempts = 2
    for($i=0; $i -lt $retry_attempts; $i++){
        try {
            $webclient.DownloadFile($url, $filepath)
            break
        }
        Catch [Exception]{
            Start-Sleep 1
        }
    }
    if (Test-Path $filepath) {
        Write-Output "File saved at" $filepath
    } else {
        # Retry once to get the error message if any at the last try
        $webclient.DownloadFile($url, $filepath)
    }
}


function main () {
    DownloadMesaOpenGL "64"
}

main
