/*
    Copyright (C) 2008-2010 Stefan Haller

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <glib.h>
#include <libintl.h>
#include <xfconf/xfconf.h>
#include "../misc/general.h"

#define _(message) dgettext(GETTEXT_PACKAGE_MODULE_XFCE, message)

void module_init()
{
	bindtextdomain(GETTEXT_PACKAGE_MODULE_XFCE, LOCALEDIR);

	GError * error = NULL;

	/* TODO: Call xfconf_shutdown() at the end */
	if (! xfconf_init(&error))
	{
		g_critical(_("Could not init xfconf: %s"), error->message);
		g_error_free(error);
	}
}

const gchar * module_get_gw_version()
{
	return VERSION;
}

const gchar * module_get_version()
{
	return VERSION_MODULE_XFCE_XFCONF;
}

const gchar * module_get_name()
{
	return _("Xfce (xfconf)");
}

const gchar * module_get_description()
{
	return _("This module enables Xfce-support with Xfconf. Use this " \
	         "this module for Xfce 4.6 or newer. If you have an older " \
	         "version of Xfce, you should use the other Xfce module.");
}

const gchar * module_get_author()
{
	return "Stefan Haller <haliner@googlemail.com>";
}

const gchar * module_get_homepage()
{
	return "http://launchpad.net/desktopnova";
}

void module_change_wallpaper(const gchar * filename)
{
	XfconfChannel * channel = xfconf_channel_get("xfce4-desktop");

	guint screen;
	guint monitor;
	gboolean empty;
	for (screen = 0; screen < 100; screen++)
	{
		empty = TRUE;
		for (monitor = 0; monitor < 100; monitor++)
		{
			const gchar * property = g_strdup_printf("/backdrop/screen%u/monitor%u/image-path", screen, monitor);

			if (! xfconf_channel_has_property(channel, property))
			{
				break;
			}
			empty = FALSE;

			xfconf_channel_set_string(channel, property, filename);
		}
		if (empty)
		{
			break;
		}
	}
}

#undef _
